/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.challenge.challenge;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.bank.BankManager;
import com.craftaro.skyblock.challenge.challenge.ChallengeCategory;
import com.craftaro.skyblock.challenge.challenge.ItemChallenge;
import com.craftaro.skyblock.challenge.challenge.Peer;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.hooks.economies.Economy;
import com.craftaro.skyblock.island.Island;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class Challenge {
    private final ChallengeCategory category;
    private final int id;
    private final String name;
    private final int maxTimes;
    private final boolean showInChat;
    private List<Peer<Type, Object>> requires;
    private List<Peer<Type, Object>> rewards;
    private final ItemChallenge item;

    public Challenge(ChallengeCategory category, int id, String name, int maxTimes, boolean showInChat, List<String> requires, List<String> rewards, ItemChallenge item) {
        this.category = category;
        this.id = id;
        this.name = name;
        this.maxTimes = maxTimes;
        this.showInChat = showInChat;
        this.item = item;
        item.setChallenge(this);
        this.loadChallenge(requires, rewards);
    }

    private void loadChallenge(List<String> requires, List<String> rewards) {
        Type t;
        String arg1;
        String arg0;
        int idx;
        this.requires = new ArrayList<Peer<Type, Object>>();
        this.rewards = new ArrayList<Peer<Type, Object>>();
        for (String str : requires) {
            idx = str.indexOf(58);
            if (idx == -1) {
                throw new IllegalArgumentException("Line \"" + str + "\" isn't a correct line");
            }
            arg0 = str.substring(0, idx);
            arg1 = str.substring(idx + 1);
            try {
                t = Type.valueOf(arg0);
                this.requires.add(new Peer<Type, Object>(t, t.convert(arg1)));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Invalid line : " + str + " : " + ex.getMessage());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid line : " + str);
            }
        }
        for (String str : rewards) {
            idx = str.indexOf(58);
            if (idx == -1) {
                throw new IllegalArgumentException("Line " + str + " isn't a correct line");
            }
            arg0 = str.substring(0, idx);
            arg1 = str.substring(idx + 1);
            try {
                t = Type.valueOf(arg0);
                this.rewards.add(new Peer<Type, Object>(t, t.convert(arg1)));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Invalid line : " + str + ": " + ex.getMessage());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid line : " + str);
            }
        }
    }

    public ChallengeCategory getCategory() {
        return this.category;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxTimes() {
        return this.maxTimes;
    }

    public boolean isShowInChat() {
        return this.showInChat;
    }

    public List<Peer<Type, Object>> getRequires() {
        return this.requires;
    }

    public List<Peer<Type, Object>> getRewards() {
        return this.rewards;
    }

    public ItemChallenge getItem() {
        return this.item;
    }

    public static enum Type {
        CHALLENGE{

            @Override
            public Object convert(String value) throws IllegalArgumentException {
                if (value == null || "".equalsIgnoreCase(value)) {
                    throw new IllegalArgumentException("Value is empty or null");
                }
                String[] test = value.split("\\.");
                if (test.length != 6) {
                    throw new IllegalArgumentException("Your config is not good, correct syntax : CHALLENGE:category.[id_category].challenges.[id_challenges].count.[count_times]");
                }
                ArrayList integerList = new ArrayList();
                Arrays.stream(test).filter(condition -> !condition.equalsIgnoreCase("category") && !condition.equalsIgnoreCase("challenges") && !condition.equalsIgnoreCase("count")).forEachOrdered(condition -> {
                    try {
                        integerList.add(Integer.parseInt(condition));
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("\"" + condition + "\" isn't a valid number (value = \"" + value + "\")");
                    }
                });
                return integerList;
            }

            @Override
            public boolean has(Player p, Object obj) {
                List is = (List)obj;
                SkyBlock instance = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
                FileManager.Config config = instance.getFileManager().getConfig(new File(new File(instance.getDataFolder(), "challenge-data"), p.getUniqueId().toString() + ".yml"));
                FileConfiguration fileConfig = config.getFileConfiguration();
                ConfigurationSection section = fileConfig.getConfigurationSection("challenges");
                for (String k : section != null ? section.getKeys(false) : new HashSet()) {
                    ConfigurationSection section2;
                    ChallengeCategory cc;
                    int id = fileConfig.getInt("challenges." + k + ".id");
                    if ((Integer)is.get(0) != id || (cc = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getFabledChallenge().getChallengeManager().getChallenge(id)) == null || (section2 = fileConfig.getConfigurationSection("challenges." + k + ".challenges")) == null || section2.getKeys(false).isEmpty() || !section2.getKeys(false).stream().map(d -> "challenges." + k + ".challenges." + d).anyMatch(key -> ((Integer)is.get(1)).intValue() == fileConfig.getInt(key + ".id") && fileConfig.getInt(key + ".count") >= (Integer)is.get(2))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void executeRequire(Player p, Object obj) {
            }

            @Override
            public void executeReward(Player p, Object obj) {
            }
        }
        ,
        ITEM{

            public ItemStack convert(String value) throws IllegalArgumentException {
                if (value == null || "".equalsIgnoreCase(value.trim())) {
                    throw new IllegalArgumentException("Value is empty or null");
                }
                int index = value.indexOf(32);
                String id = index == -1 ? value : value.substring(0, index);
                Optional<XMaterial> m = CompatibleMaterial.getMaterial(id);
                if (!m.isPresent()) {
                    throw new IllegalArgumentException("\"" + id + "\" isn't a correct Minecraft Material (value = \"" + value + "\")");
                }
                int amount = 1;
                if (index != -1) {
                    String strAmount = value.substring(index + 1);
                    try {
                        amount = Integer.parseInt(strAmount);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("\"" + strAmount + "\" isn't a correct number (value = \"" + value + "\")");
                    }
                }
                ItemStack item = m.get().parseItem();
                item.setAmount(amount);
                return item;
            }

            @Override
            public boolean has(Player p, Object obj) {
                boolean ignoreLore = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getConfiguration().getBoolean("Island.Challenge.IgnoreItemLore", false);
                if (obj instanceof ItemStack) {
                    ItemStack is = (ItemStack)obj;
                    XMaterial material = CompatibleMaterial.getMaterial(is.getType()).get();
                    if (ignoreLore) {
                        return this.findSimilar(p, material) >= is.getAmount();
                    }
                    return p.getInventory().containsAtLeast(is, is.getAmount());
                }
                return false;
            }

            private int findSimilar(Player p, XMaterial material) {
                int amountFound = 0;
                for (ItemStack item : p.getInventory().getContents()) {
                    if (!material.isSimilar(item)) continue;
                    amountFound += item.getAmount();
                }
                return amountFound;
            }

            @Override
            public void executeRequire(Player p, Object obj) {
                boolean ignoreLore = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getConfiguration().getBoolean("Island.Challenge.IgnoreItemLore", false);
                if (obj instanceof ItemStack) {
                    ItemStack is = (ItemStack)obj;
                    int toRemove = is.getAmount();
                    for (ItemStack jis : p.getInventory().getContents()) {
                        if (jis == null) continue;
                        if (ignoreLore ? CompatibleMaterial.getMaterial(is.getType()).get().isSimilar(jis) : jis.isSimilar(is)) {
                            if (jis.getAmount() <= toRemove) {
                                toRemove -= jis.getAmount();
                                p.getInventory().removeItem(new ItemStack[]{jis});
                            } else {
                                jis.setAmount(jis.getAmount() - toRemove);
                                toRemove = 0;
                            }
                        }
                        if (toRemove > 0) continue;
                        p.updateInventory();
                        break;
                    }
                }
            }

            @Override
            public void executeReward(Player p, Object obj) {
                ItemStack is = (ItemStack)obj;
                HashMap rest = p.getInventory().addItem(new ItemStack[]{is.clone()});
                for (ItemStack restIs : rest.values()) {
                    p.getWorld().dropItem(p.getLocation(), restIs);
                }
            }
        }
        ,
        CMD{

            @Override
            public String convert(String value) throws IllegalArgumentException {
                if (value == null || "".equalsIgnoreCase(value)) {
                    throw new IllegalArgumentException("Value is empty or null");
                }
                return value;
            }

            @Override
            public boolean has(Player p, Object obj) {
                return false;
            }

            @Override
            public void executeRequire(Player p, Object obj) {
            }

            @Override
            public void executeReward(Player p, Object obj) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)obj.toString().replaceAll("\\{player\\}", p.getName()));
            }
        }
        ,
        LEVEL{

            @Override
            public Integer convert(String value) throws IllegalArgumentException {
                if (value == null || "".equalsIgnoreCase(value)) {
                    throw new IllegalArgumentException("Value is empty or null");
                }
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("\"" + value + "\" isn't a correct number (value = \"" + value + "\")");
                }
            }

            @Override
            public boolean has(Player p, Object obj) {
                Island is = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getIslandManager().getIsland((OfflinePlayer)p);
                if (is != null && obj instanceof Number) {
                    return is.getLevel().getLevel() >= ((Number)obj).longValue();
                }
                return false;
            }

            @Override
            public void executeRequire(Player p, Object obj) {
            }

            @Override
            public void executeReward(Player p, Object obj) {
            }
        }
        ,
        NEAR{

            @Override
            public Peer<EntityType, Integer> convert(String value) throws IllegalArgumentException {
                EntityType et;
                if (value == null || "".equalsIgnoreCase(value)) {
                    throw new IllegalArgumentException("Value is empty or null");
                }
                int index = value.indexOf(32);
                String id = index == -1 ? value : value.substring(0, index);
                try {
                    et = EntityType.valueOf((String)id.toUpperCase());
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("\"" + id + "\" isn't a correct Minecraft EntityType (value = \"" + value + "\")");
                }
                int amount = 1;
                if (index != -1) {
                    String strAmount = value.substring(index + 1);
                    try {
                        amount = Integer.parseInt(strAmount);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("\"" + strAmount + "\" isn't a correct number (value = \"" + value + "\")");
                    }
                }
                return new Peer<EntityType, Integer>(et, amount);
            }

            @Override
            public boolean has(Player p, Object obj) {
                Peer peer = (Peer)obj;
                List entities = p.getNearbyEntities(60.0, 60.0, 60.0);
                int count = 0;
                for (Entity e : entities) {
                    if (e.getType() == peer.getKey()) {
                        ++count;
                    }
                    if (count != (Integer)peer.getValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void executeRequire(Player p, Object obj) {
            }

            @Override
            public void executeReward(Player p, Object obj) {
            }
        }
        ,
        POTION{
            private final Pattern space = Pattern.compile(" ");

            @Override
            public Peer<PotionType, Peer<Integer, Integer>> convert(String value) throws IllegalArgumentException {
                int amount;
                int data;
                PotionType pt;
                if (value == null || "".equalsIgnoreCase(value)) {
                    throw new IllegalArgumentException("Value is empty or null");
                }
                String[] split = this.space.split(value);
                if (split.length != 3) {
                    throw new IllegalArgumentException("Incorrect value : \"" + value + "\"");
                }
                try {
                    pt = PotionType.valueOf((String)split[0].toUpperCase());
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("\"" + split[0] + "\" isn't a correct Minecraft PotionType (value = \"" + value + "\")");
                }
                try {
                    data = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("\"" + split[1] + "\" isn't a correct number (value = \"" + value + "\")");
                }
                if (data < 0 || data > 8) {
                    throw new IllegalArgumentException("Data must be between 0 and 8, but is \"" + split[1] + "\"");
                }
                try {
                    amount = Integer.parseInt(split[2]);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("\"" + split[2] + "\" isn't a correct number (value = \"" + value + "\")");
                }
                return new Peer<PotionType, Peer<Integer, Integer>>(pt, new Peer<Integer, Integer>(data, amount));
            }

            @Override
            public boolean has(Player p, Object obj) {
                Peer peer = (Peer)obj;
                PlayerInventory inv = p.getInventory();
                int count = 0;
                for (ItemStack is : inv) {
                    if (is == null || is.getType() == Material.AIR || !this.isSame(is, (PotionType)peer.getKey(), (Integer)((Peer)peer.getValue()).getKey()) || (count += is.getAmount()) < (Integer)((Peer)peer.getValue()).getValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void executeRequire(Player p, Object obj) {
                Peer peer = (Peer)obj;
                PlayerInventory inv = p.getInventory();
                int rest = (Integer)((Peer)peer.getValue()).getValue();
                for (ItemStack is : inv) {
                    if (is == null || is.getType() == Material.AIR || !this.isSame(is, (PotionType)peer.getKey(), (Integer)((Peer)peer.getValue()).getKey())) continue;
                    if (rest > is.getAmount()) {
                        rest -= is.getAmount();
                        is.setAmount(0);
                        continue;
                    }
                    is.setAmount(is.getAmount() - rest);
                    p.updateInventory();
                    return;
                }
            }

            @Override
            public void executeReward(Player p, Object obj) {
                Peer peer = (Peer)obj;
                ItemStack is = null;
                int data = (Integer)((Peer)peer.getValue()).getKey();
                if (data <= 2) {
                    is = new ItemStack(Material.POTION, ((Integer)((Peer)peer.getValue()).getValue()).intValue());
                } else if (data <= 5) {
                    is = new ItemStack(Material.LINGERING_POTION, ((Integer)((Peer)peer.getValue()).getValue()).intValue());
                } else if (data <= 8) {
                    is = new ItemStack(Material.SPLASH_POTION, ((Integer)((Peer)peer.getValue()).getValue()).intValue());
                }
                PotionMeta pm = (PotionMeta)is.getItemMeta();
                pm.setBasePotionData(new PotionData((PotionType)peer.getKey(), data == 1 || data == 4 || data == 7, data == 2 || data == 5 || data == 8));
                is.setItemMeta((ItemMeta)pm);
                HashMap rest = p.getInventory().addItem(new ItemStack[]{is});
                for (ItemStack restIs : rest.values()) {
                    p.getWorld().dropItem(p.getLocation(), restIs);
                }
            }

            private boolean isSame(ItemStack is, PotionType type, int data) {
                if (data <= 2 && is.getType() != Material.POTION) {
                    return false;
                }
                if (data >= 3 && data <= 5 && is.getType() != Material.LINGERING_POTION) {
                    return false;
                }
                if (data >= 6 && data <= 8 && is.getType() != Material.SPLASH_POTION) {
                    return false;
                }
                PotionMeta pm = (PotionMeta)is.getItemMeta();
                PotionData pd = pm.getBasePotionData();
                if (pd.getType() != type) {
                    return false;
                }
                if ((data == 0 || data == 3 || data == 6) && (pd.isExtended() || pd.isUpgraded())) {
                    return false;
                }
                if (!(data != 1 && data != 4 && data != 7 || pd.isExtended())) {
                    return false;
                }
                return data != 2 && data != 5 && data != 8 || pd.isUpgraded();
            }
        }
        ,
        ECO{

            @Override
            public Double convert(String value) throws IllegalArgumentException {
                if (value == null || "".equalsIgnoreCase(value)) {
                    throw new IllegalArgumentException("Value is empty or null");
                }
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("\"" + value + "\" isn't a correct number (value = \"" + value + "\")");
                }
            }

            @Override
            public boolean has(Player p, Object obj) {
                Economy economy = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getEconomyManager().getEconomy();
                if (economy == null) {
                    SkyBlock.getInstance().getLogger().warning("No compatible economy plugin found \u2013 Please check your configuration");
                    return false;
                }
                if (obj instanceof Number) {
                    return economy.getBalance((OfflinePlayer)p) >= ((Number)obj).doubleValue();
                }
                return false;
            }

            @Override
            public void executeRequire(Player p, Object obj) {
                Economy economy = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getEconomyManager().getEconomy();
                if (obj instanceof Number && ((Number)obj).doubleValue() > 0.0) {
                    economy.withdrawBalance((OfflinePlayer)p, ((Number)obj).doubleValue());
                }
            }

            @Override
            public void executeReward(Player p, Object obj) {
                Economy economy = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getEconomyManager().getEconomy();
                if (obj instanceof Number && ((Number)obj).doubleValue() > 0.0) {
                    economy.deposit((OfflinePlayer)p, ((Number)obj).doubleValue());
                }
            }
        }
        ,
        BANK{

            @Override
            public Double convert(String value) throws IllegalArgumentException {
                if (value == null || "".equalsIgnoreCase(value)) {
                    throw new IllegalArgumentException("Value is empty or null");
                }
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("\"" + value + "\" isn't a correct number (value = \"" + value + "\")");
                }
            }

            @Override
            public boolean has(Player p, Object obj) {
                Island is = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getIslandManager().getIsland((OfflinePlayer)p);
                if (is != null && obj instanceof Number && ((Number)obj).doubleValue() > 0.0) {
                    return is.getBankBalance() >= ((Number)obj).doubleValue();
                }
                return false;
            }

            @Override
            public void executeRequire(Player p, Object obj) {
                Island is = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getIslandManager().getIsland((OfflinePlayer)p);
                BankManager bankManager = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getBankManager();
                if (is != null && obj instanceof Number && ((Number)obj).doubleValue() > 0.0) {
                    bankManager.withdraw(p, is, ((Number)obj).doubleValue(), false);
                }
            }

            @Override
            public void executeReward(Player p, Object obj) {
                Island is = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getIslandManager().getIsland((OfflinePlayer)p);
                BankManager bankManager = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getBankManager();
                if (is != null && obj instanceof Number) {
                    bankManager.deposit(p, is, ((Number)obj).doubleValue(), false);
                }
            }
        };


        public abstract Object convert(String var1) throws IllegalArgumentException;

        public abstract boolean has(Player var1, Object var2);

        public abstract void executeRequire(Player var1, Object var2);

        public abstract void executeReward(Player var1, Object var2);
    }
}

