/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.blockscanner;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.blockscanner.CachedChunk;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.island.IslandWorld;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkLoader
extends BukkitRunnable {
    public final List<CachedChunk> positions = new LinkedList<CachedChunk>();
    private ChunkScannerTask generalTask;
    private ChunkForChunkScannerTask chunkTask;
    private final boolean chunkForChunk;
    private final boolean paper;
    private World world;
    private final Island island;
    private int x;
    private int z;
    private int minZ;
    private int maxX;
    private int maxZ;
    private final int chunkPerTick = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getConfiguration().getInt("Island.Performance.ChunkPerTick", 25);
    private final CompleteTask completeTask;

    private ChunkLoader(Island island, IslandWorld islandWorld, boolean paper, boolean chunkForChunk, ChunkForChunkScannerTask chunkTask, CompleteTask complete) {
        this.completeTask = complete;
        this.chunkTask = chunkTask;
        this.chunkForChunk = chunkForChunk;
        this.paper = paper;
        this.island = island;
        Location islandLocation = island.getLocation(islandWorld, IslandEnvironment.ISLAND);
        if (islandLocation == null) {
            return;
        }
        this.world = islandLocation.getWorld();
        Location minLocation = new Location(this.world, (double)islandLocation.getBlockX() - island.getRadius(), 0.0, (double)islandLocation.getBlockZ() - island.getRadius());
        Location maxLocation = new Location(this.world, (double)islandLocation.getBlockX() + island.getRadius(), (double)this.world.getMaxHeight(), (double)islandLocation.getBlockZ() + island.getRadius());
        int minX = Math.min(maxLocation.getBlockX(), minLocation.getBlockX()) >> 4 << 4;
        this.minZ = Math.min(maxLocation.getBlockZ(), minLocation.getBlockZ()) >> 4 << 4;
        this.maxX = Math.max(maxLocation.getBlockX(), minLocation.getBlockX()) >> 4 << 4 | 0xF;
        this.maxZ = Math.max(maxLocation.getBlockZ(), minLocation.getBlockZ()) >> 4 << 4 | 0xF;
        this.x = minX;
        this.z = this.minZ;
        if (paper) {
            this.runTaskAsynchronously((Plugin)SkyBlock.getPlugin(SkyBlock.class));
        } else {
            this.runTaskTimer((Plugin)SkyBlock.getPlugin(SkyBlock.class), 1L, 0L);
        }
    }

    private ChunkLoader(Island island, IslandWorld islandWorld, boolean paper, boolean chunkForChunk, ChunkScannerTask generalTask, CompleteTask complete) {
        this.completeTask = complete;
        this.generalTask = generalTask;
        this.chunkForChunk = chunkForChunk;
        this.paper = paper;
        this.island = island;
        Location islandLocation = island.getLocation(islandWorld, IslandEnvironment.ISLAND);
        if (islandLocation == null) {
            return;
        }
        this.world = islandLocation.getWorld();
        Location minLocation = new Location(this.world, (double)islandLocation.getBlockX() - island.getRadius(), 0.0, (double)islandLocation.getBlockZ() - island.getRadius());
        Location maxLocation = new Location(this.world, (double)islandLocation.getBlockX() + island.getRadius(), (double)this.world.getMaxHeight(), (double)islandLocation.getBlockZ() + island.getRadius());
        int minX = Math.min(maxLocation.getBlockX(), minLocation.getBlockX()) >> 4 << 4;
        this.minZ = Math.min(maxLocation.getBlockZ(), minLocation.getBlockZ()) >> 4 << 4;
        this.maxX = Math.max(maxLocation.getBlockX(), minLocation.getBlockX()) >> 4 << 4 | 0xF;
        this.maxZ = Math.max(maxLocation.getBlockZ(), minLocation.getBlockZ()) >> 4 << 4 | 0xF;
        this.x = minX;
        this.z = this.minZ;
        if (paper) {
            this.runTaskAsynchronously((Plugin)SkyBlock.getPlugin(SkyBlock.class));
        } else {
            this.runTaskTimer((Plugin)SkyBlock.getPlugin(SkyBlock.class), 1L, 0L);
        }
    }

    public void run() {
        for (int i = 0; i < this.chunkPerTick || this.paper; ++i) {
            if (this.x <= this.maxX) {
                if (this.z <= this.maxZ) {
                    if (!this.chunkForChunk) {
                        this.positions.add(new CachedChunk(this.world, this.x >> 4, this.z >> 4));
                    } else if (this.chunkTask != null) {
                        this.chunkTask.onChunkComplete(new CachedChunk(this.world, this.x >> 4, this.z >> 4));
                    }
                    this.z += 16;
                    continue;
                }
                this.z = this.minZ;
                this.x += 16;
                continue;
            }
            if (this.generalTask != null) {
                this.generalTask.onComplete(this.positions);
            }
            if (this.completeTask != null) {
                this.completeTask.onComplete(this.island);
            }
            this.cancel();
            return;
        }
    }

    public static void startChunkLoading(Island island, IslandWorld islandWorld, boolean paper, ChunkScannerTask task, CompleteTask complete) {
        new ChunkLoader(island, islandWorld, paper, false, task, complete);
    }

    public static void startChunkLoadingPerChunk(Island island, IslandWorld islandWorld, boolean paper, ChunkForChunkScannerTask task, CompleteTask complete) {
        new ChunkLoader(island, islandWorld, paper, true, task, complete);
    }

    public static interface CompleteTask {
        public void onComplete(Island var1);
    }

    public static interface ChunkForChunkScannerTask {
        public void onChunkComplete(CachedChunk var1);
    }

    public static interface ChunkScannerTask {
        public void onComplete(List<CachedChunk> var1);
    }
}

