/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.blockscanner;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.blockscanner.BlockInfo;
import com.craftaro.skyblock.blockscanner.CachedChunk;
import com.craftaro.skyblock.blockscanner.LocationBounds;
import com.craftaro.skyblock.blockscanner.MaterialIDHelper;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.island.IslandEnvironment;
import com.craftaro.skyblock.utils.world.WorldUtil;
import com.craftaro.skyblock.world.WorldManager;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Lists;
import io.papermc.lib.PaperLib;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class BlockScanner
extends BukkitRunnable {
    private static final Method ID_FIELD;
    private static final int MAX_CHUNKS_PER_ITERATION = 2;
    private static final int MAX_EMPTY_ITERATIONS = 20;
    private final AtomicInteger completedNum;
    private final int threadCount;
    private final Queue<BlockInfo> blocks;
    private final ScannerTasks tasks;
    private final Island island;
    private final boolean ignoreLiquids;
    private final boolean ignoreAir;

    public static int getBlockTypeID(CachedChunk chunk, int x, int y, int z) {
        int id = 0;
        try {
            id = (Integer)ID_FIELD.invoke((Object)chunk.getSnapshot(), x, y, z);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return id;
    }

    private BlockScanner(Map<World, List<CachedChunk>> snapshots, Island island, boolean ignoreLiquids, boolean ignoreLiquidsY, boolean ignoreAir, boolean ignoreY, ScannerTasks tasks) {
        this.ignoreLiquids = ignoreLiquids;
        this.ignoreAir = ignoreAir;
        this.blocks = new ConcurrentLinkedQueue<BlockInfo>();
        this.tasks = tasks;
        this.completedNum = new AtomicInteger();
        this.island = island;
        FileConfiguration config = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getConfiguration();
        int threadCount = 0;
        for (Map.Entry<World, List<CachedChunk>> entry : snapshots.entrySet()) {
            String env;
            List parts = Lists.partition(entry.getValue(), (int)16);
            threadCount += parts.size();
            World world = entry.getKey();
            switch (world.getEnvironment()) {
                case NETHER: {
                    env = "Nether";
                    break;
                }
                case THE_END: {
                    env = "End";
                    break;
                }
                default: {
                    env = "Normal";
                }
            }
            ConfigurationSection liquidSection = config.getConfigurationSection("Island.World." + env + ".Liquid");
            int startY = ignoreY ? world.getMaxHeight() : (!ignoreLiquidsY && liquidSection.getBoolean("Enable") && !config.getBoolean("Island.Levelling.ScanLiquid") ? liquidSection.getInt("Height") + 1 : WorldUtil.getMinHeight(world));
            for (List sub : parts) {
                this.queueWork(world, startY, sub);
            }
        }
        this.threadCount = threadCount;
    }

    private void queueWork(World world, int scanY, List<CachedChunk> subList) {
        WorldManager worldManager = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getWorldManager();
        ArrayList<CachedChunk> pendingChunks = new ArrayList<CachedChunk>();
        ArrayList<CachedChunk> readyChunks = new ArrayList<CachedChunk>();
        ReentrantLock lock = new ReentrantLock();
        Condition emptyCondition = lock.newCondition();
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)SkyBlock.getPlugin(SkyBlock.class), () -> {
            lock.lock();
            LocationBounds bounds = null;
            if (this.island != null) {
                Location islandLocation = this.island.getLocation(worldManager.getIslandWorld(world), IslandEnvironment.ISLAND);
                Location minLocation = new Location(world, (double)islandLocation.getBlockX() - this.island.getRadius(), (double)WorldUtil.getMinHeight(world), (double)islandLocation.getBlockZ() - this.island.getRadius());
                Location maxLocation = new Location(world, (double)islandLocation.getBlockX() + this.island.getRadius(), (double)world.getMaxHeight(), (double)islandLocation.getBlockZ() + this.island.getRadius());
                int minX = Math.min(maxLocation.getBlockX(), minLocation.getBlockX());
                int minZ = Math.min(maxLocation.getBlockZ(), minLocation.getBlockZ());
                int maxX = Math.max(maxLocation.getBlockX(), minLocation.getBlockX());
                int maxZ = Math.max(maxLocation.getBlockZ(), minLocation.getBlockZ());
                bounds = new LocationBounds(minX, minZ, maxX, maxZ);
            }
            for (CachedChunk shot : subList) {
                if (!shot.isSnapshotAvailable() && !this.areAsyncChunksAvailable()) {
                    pendingChunks.add(shot);
                    continue;
                }
                this.processCachedChunk(world, scanY, shot, bounds);
            }
            if (this.areAsyncChunksAvailable()) {
                this.increment();
                lock.unlock();
                return;
            }
            try {
                emptyCondition.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            for (CachedChunk shot : readyChunks) {
                this.processCachedChunk(world, scanY, shot, bounds);
            }
            lock.unlock();
            this.increment();
        });
        if (!this.areAsyncChunksAvailable()) {
            this.startChunkSnapshotTask(pendingChunks, readyChunks, emptyCondition, lock);
        }
    }

    private boolean areAsyncChunksAvailable() {
        return PaperLib.isVersion(9) && PaperLib.isPaper();
    }

    private void startChunkSnapshotTask(final List<CachedChunk> pendingChunks, final List<CachedChunk> readyChunks, final Condition emptyCondition, final Lock lock) {
        new BukkitRunnable(){
            private int emptyIterations = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                lock.lock();
                int updatedChunks = 0;
                Iterator chunkIterator = pendingChunks.iterator();
                try {
                    while (chunkIterator.hasNext()) {
                        CachedChunk pendingChunk = (CachedChunk)chunkIterator.next();
                        if (updatedChunks >= 2) break;
                        pendingChunk.takeSnapshot();
                        chunkIterator.remove();
                        readyChunks.add(pendingChunk);
                        ++updatedChunks;
                    }
                    if (pendingChunks.isEmpty()) {
                        if (this.emptyIterations >= 20) {
                            emptyCondition.signalAll();
                            this.cancel();
                            return;
                        }
                        ++this.emptyIterations;
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }.runTaskTimer((Plugin)SkyBlock.getPlugin(SkyBlock.class), 1L, 1L);
    }

    private void processCachedChunk(World world, int scanY, CachedChunk shot, LocationBounds bounds) {
        int cX = shot.getX() << 4;
        int cZ = shot.getZ() << 4;
        int initX = 0;
        int initZ = 0;
        int lastX = 15;
        int lastZ = 15;
        if (bounds != null) {
            initX = Math.max(cX, bounds.getMinX()) & 0xF;
            initZ = Math.max(cZ, bounds.getMinZ()) & 0xF;
            lastX = Math.min(cX | 0xF, bounds.getMaxX() - 1) & 0xF;
            lastZ = Math.min(cZ | 0xF, bounds.getMaxZ() - 1) & 0xF;
        }
        for (int x = initX; x <= lastX; ++x) {
            for (int z = initZ; z <= lastZ; ++z) {
                for (int y = scanY; y < world.getMaxHeight(); ++y) {
                    Optional<XMaterial> type = CompatibleMaterial.getMaterial(MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_13) ? shot.getSnapshot().getBlockType(x, y, z) : MaterialIDHelper.getLegacyMaterial(BlockScanner.getBlockTypeID(shot, x, y, z)));
                    if (!type.isPresent() || CompatibleMaterial.isAir(type.get()) && this.ignoreAir || type.get() == XMaterial.WATER && this.ignoreLiquids) continue;
                    this.blocks.add(new BlockInfo(world, x + cX, y, z + cZ));
                }
            }
        }
    }

    private synchronized int increment() {
        return this.completedNum.getAndIncrement();
    }

    private synchronized int get() {
        return this.completedNum.get();
    }

    public void run() {
        if (this.get() != this.threadCount) {
            return;
        }
        this.tasks.onComplete(this.blocks);
        this.cancel();
    }

    public static void startScanner(Map<World, List<CachedChunk>> snapshots, Island island, boolean ignoreLiquids, boolean ignoreLiquidsY, boolean ignoreAir, boolean ignoreY, ScannerTasks tasks) {
        if (snapshots == null) {
            throw new IllegalArgumentException("snapshots cannot be null");
        }
        if (tasks == null) {
            throw new IllegalArgumentException("tasks cannot be null");
        }
        BlockScanner scanner = new BlockScanner(snapshots, island, ignoreLiquids, ignoreLiquidsY, ignoreAir, ignoreY, tasks);
        scanner.runTaskTimer((Plugin)SkyBlock.getPlugin(SkyBlock.class), 5L, 5L);
    }

    static {
        Method temp = null;
        try {
            temp = ChunkSnapshot.class.getMethod("getBlockTypeId", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        ID_FIELD = temp;
    }

    public static interface ScannerTasks {
        public void onComplete(Queue<BlockInfo> var1);
    }
}

