/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.bank;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.bank.Transaction;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.core.hooks.EconomyManager;
import com.craftaro.skyblock.core.hooks.economies.Economy;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.playerdata.PlayerData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class BankManager {
    private final HashMap<UUID, List<Transaction>> log;
    private final SkyBlock plugin;
    public FileConfiguration lang;

    public BankManager(SkyBlock plugin) {
        this.plugin = plugin;
        this.lang = this.plugin.getLanguage();
        this.log = new HashMap();
        this.loadTransactions();
    }

    public List<Transaction> getTransactions(Player player) {
        return this.getTransactions(player.getUniqueId());
    }

    public List<Transaction> getTransactions(UUID uuid) {
        if (this.log.containsKey(uuid) && this.log.get(uuid) != null && !this.log.get(uuid).isEmpty()) {
            return new ArrayList<Transaction>((Collection)this.log.get(uuid));
        }
        return new ArrayList<Transaction>();
    }

    public void addTransaction(Player p, Transaction transaction) {
        if (this.log.containsKey(p.getUniqueId())) {
            this.log.get(p.getUniqueId()).add(transaction);
        } else {
            ArrayList<Transaction> t = new ArrayList<Transaction>();
            t.add(transaction);
            this.log.put(p.getUniqueId(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTransactions() {
        Map<UUID, PlayerData> playerDataStorage;
        Map<UUID, PlayerData> map = playerDataStorage = SkyBlock.getInstance().getPlayerDataManager().getPlayerData();
        synchronized (map) {
            for (UUID uid : playerDataStorage.keySet()) {
                this.log.put(uid, playerDataStorage.get(uid).getTransactions());
            }
        }
    }

    public List<String> getBalanceLore(Player player) {
        Economy economy = this.plugin.getEconomyManager().getEconomy();
        ArrayList<String> result = new ArrayList<String>();
        result.add("Some error occurred while loading your balance!");
        Island island = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getIslandManager().getIsland((OfflinePlayer)player);
        result.add("If this is null then its a easy to fix bug: " + island.toString());
        if (island != null) {
            double accountBalance = 0.0;
            if (economy != null) {
                accountBalance = economy.getBalance((OfflinePlayer)player);
            }
            result.clear();
            result.add(player.getDisplayName() + "'s balance is " + EconomyManager.formatEconomy(accountBalance));
            result.add(player.getDisplayName() + "'s island has " + EconomyManager.formatEconomy(island.getBankBalance()));
        }
        return result;
    }

    public List<Transaction> getTransactionList(Player player) {
        return this.getTransactionList(player.getUniqueId());
    }

    public List<Transaction> getTransactionList(UUID uuid) {
        return this.log.get(uuid);
    }

    public BankResponse deposit(Player player, Island island, double amt, boolean admin) {
        int intAmt;
        Economy economy = this.plugin.getEconomyManager().getEconomy();
        FileManager fileManager = this.plugin.getFileManager();
        if (amt <= 0.0) {
            return BankResponse.NEGATIVE_AMOUNT;
        }
        if (!this.plugin.getConfiguration().getBoolean("Island.Bank.AllowDecimals") && (double)(intAmt = (int)amt) != amt) {
            return BankResponse.DECIMALS_NOT_ALLOWED;
        }
        if (!admin) {
            if (economy == null || !economy.hasBalance((OfflinePlayer)player, amt)) {
                if (economy == null) {
                    this.plugin.getLogger().warning("No compatible economy plugin found \u2013 Please check your configuration");
                }
                return BankResponse.NOT_ENOUGH_MONEY;
            }
            economy.withdrawBalance((OfflinePlayer)player, amt);
        }
        island.addToBank(amt);
        Transaction t = new Transaction();
        t.player = player;
        t.amount = (float)amt;
        t.timestamp = Calendar.getInstance().getTime();
        t.action = Transaction.Type.DEPOSIT;
        t.visibility = admin ? Transaction.Visibility.ADMIN : Transaction.Visibility.USER;
        this.addTransaction(player, t);
        return BankResponse.SUCCESS;
    }

    public BankResponse withdraw(Player player, Island island, double amt, boolean admin) {
        int intAmt;
        Economy economy = this.plugin.getEconomyManager().getEconomy();
        if (amt <= 0.0) {
            return BankResponse.NEGATIVE_AMOUNT;
        }
        if (!this.plugin.getConfiguration().getBoolean("Island.Bank.AllowDecimals") && (double)(intAmt = (int)amt) != amt) {
            return BankResponse.DECIMALS_NOT_ALLOWED;
        }
        if (!admin) {
            if (economy == null || amt > island.getBankBalance()) {
                if (economy == null) {
                    this.plugin.getLogger().warning("No compatible economy plugin found \u2013 Please check your configuration");
                }
                return BankResponse.NOT_ENOUGH_MONEY;
            }
            economy.deposit((OfflinePlayer)player, amt);
        }
        island.removeFromBank(amt);
        Transaction t = new Transaction();
        t.player = player;
        t.amount = (float)amt;
        t.timestamp = Calendar.getInstance().getTime();
        t.action = Transaction.Type.WITHDRAW;
        t.visibility = admin ? Transaction.Visibility.ADMIN : Transaction.Visibility.USER;
        this.addTransaction(player, t);
        return BankResponse.SUCCESS;
    }

    public static enum BankResponse {
        NOT_ENOUGH_MONEY,
        DECIMALS_NOT_ALLOWED,
        NEGATIVE_AMOUNT,
        SUCCESS;

    }
}

