/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.ban;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.ban.Ban;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.island.Island;
import com.craftaro.skyblock.message.MessageManager;
import com.craftaro.skyblock.sound.SoundManager;
import com.craftaro.skyblock.third_party.com.eatthepath.uuid.FastUUID;
import com.craftaro.skyblock.utils.world.LocationUtil;
import com.craftaro.third_party.com.cryptomorin.xseries.XSound;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class BanManager {
    private final SkyBlock plugin;
    private final Map<UUID, Ban> banStorage = new HashMap<UUID, Ban>();

    public BanManager(SkyBlock plugin) {
        this.plugin = plugin;
        this.loadIslands();
    }

    public void onDisable() {
        Map<UUID, Ban> banIslands = this.getIslands();
        for (Ban ban : banIslands.values()) {
            ban.save();
        }
    }

    public void loadIslands() {
        File configFile;
        if (!this.plugin.getConfiguration().getBoolean("Island.Visitor.Unload") && (configFile = new File(this.plugin.getDataFolder(), "island-data")).exists()) {
            for (File fileList : configFile.listFiles()) {
                UUID islandOwnerUUID = FastUUID.parseUUID(fileList.getName().replaceFirst("[.][^.]+$", ""));
                this.createIsland(islandOwnerUUID);
            }
        }
    }

    public void transfer(UUID uuid1, UUID uuid2) {
        FileManager fileManager = this.plugin.getFileManager();
        Ban ban = this.getIsland(uuid1);
        ban.save();
        File oldBanDataFile = new File(new File(this.plugin.getDataFolder(), "ban-data"), FastUUID.toString(uuid1) + ".yml");
        File newBanDataFile = new File(new File(this.plugin.getDataFolder(), "ban-data"), FastUUID.toString(uuid2) + ".yml");
        fileManager.unloadConfig(oldBanDataFile);
        fileManager.unloadConfig(newBanDataFile);
        oldBanDataFile.renameTo(newBanDataFile);
        this.removeIsland(uuid1);
        this.addIsland(uuid2, ban);
    }

    public void removeVisitor(Island island) {
        MessageManager messageManager = this.plugin.getMessageManager();
        SoundManager soundManager = this.plugin.getSoundManager();
        FileConfiguration configLoad = this.plugin.getLanguage();
        for (UUID visitorList : this.plugin.getIslandManager().getVisitorsAtIsland(island)) {
            Player targetPlayer = Bukkit.getServer().getPlayer(visitorList);
            LocationUtil.teleportPlayerToSpawn(targetPlayer);
            messageManager.sendMessage((CommandSender)targetPlayer, configLoad.getString("Island.Visit.Banned.Island.Message"));
            soundManager.playSound((CommandSender)targetPlayer, XSound.ENTITY_ENDERMAN_TELEPORT);
        }
    }

    public boolean hasIsland(UUID islandOwnerUUID) {
        return this.banStorage.containsKey(islandOwnerUUID);
    }

    public Ban getIsland(UUID islandOwnerUUID) {
        return this.banStorage.get(islandOwnerUUID);
    }

    public Map<UUID, Ban> getIslands() {
        return this.banStorage;
    }

    public void createIsland(UUID islandOwnerUUID) {
        this.banStorage.put(islandOwnerUUID, new Ban(islandOwnerUUID));
    }

    public void addIsland(UUID islandOwnerUUID, Ban ban) {
        this.banStorage.put(islandOwnerUUID, ban);
    }

    public void removeIsland(UUID islandOwnerUUID) {
        this.banStorage.remove(islandOwnerUUID);
    }

    public void unloadIsland(UUID islandOwnerUUID) {
        if (this.hasIsland(islandOwnerUUID)) {
            this.plugin.getFileManager().unloadConfig(new File(new File(this.plugin.getDataFolder(), "ban-data"), islandOwnerUUID.toString() + ".yml"));
            this.banStorage.remove(islandOwnerUUID);
        }
    }

    public void deleteIsland(UUID islandOwnerUUID) {
        if (this.hasIsland(islandOwnerUUID)) {
            this.plugin.getFileManager().deleteConfig(new File(new File(this.plugin.getDataFolder(), "ban-data"), islandOwnerUUID.toString() + ".yml"));
            this.banStorage.remove(islandOwnerUUID);
        }
    }
}

