/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.ban;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.event.island.IslandBanEvent;
import com.craftaro.skyblock.api.event.island.IslandUnbanEvent;
import com.craftaro.skyblock.config.FileManager;
import com.craftaro.skyblock.third_party.com.eatthepath.uuid.FastUUID;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class Ban {
    private UUID islandOwnerUUID;

    public Ban(UUID islandOwnerUUID) {
        this.islandOwnerUUID = islandOwnerUUID;
    }

    public UUID getOwnerUUID() {
        return this.islandOwnerUUID;
    }

    public void setOwnerUUID(UUID islandOwnerUUID) {
        this.islandOwnerUUID = islandOwnerUUID;
    }

    public boolean isBanned(UUID uuid) {
        return this.getBans().contains(uuid);
    }

    public Set<UUID> getBans() {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        HashSet<UUID> islandBans = new HashSet<UUID>();
        for (String islandBanList : plugin.getFileManager().getConfig(new File(new File(plugin.getDataFolder(), "ban-data"), FastUUID.toString(this.islandOwnerUUID) + ".yml")).getFileConfiguration().getStringList("Bans")) {
            UUID uuid = FastUUID.parseUUID(islandBanList);
            if (!Bukkit.getOfflinePlayer((UUID)uuid).hasPlayedBefore()) continue;
            islandBans.add(uuid);
        }
        return islandBans;
    }

    public void addBan(UUID issuer, UUID banned) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        IslandBanEvent islandBanEvent = new IslandBanEvent(plugin.getIslandManager().getIsland(Bukkit.getServer().getOfflinePlayer(this.islandOwnerUUID)).getAPIWrapper(), Bukkit.getServer().getOfflinePlayer(issuer), Bukkit.getServer().getOfflinePlayer(banned));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> Bukkit.getServer().getPluginManager().callEvent((Event)islandBanEvent));
        if (!islandBanEvent.isCancelled()) {
            FileConfiguration configLoad = plugin.getFileManager().getConfig(new File(new File(plugin.getDataFolder().toString() + "/ban-data"), FastUUID.toString(this.islandOwnerUUID) + ".yml")).getFileConfiguration();
            ArrayList<String> islandBans = new ArrayList<String>(configLoad.getStringList("Bans"));
            islandBans.add(banned.toString());
            configLoad.set("Bans", islandBans);
        }
    }

    public void removeBan(UUID uuid) {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        ArrayList<String> islandBans = new ArrayList<String>();
        FileConfiguration configLoad = plugin.getFileManager().getConfig(new File(new File(plugin.getDataFolder().toString() + "/ban-data"), this.islandOwnerUUID.toString() + ".yml")).getFileConfiguration();
        for (String islandBanList : configLoad.getStringList("Bans")) {
            if (FastUUID.toString(uuid).equals(islandBanList)) continue;
            islandBans.add(islandBanList);
        }
        configLoad.set("Bans", islandBans);
        Bukkit.getServer().getPluginManager().callEvent((Event)new IslandUnbanEvent(plugin.getIslandManager().getIsland(Bukkit.getServer().getOfflinePlayer(this.islandOwnerUUID)).getAPIWrapper(), Bukkit.getServer().getOfflinePlayer(uuid)));
    }

    public void save() {
        SkyBlock plugin = (SkyBlock)SkyBlock.getPlugin(SkyBlock.class);
        FileManager.Config config = plugin.getFileManager().getConfig(new File(new File(plugin.getDataFolder(), "ban-data"), this.islandOwnerUUID.toString() + ".yml"));
        try {
            config.getFileConfiguration().save(config.getFile());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

