/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.api.visit;

import com.craftaro.skyblock.api.island.Island;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.UUID;

public class Visit {
    private final Island handle;

    public Visit(Island handle) {
        this.handle = handle;
    }

    public int getSafeLevel() {
        return this.handle.getIsland().getVisit().getSafeLevel();
    }

    public void setSafeLevel(int safeLevel) {
        this.handle.getIsland().getVisit().setSafeLevel(safeLevel);
    }

    public boolean isVisitor(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot return condition to null uuid");
        return this.getVisitors().contains(uuid);
    }

    public Set<UUID> getVisitors() {
        return this.handle.getIsland().getVisit().getVisitors();
    }

    public void addVisitor(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot add visitor to null uuid");
        this.handle.getIsland().getVisit().addVisitor(uuid);
    }

    public void removeVisitor(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot remove visitor to null uuid");
        this.handle.getIsland().getVisit().removeVisitor(uuid);
    }

    public boolean isVoter(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot return condition to null uuid");
        return this.getVoters().contains(uuid);
    }

    public Set<UUID> getVoters() {
        return this.handle.getIsland().getVisit().getVoters();
    }

    public void addVoter(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot add voter to null uuid");
        this.handle.getIsland().getVisit().addVoter(uuid);
    }

    public void removeVoter(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot remove voter to null uuid");
        this.handle.getIsland().getVisit().removeVoter(uuid);
    }

    public Island getIsland() {
        return this.handle;
    }
}

