/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.api.levelling;

import com.craftaro.skyblock.api.island.Island;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.skyblock.levelling.IslandLevelManager;
import com.craftaro.skyblock.levelling.calculator.Calculator;
import com.craftaro.skyblock.levelling.calculator.CalculatorRegistry;
import com.google.common.base.Preconditions;
import org.bukkit.Material;

public class LevellingManager {
    private final IslandLevelManager levellingManager;

    public LevellingManager(IslandLevelManager levellingManager) {
        this.levellingManager = levellingManager;
    }

    public void calculatePoints(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot calculate points to null island");
        this.levellingManager.startScan(null, island.getIsland());
    }

    public void registerCalculator(Calculator calculator, Material material) {
        Preconditions.checkArgument((calculator != null ? 1 : 0) != 0, (Object)"Cannot use a null calculator");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Cannot use a null material");
        CalculatorRegistry.registerCalculator(calculator, CompatibleMaterial.getMaterial(material).get());
    }
}

