/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.api.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.island.Island;
import com.craftaro.skyblock.api.island.IslandWorld;
import com.craftaro.skyblock.api.utils.APIUtil;
import com.craftaro.skyblock.permission.PermissionManager;
import com.craftaro.skyblock.structure.Structure;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class IslandManager {
    private final com.craftaro.skyblock.island.IslandManager islandManager;
    private final PermissionManager permissionManager;

    public IslandManager(com.craftaro.skyblock.island.IslandManager islandManager) {
        this.islandManager = islandManager;
        this.permissionManager = ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getPermissionManager();
    }

    public static boolean hasIsland(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot check island to null player");
        return new com.craftaro.skyblock.utils.player.OfflinePlayer(player.getUniqueId()).getOwner() != null;
    }

    public void updateBorder(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot update border to null island");
        this.islandManager.updateBorder(island.getIsland());
    }

    public void giveOwnership(Island island, OfflinePlayer player) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot give ownership to null island");
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot give ownership to null player");
        this.islandManager.giveOwnership(island.getIsland(), player);
    }

    public Set<UUID> getVisitorsAtIsland(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot get visitors at island to null island");
        return this.islandManager.getVisitorsAtIsland(island.getIsland());
    }

    public void visitIsland(Player player, Island island) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot visit island to null player");
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot visit island to null island");
        this.islandManager.visitIsland(player, island.getIsland());
    }

    public void closeIsland(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot closed island to null island");
        this.islandManager.closeIsland(island.getIsland());
    }

    public Set<UUID> getMembersOnline(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot get online members to null island");
        return this.islandManager.getMembersOnline(island.getIsland());
    }

    public List<Player> getPlayersAtIsland(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot get players at island to null island");
        return this.islandManager.getPlayersAtIsland(island.getIsland());
    }

    public List<Player> getPlayersAtIsland(Island island, IslandWorld world) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot get players at island to null island");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"Cannot get players at island to null world");
        return this.islandManager.getPlayersAtIsland(island.getIsland(), APIUtil.toImplementation(world));
    }

    @Deprecated
    public void giveUgrades(Player player, Island island) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot give upgrades to null player");
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot give upgrades to null island");
        this.islandManager.updateFlight(player);
    }

    @Deprecated
    public void giveFly(Player player, Island island) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot give upgrades to null player");
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot give upgrades to null island");
        this.islandManager.updateFlight(player);
    }

    @Deprecated
    public void removeUpgrades(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot remove upgrades to null player");
        this.islandManager.updateFlight(player);
    }

    public void updateFlight(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot update flight of a null player");
        this.islandManager.updateFlight(player);
    }

    public void updateFlightAtIsland(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot update flight of a null island");
        this.islandManager.updateFlightAtIsland(island.getIsland());
    }

    public Set<UUID> getCoopPlayersAtIsland(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot get coop players to null island");
        return this.islandManager.getCoopPlayersAtIsland(island.getIsland());
    }

    public void removeCoopPlayersAtIsland(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot remove coop players to null island");
        this.islandManager.removeCoopPlayers(island.getIsland(), null);
    }

    public boolean createIsland(Player player, com.craftaro.skyblock.api.structure.Structure structure) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot create island to null player");
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Cannot create island to null structure");
        if (!IslandManager.hasIsland((OfflinePlayer)player)) {
            return this.islandManager.createIsland(player, (Structure)structure);
        }
        return false;
    }

    public void deleteIsland(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot delete island to null island");
        this.islandManager.deleteIsland(island.getIsland(), true);
    }

    public void deleteIsland(Island island, boolean force) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot delete island to null island");
        this.islandManager.deleteIsland(island.getIsland(), force);
    }

    public boolean isPlayerAtIsland(Island island, Player player) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot check to null island");
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot check to null player");
        return this.islandManager.isPlayerAtIsland(island.getIsland(), player);
    }

    public boolean isPlayerAtIsland(Island island, Player player, IslandWorld world) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot check to null island");
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot check to null player");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"Cannot check to null world");
        return this.islandManager.isPlayerAtIsland(island.getIsland(), player, APIUtil.toImplementation(world));
    }

    public boolean isLocationAtIsland(Island island, Location location) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot check to null island");
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Cannot check to null location");
        return this.islandManager.isLocationAtIsland(island.getIsland(), location);
    }

    public Island getIslandAtLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Cannot get island to null location");
        com.craftaro.skyblock.island.Island island = this.islandManager.getIslandAtLocation(location);
        if (island != null) {
            return island.getAPIWrapper();
        }
        return null;
    }

    public boolean isPlayerAtIsland(Island island, Location location, IslandWorld world) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot check to null island");
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Cannot check to null location");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"Cannot check to null world");
        return this.islandManager.isLocationAtIsland(island.getIsland(), location, APIUtil.toImplementation(world));
    }

    public Island getIslandPlayerAt(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot get Island to null player");
        com.craftaro.skyblock.island.Island island = this.islandManager.getIslandPlayerAt(player);
        if (island != null) {
            return island.getAPIWrapper();
        }
        return null;
    }

    public boolean isPlayerAtAnIsland(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot check to null player");
        return this.islandManager.isPlayerAtAnIsland(player);
    }

    public void resetIsland(Island island) {
        Preconditions.checkArgument((island != null ? 1 : 0) != 0, (Object)"Cannot reset island to null island");
        this.islandManager.resetIsland(island.getIsland());
    }

    public Island getIsland(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot get island to null player");
        com.craftaro.skyblock.island.Island island = this.islandManager.getIsland(player);
        if (island != null) {
            return island.getAPIWrapper();
        }
        return new Island(null, player);
    }

    public Island getIslandByUUID(UUID islandUUID) {
        Preconditions.checkArgument((islandUUID != null ? 1 : 0) != 0, (Object)"Cannot get island with a null UUID");
        com.craftaro.skyblock.island.Island island = this.islandManager.getIslandByUUID(islandUUID);
        return island != null ? island.getAPIWrapper() : null;
    }

    public List<Island> getIslands() {
        ArrayList<Island> islands = new ArrayList<Island>();
        for (int i = 0; i < this.islandManager.getIslands().size(); ++i) {
            islands.add(this.islandManager.getIslands().get(this.islandManager.getIslands().keySet().toArray()[i]).getAPIWrapper());
        }
        return islands;
    }
}

