/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.api.island;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.api.island.Island;
import com.craftaro.skyblock.core.compatibility.CompatibleMaterial;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.Material;

public class IslandLevel {
    private final Island handle;

    public IslandLevel(Island handle) {
        this.handle = handle;
    }

    public double getPoints() {
        return this.handle.getIsland().getLevel().getPoints();
    }

    public long getLevel() {
        return this.handle.getIsland().getLevel().getLevel();
    }

    public double getLastCalculatedPoints() {
        return this.handle.getIsland().getLevel().getLastCalculatedPoints();
    }

    public long getLastCalculatedLevel() {
        return this.handle.getIsland().getLevel().getLastCalculatedLevel();
    }

    public void setMaterialAmount(Material material, int amount) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Cannot set material amount to null material");
        this.handle.getIsland().getLevel().setMaterialAmount(CompatibleMaterial.getMaterial(material.name()).get().name(), amount);
    }

    public void setMaterialAmount(Material material, byte data, int amount) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Cannot set material amount to null material");
        this.handle.getIsland().getLevel().setMaterialAmount(CompatibleMaterial.getMaterial(material.name()).get().name(), amount);
    }

    public long getMaterialAmount(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Cannot get material amount to null material");
        XMaterial materials = CompatibleMaterial.getMaterial(material.name()).get();
        com.craftaro.skyblock.island.IslandLevel level = this.handle.getIsland().getLevel();
        if (level.getMaterials().containsKey(materials.name())) {
            return level.getMaterials().get(materials.name());
        }
        return 0L;
    }

    public long getMaterialAmount(Material material, byte data) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Cannot get material amount to null material");
        XMaterial materials = CompatibleMaterial.getMaterial(material.name()).get();
        com.craftaro.skyblock.island.IslandLevel level = this.handle.getIsland().getLevel();
        if (level.getMaterials().containsKey(materials.name())) {
            return level.getMaterials().get(materials.name());
        }
        return 0L;
    }

    public long getMaterialPoints(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Cannot get material points to null material");
        return this.handle.getIsland().getLevel().getMaterialPoints(CompatibleMaterial.getMaterial(material.name()).get().name());
    }

    public long getMaterialPoints(Material material, byte data) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Cannot get material points to null material");
        return this.handle.getIsland().getLevel().getMaterialPoints(CompatibleMaterial.getMaterial(material.name()).get().name());
    }

    public Island getIsland() {
        return this.handle;
    }

    public void updateLevel(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Cannot update level of a null island");
        ((SkyBlock)SkyBlock.getPlugin(SkyBlock.class)).getLevellingManager().updateLevel(this.handle.getIsland(), location);
    }
}

