/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.api.island;

import com.craftaro.skyblock.api.SkyBlockAPI;
import com.craftaro.skyblock.api.ban.Ban;
import com.craftaro.skyblock.api.island.IslandBorderColor;
import com.craftaro.skyblock.api.island.IslandEnvironment;
import com.craftaro.skyblock.api.island.IslandLevel;
import com.craftaro.skyblock.api.island.IslandMessage;
import com.craftaro.skyblock.api.island.IslandRole;
import com.craftaro.skyblock.api.island.IslandUpgrade;
import com.craftaro.skyblock.api.island.IslandWorld;
import com.craftaro.skyblock.api.utils.APIUtil;
import com.craftaro.skyblock.api.visit.Visit;
import com.craftaro.skyblock.island.IslandCoop;
import com.craftaro.skyblock.island.IslandPermission;
import com.craftaro.skyblock.island.IslandStatus;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;

public class Island {
    private com.craftaro.skyblock.island.Island handle;
    private OfflinePlayer player;

    public Island(com.craftaro.skyblock.island.Island handle, OfflinePlayer player) {
        this.handle = handle;
        this.player = player;
    }

    public UUID getIslandUUID() {
        return this.handle.getIslandUUID();
    }

    public UUID getOwnerUUID() {
        return this.handle.getOwnerUUID();
    }

    public UUID getOriginalOwnerUUID() {
        return this.handle.getOriginalOwnerUUID();
    }

    public int getSize() {
        return this.handle.getSize();
    }

    public void setSize(int size) {
        Preconditions.checkArgument((size <= 1000 ? 1 : 0) != 0, (Object)"Cannot set size to greater than 1000");
        Preconditions.checkArgument((size >= 20 ? 1 : 0) != 0, (Object)"Cannot set size to less than 20");
        this.handle.setSize(size);
    }

    public double getRadius() {
        return this.handle.getRadius();
    }

    public boolean hasPassword() {
        return this.handle.hasPassword();
    }

    public void setPassword(String password) {
        Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"Cannot set password to null password");
        this.handle.setPassword(password);
    }

    public Location getLocation(IslandWorld world, IslandEnvironment environment) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World in island world null does not exist");
        Preconditions.checkArgument((environment != null ? 1 : 0) != 0, (Object)"World in environment null does not exist");
        return this.handle.getLocation(APIUtil.toImplementation(world), APIUtil.toImplementation(environment));
    }

    public void setLocation(IslandWorld world, IslandEnvironment environment, int x, int y, int z) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World in island world null does not exist");
        Preconditions.checkArgument((environment != null ? 1 : 0) != 0, (Object)"World in environment null does not exist");
        World bukkitWorld = this.getLocation(world, environment).getWorld();
        this.handle.setLocation(APIUtil.toImplementation(world), APIUtil.toImplementation(environment), new Location(bukkitWorld, (double)x, (double)y, (double)z));
    }

    public boolean isBorder() {
        return this.handle.isBorder();
    }

    public void setBorder(boolean border) {
        this.handle.setBorder(border);
    }

    public IslandBorderColor getBorderColor() {
        return APIUtil.fromImplementation(this.handle.getBorderColor());
    }

    public void setBorderColor(IslandBorderColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"IslandBorderColor null does not exist");
        this.handle.setBorderColor(APIUtil.toImplementation(color));
    }

    public Biome getBiome() {
        return this.handle.getBiome();
    }

    public void setBiome(Biome biome) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Cannot set biome to null biome");
        this.handle.setBiome(biome);
    }

    public boolean isDayCycleSynchronizedSynchronized() {
        return this.handle.isWeatherSynchronized();
    }

    public void setDayCycleSynchronzied(boolean sync) {
        this.handle.setWeatherSynchronized(sync);
    }

    public WeatherType getWeather() {
        return this.handle.getWeather();
    }

    public void setWeather(WeatherType weatherType) {
        Preconditions.checkArgument((weatherType != null ? 1 : 0) != 0, (Object)"Cannot set weather to null weather");
        this.handle.setWeather(weatherType);
    }

    public int getTime() {
        return this.handle.getTime();
    }

    public void setTime(int time) {
        this.handle.setTime(time);
    }

    public Map<UUID, IslandCoop> getCoopPlayers() {
        return this.handle.getCoopPlayers();
    }

    public void addCoopPlayer(UUID uuid, IslandCoop islandCoop) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot add coop player to null uuid");
        this.handle.addCoopPlayer(uuid, islandCoop);
    }

    public void addCoopPlayer(OfflinePlayer player, IslandCoop islandCoop) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot add coop player to null player");
        this.handle.addCoopPlayer(player.getUniqueId(), islandCoop);
    }

    public void removeCoopPlayer(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot remove coop player to null uuid");
        this.handle.removeCoopPlayer(uuid);
    }

    public void removeCoopPlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot remove coop player to null player");
        this.handle.removeCoopPlayer(player.getUniqueId());
    }

    public boolean isCoopPlayer(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot return condition to null uuid");
        return this.handle.isCoopPlayer(uuid);
    }

    public boolean isCoopPlayer(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot return condition to null player");
        return this.handle.isCoopPlayer(player.getUniqueId());
    }

    public IslandRole getRole(OfflinePlayer player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot get role for null player");
        if (this.isCoopPlayer(player.getUniqueId())) {
            return IslandRole.COOP;
        }
        for (com.craftaro.skyblock.island.IslandRole role : com.craftaro.skyblock.island.IslandRole.values()) {
            if (!this.handle.hasRole(role, player.getUniqueId())) continue;
            return APIUtil.fromImplementation(role);
        }
        return IslandRole.VISITOR;
    }

    public Set<UUID> getPlayersWithRole(IslandRole role) {
        Preconditions.checkArgument((role != null ? 1 : 0) != 0, (Object)"Cannot get players will null role");
        return this.handle.getRole(APIUtil.toImplementation(role));
    }

    public boolean setRole(OfflinePlayer player, IslandRole role) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot set role of null player");
        return this.setRole(player.getUniqueId(), role);
    }

    public boolean setRole(UUID uuid, IslandRole role) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot set role of null player");
        Preconditions.checkArgument((role != null ? 1 : 0) != 0, (Object)"Cannot set role to null role");
        return this.handle.setRole(APIUtil.toImplementation(role), uuid);
    }

    public boolean removeRole(OfflinePlayer player, IslandRole role) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot remove role of null player");
        return this.removeRole(player.getUniqueId(), role);
    }

    public boolean removeRole(UUID uuid, IslandRole role) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot remove role of null player");
        Preconditions.checkArgument((role != null ? 1 : 0) != 0, (Object)"Cannot remove role to null role");
        return this.handle.removeRole(APIUtil.toImplementation(role), uuid);
    }

    public boolean hasRole(OfflinePlayer player, IslandRole role) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Cannot check role of null player");
        return this.handle.hasRole(APIUtil.toImplementation(role), player.getUniqueId());
    }

    public boolean hasRole(UUID uuid, IslandRole role) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"Cannot check role of null player");
        Preconditions.checkArgument((role != null ? 1 : 0) != 0, (Object)"Cannot check role to null role");
        return this.handle.hasRole(APIUtil.toImplementation(role), uuid);
    }

    public void setUpgrade(Player player, IslandUpgrade upgrade, boolean status) {
        Preconditions.checkArgument((upgrade != null ? 1 : 0) != 0, (Object)"Cannot set upgrade to null upgrade");
        this.handle.setUpgrade(player, APIUtil.toImplementation(upgrade), status);
    }

    public boolean hasUpgrade(IslandUpgrade upgrade) {
        Preconditions.checkArgument((upgrade != null ? 1 : 0) != 0, (Object)"Cannot check upgrade to null upgrade");
        return this.handle.hasUpgrade(APIUtil.toImplementation(upgrade));
    }

    public boolean isUpgrade(IslandUpgrade upgrade) {
        Preconditions.checkArgument((upgrade != null ? 1 : 0) != 0, (Object)"Cannot check upgrade to null upgrade");
        return this.handle.isUpgrade(APIUtil.toImplementation(upgrade));
    }

    public List<IslandPermission> getSettings(IslandRole role) {
        Preconditions.checkArgument((role != null ? 1 : 0) != 0, (Object)"Cannot get settings to null role");
        return this.handle.getSettings(APIUtil.toImplementation(role));
    }

    @Deprecated
    public boolean isOpen() {
        return this.handle.getStatus() == IslandStatus.OPEN;
    }

    @Deprecated
    public void setOpen(boolean open) {
        this.handle.setStatus(open ? IslandStatus.OPEN : IslandStatus.CLOSED);
    }

    public List<String> getMessage(IslandMessage message) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"Cannot get message for null message");
        return this.handle.getMessage(APIUtil.toImplementation(message));
    }

    public String getMessageAuthor(IslandMessage message) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"Cannot get message author for null message");
        return this.handle.getMessageAuthor(APIUtil.toImplementation(message));
    }

    public void setMessage(IslandMessage message, String author, List<String> messageLines) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"Cannot set message for null message");
        this.handle.setMessage(APIUtil.toImplementation(message), author, messageLines);
    }

    public boolean hasStructure() {
        return this.handle.hasStructure();
    }

    public String getStructure() {
        return this.handle.getStructure();
    }

    public void setStructure(String structure) {
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Cannot set structure to null structure");
        this.handle.setStructure(structure);
    }

    public Visit getVisit() {
        return new Visit(this);
    }

    public Ban getBan() {
        return new Ban(this);
    }

    public IslandLevel getLevel() {
        return new IslandLevel(this);
    }

    public boolean isLoaded() {
        return this.handle != null;
    }

    public void load() {
        if (this.handle == null) {
            SkyBlockAPI.getImplementation().getIslandManager().loadIsland(this.player);
            this.handle = SkyBlockAPI.getImplementation().getIslandManager().getIsland(this.player);
        }
    }

    public void unload() {
        if (this.handle != null) {
            SkyBlockAPI.getImplementation().getIslandManager().unloadIsland(this.getIsland(), null);
            this.handle = null;
        }
    }

    public void setPlayer(OfflinePlayer player) {
        this.player = player;
    }

    public com.craftaro.skyblock.island.Island getIsland() {
        return this.handle;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Island)) {
            return false;
        }
        Island other = (Island)obj;
        return other.getIslandUUID().equals(this.getIslandUUID());
    }
}

