/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.NBTSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.SchematicLoadException;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.storage.NBTConversions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;

public class SpongeSchematicReader
extends NBTSchematicReader {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final NBTInputStream inputStream;
    private DataFixer fixer = null;
    private int schematicVersion = -1;
    private int dataVersion = -1;

    public SpongeSchematicReader(NBTInputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        this.inputStream = inputStream;
    }

    @Override
    public Clipboard read() throws IOException {
        CompoundTag schematicTag = this.getBaseTag();
        Object schematic = schematicTag.getValue();
        Platform platform = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING);
        int liveDataVersion = platform.getDataVersion();
        if (this.schematicVersion == 1) {
            this.dataVersion = 1631;
            this.fixer = platform.getDataFixer();
            return this.readVersion1(schematicTag);
        }
        if (this.schematicVersion == 2) {
            this.dataVersion = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "DataVersion", IntTag.class).getValue();
            if (this.dataVersion < 0) {
                LOGGER.warn("Schematic has an unknown data version ({}). Data may be incompatible.", (Object)this.dataVersion);
                this.dataVersion = liveDataVersion;
            }
            if (this.dataVersion > liveDataVersion) {
                LOGGER.warn("Schematic was made in a newer Minecraft version ({} > {}). Data may be incompatible.", (Object)this.dataVersion, (Object)liveDataVersion);
            } else if (this.dataVersion < liveDataVersion) {
                this.fixer = platform.getDataFixer();
                if (this.fixer != null) {
                    LOGGER.debug("Schematic was made in an older Minecraft version ({} < {}), will attempt DFU.", (Object)this.dataVersion, (Object)liveDataVersion);
                } else {
                    LOGGER.info("Schematic was made in an older Minecraft version ({} < {}), but DFU is not available. Data may be incompatible.", (Object)this.dataVersion, (Object)liveDataVersion);
                }
            }
            BlockArrayClipboard clip = this.readVersion1(schematicTag);
            return this.readVersion2(clip, schematicTag);
        }
        throw new SchematicLoadException((Component)TranslatableComponent.of((String)"worldedit.schematic.load.unsupported-version", (Component[])new Component[]{TextComponent.of((int)this.schematicVersion)}));
    }

    @Override
    public OptionalInt getDataVersion() {
        try {
            CompoundTag schematicTag = this.getBaseTag();
            Object schematic = schematicTag.getValue();
            if (this.schematicVersion == 1) {
                return OptionalInt.of(1631);
            }
            if (this.schematicVersion == 2) {
                int dataVersion = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "DataVersion", IntTag.class).getValue();
                if (dataVersion < 0) {
                    return OptionalInt.empty();
                }
                return OptionalInt.of(dataVersion);
            }
            return OptionalInt.empty();
        }
        catch (IOException e) {
            return OptionalInt.empty();
        }
    }

    private CompoundTag getBaseTag() throws IOException {
        NamedTag rootTag = this.inputStream.readNamedTag();
        CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
        Object schematic = schematicTag.getValue();
        if (schematic.size() == 1 && schematic.containsKey("Schematic")) {
            schematicTag = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "Schematic", CompoundTag.class);
            schematic = schematicTag.getValue();
        }
        this.schematicVersion = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "Version", IntTag.class).getValue();
        return schematicTag;
    }

    private BlockArrayClipboard readVersion1(CompoundTag schematicTag) throws IOException {
        CuboidRegion region;
        BlockVector3 origin;
        int[] offsetParts;
        Object schematic = schematicTag.getValue();
        short width = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue();
        short height = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue();
        short length = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue();
        IntArrayTag offsetTag = SpongeSchematicReader.getTag((Map<String, Tag>)schematic, "Offset", IntArrayTag.class);
        if (offsetTag != null) {
            offsetParts = offsetTag.getValue();
            if (offsetParts.length != 3) {
                throw new IOException("Invalid offset specified in schematic.");
            }
        } else {
            offsetParts = new int[]{0, 0, 0};
        }
        BlockVector3 min = BlockVector3.at(offsetParts[0], offsetParts[1], offsetParts[2]);
        CompoundTag metadataTag = SpongeSchematicReader.getTag((Map<String, Tag>)schematic, "Metadata", CompoundTag.class);
        if (metadataTag != null && metadataTag.containsKey("WEOffsetX")) {
            Object metadata = metadataTag.getValue();
            int offsetX = SpongeSchematicReader.requireTag((Map<String, Tag>)metadata, "WEOffsetX", IntTag.class).getValue();
            int offsetY = SpongeSchematicReader.requireTag((Map<String, Tag>)metadata, "WEOffsetY", IntTag.class).getValue();
            int offsetZ = SpongeSchematicReader.requireTag((Map<String, Tag>)metadata, "WEOffsetZ", IntTag.class).getValue();
            BlockVector3 offset = BlockVector3.at(offsetX, offsetY, offsetZ);
            origin = min.subtract(offset);
            region = new CuboidRegion(min, min.add(width, height, length).subtract(BlockVector3.ONE));
        } else {
            origin = min;
            region = new CuboidRegion(origin, origin.add(width, height, length).subtract(BlockVector3.ONE));
        }
        IntTag paletteMaxTag = SpongeSchematicReader.getTag((Map<String, Tag>)schematic, "PaletteMax", IntTag.class);
        Object paletteObject = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "Palette", CompoundTag.class).getValue();
        if (paletteMaxTag != null && paletteObject.size() != paletteMaxTag.getValue().intValue()) {
            throw new IOException("Block palette size does not match expected size.");
        }
        HashMap<Integer, BlockState> palette = new HashMap<Integer, BlockState>();
        ParserContext parserContext = new ParserContext();
        parserContext.setRestricted(false);
        parserContext.setTryLegacy(false);
        parserContext.setPreferringWildcard(false);
        for (String palettePart : paletteObject.keySet()) {
            BlockState state;
            int id = SpongeSchematicReader.requireTag((Map<String, Tag>)paletteObject, palettePart, IntTag.class).getValue();
            if (this.fixer != null) {
                palettePart = this.fixer.fixUp(DataFixer.FixTypes.BLOCK_STATE, palettePart, this.dataVersion);
            }
            try {
                state = ((BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(palettePart, parserContext)).toImmutableState();
            }
            catch (InputParseException e) {
                LOGGER.warn("Invalid BlockState in palette: " + palettePart + ". Block will be replaced with air.");
                state = BlockTypes.AIR.getDefaultState();
            }
            palette.put(id, state);
        }
        byte[] blocks = SpongeSchematicReader.requireTag((Map<String, Tag>)schematic, "BlockData", ByteArrayTag.class).getValue();
        HashMap<BlockVector3, Map> tileEntitiesMap = new HashMap<BlockVector3, Map>();
        ListTag tileEntities = SpongeSchematicReader.getTag((Map<String, Tag>)schematic, "BlockEntities", ListTag.class);
        if (tileEntities == null) {
            tileEntities = SpongeSchematicReader.getTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class);
        }
        if (tileEntities != null) {
            List tileEntityTags = tileEntities.getValue().stream().map(tag -> (CompoundTag)tag).map(CompoundTag::getValue).collect(Collectors.toList());
            for (Object tileEntity : tileEntityTags) {
                int[] pos = SpongeSchematicReader.requireTag((Map<String, Tag>)tileEntity, "Pos", IntArrayTag.class).getValue();
                BlockVector3 pt = BlockVector3.at(pos[0], pos[1], pos[2]);
                HashMap values = Maps.newHashMap((Map)tileEntity);
                values.put("x", new IntTag(pt.getBlockX()));
                values.put("y", new IntTag(pt.getBlockY()));
                values.put("z", new IntTag(pt.getBlockZ()));
                values.put("id", (Tag)values.get("Id"));
                values.remove("Id");
                values.remove("Pos");
                tileEntity = this.fixer != null ? this.fixer.fixUp(DataFixer.FixTypes.BLOCK_ENTITY, new CompoundTag(values), this.dataVersion).getValue() : values;
                tileEntitiesMap.put(pt, (Map)tileEntity);
            }
        }
        BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
        clipboard.setOrigin(origin);
        int index = 0;
        int i = 0;
        while (i < blocks.length) {
            int value = 0;
            int varintLength = 0;
            while (true) {
                value |= (blocks[i] & 0x7F) << varintLength++ * 7;
                if (varintLength > 5) {
                    throw new IOException("VarInt too big (probably corrupted data)");
                }
                if ((blocks[i] & 0x80) != 128) {
                    ++i;
                    break;
                }
                ++i;
            }
            int y = index / (width * length);
            int z = index % (width * length) / width;
            int x = index % (width * length) % width;
            BlockState state = (BlockState)palette.get(value);
            BlockVector3 pt = BlockVector3.at(x, y, z);
            try {
                if (tileEntitiesMap.containsKey(pt)) {
                    clipboard.setBlock(clipboard.getMinimumPoint().add(pt), state.toBaseBlock(new CompoundTag((Map)tileEntitiesMap.get(pt))));
                } else {
                    clipboard.setBlock(clipboard.getMinimumPoint().add(pt), state);
                }
            }
            catch (WorldEditException e) {
                throw new IOException("Failed to load a block in the schematic");
            }
            ++index;
        }
        return clipboard;
    }

    private Clipboard readVersion2(BlockArrayClipboard version1, CompoundTag schematicTag) throws IOException {
        Object schematic = schematicTag.getValue();
        if (schematic.containsKey("BiomeData")) {
            this.readBiomes(version1, (Map<String, Tag>)schematic);
        }
        if (schematic.containsKey("Entities")) {
            this.readEntities(version1, (Map<String, Tag>)schematic);
        }
        return version1;
    }

    private void readBiomes(BlockArrayClipboard clipboard, Map<String, Tag> schematic) throws IOException {
        ByteArrayTag dataTag = SpongeSchematicReader.requireTag(schematic, "BiomeData", ByteArrayTag.class);
        IntTag maxTag = SpongeSchematicReader.requireTag(schematic, "BiomePaletteMax", IntTag.class);
        CompoundTag paletteTag = SpongeSchematicReader.requireTag(schematic, "BiomePalette", CompoundTag.class);
        HashMap<Integer, BiomeType> palette = new HashMap<Integer, BiomeType>();
        if (maxTag.getValue().intValue() != paletteTag.getValue().size()) {
            throw new IOException("Biome palette size does not match expected size.");
        }
        for (Map.Entry palettePart : paletteTag.getValue().entrySet()) {
            Tag idTag;
            BiomeType biome;
            String key = (String)palettePart.getKey();
            if (this.fixer != null) {
                key = this.fixer.fixUp(DataFixer.FixTypes.BIOME, key, this.dataVersion);
            }
            if ((biome = BiomeTypes.get(key)) == null) {
                LOGGER.warn("Unknown biome type :" + key + " in palette. Are you missing a mod or using a schematic made in a newer version of Minecraft?");
            }
            if (!((idTag = (Tag)palettePart.getValue()) instanceof IntTag)) {
                throw new IOException("Biome mapped to non-Int tag.");
            }
            palette.put(((IntTag)idTag).getValue(), biome);
        }
        int width = clipboard.getDimensions().getX();
        byte[] biomes = dataTag.getValue();
        int biomeIndex = 0;
        int biomeJ = 0;
        BlockVector3 min = clipboard.getMinimumPoint();
        while (biomeJ < biomes.length) {
            int bVal = 0;
            int varIntLength = 0;
            while (true) {
                bVal |= (biomes[biomeJ] & 0x7F) << varIntLength++ * 7;
                if (varIntLength > 5) {
                    throw new IOException("VarInt too big (probably corrupted data)");
                }
                if ((biomes[biomeJ] & 0x80) != 128) {
                    ++biomeJ;
                    break;
                }
                ++biomeJ;
            }
            int z = biomeIndex / width;
            int x = biomeIndex % width;
            BiomeType type = (BiomeType)palette.get(bVal);
            for (int y = 0; y < clipboard.getRegion().getHeight(); ++y) {
                clipboard.setBiome(min.add(x, y, z), type);
            }
            ++biomeIndex;
        }
    }

    private void readEntities(BlockArrayClipboard clipboard, Map<String, Tag> schematic) throws IOException {
        Object entList = SpongeSchematicReader.requireTag(schematic, "Entities", ListTag.class).getValue();
        if (entList.isEmpty()) {
            return;
        }
        Iterator iterator = entList.iterator();
        while (iterator.hasNext()) {
            EntityType entityType;
            Tag et = (Tag)iterator.next();
            if (!(et instanceof CompoundTag)) continue;
            CompoundTag entityTag = (CompoundTag)et;
            Object tags = entityTag.getValue();
            String id = SpongeSchematicReader.requireTag((Map<String, Tag>)tags, "Id", StringTag.class).getValue();
            entityTag = entityTag.createBuilder().putString("id", id).remove("Id").build();
            if (this.fixer != null) {
                entityTag = this.fixer.fixUp(DataFixer.FixTypes.ENTITY, entityTag, this.dataVersion);
            }
            if ((entityType = EntityTypes.get(id)) != null) {
                Location location = NBTConversions.toLocation(clipboard, SpongeSchematicReader.requireTag((Map<String, Tag>)tags, "Pos", ListTag.class), SpongeSchematicReader.requireTag((Map<String, Tag>)tags, "Rotation", ListTag.class));
                BaseEntity state = new BaseEntity(entityType, entityTag);
                clipboard.createEntity(location, state);
                continue;
            }
            LOGGER.warn("Unknown entity when pasting schematic: " + id);
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

