/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory.parser;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.command.util.SuggestionHelper;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.Locale;
import java.util.stream.Stream;

public class DefaultItemParser
extends InputParser<BaseItem> {
    public DefaultItemParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Override
    public Stream<String> getSuggestions(String input) {
        return SuggestionHelper.getNamespacedRegistrySuggestions(ItemType.REGISTRY, input);
    }

    @Override
    public BaseItem parseFromInput(String input, ParserContext context) throws InputParseException {
        ItemType type;
        BaseItem item = null;
        if (context.isTryingLegacy()) {
            try {
                String[] split = input.split(":");
                if (split.length == 0) {
                    throw new InputParseException((Component)TranslatableComponent.of((String)"worldedit.error.parser.invalid-colon"));
                }
                ItemType type2 = split.length == 1 ? LegacyMapper.getInstance().getItemFromLegacy(Integer.parseInt(split[0])) : LegacyMapper.getInstance().getItemFromLegacy(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
                if (type2 != null) {
                    item = new BaseItem(type2);
                }
            }
            catch (NumberFormatException split) {
                // empty catch block
            }
        }
        if ("hand".equalsIgnoreCase(input)) {
            return this.getItemInHand(context.requireActor(), HandSide.MAIN_HAND);
        }
        if ("offhand".equalsIgnoreCase(input)) {
            return this.getItemInHand(context.requireActor(), HandSide.OFF_HAND);
        }
        if (item == null && (type = ItemTypes.get(input.toLowerCase(Locale.ROOT))) != null) {
            item = new BaseItem(type);
        }
        if (item == null) {
            throw new NoMatchException((Component)TranslatableComponent.of((String)"worldedit.error.no-match", (Component[])new Component[]{TextComponent.of((String)input)}));
        }
        return item;
    }

    private BaseItemStack getItemInHand(Actor actor, HandSide handSide) throws InputParseException {
        if (actor instanceof Player) {
            return ((Player)actor).getItemInHand(handSide);
        }
        throw new InputParseException((Component)TranslatableComponent.of((String)"worldedit.error.parser.player-only", (Component[])new Component[]{TextComponent.of((String)(handSide == HandSide.MAIN_HAND ? "hand" : "offhand"))}));
    }
}

