/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ToolCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class ToolCommandsRegistration
implements CommandRegistration<ToolCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private ToolCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"Type of tree to generate")).defaultsTo((Iterable)ImmutableList.of((Object)"tree")).ofTypes((Collection)ImmutableList.of(treeType_Key)).build();
    private final CommandArgument rangePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"range"), (Component)TextComponent.of((String)"The max range of the stack")).defaultsTo((Iterable)ImmutableList.of((Object)"10")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask to stack until")).defaultsTo((Iterable)ImmutableList.of((Object)"!#existing")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to place")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument patternPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern to flood fill")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument rangePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"range"), (Component)TextComponent.of((String)"The range to perform the fill")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument primaryPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"primary"), (Component)TextComponent.of((String)"Pattern to set on left-click")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument secondaryPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"secondary"), (Component)TextComponent.of((String)"Pattern to set on right-click")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();

    private ToolCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ToolCommandsRegistration builder() {
        return new ToolCommandsRegistration();
    }

    public ToolCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ToolCommandsRegistration containerInstance(ToolCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public ToolCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public ToolCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("none", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"unbind"));
            b.description((Component)TextComponent.of((String)"Unbind a bound tool from your current item"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$none);
        });
        this.commandManager.register("selwand", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/selwand"));
            b.description((Component)TextComponent.of((String)"Selection wand tool"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$selwand);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"selwand", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("navwand", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/navwand"));
            b.description((Component)TextComponent.of((String)"Navigation wand tool"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$navwand);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"navwand", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("info", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Block information tool"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$info);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"info", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("tree", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Tree generator tool"));
            b.parts((Collection)ImmutableList.of((Object)this.typePart));
            b.action(this::cmd$tree);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"tree", (Class[])new Class[]{Player.class, LocalSession.class, TreeGenerator.TreeType.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("stacker", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Block stacker tool"));
            b.parts((Collection)ImmutableList.of((Object)this.rangePart, (Object)this.maskPart));
            b.action(this::cmd$stacker);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"stacker", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("repl", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Block replacer tool"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart));
            b.action(this::cmd$repl);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"repl", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("cycler", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Block data cycler tool"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$cycler);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"cycler", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("floodfill", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"flood"));
            b.description((Component)TextComponent.of((String)"Flood fill tool"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart2, (Object)this.rangePart2));
            b.action(this::cmd$floodfill);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"floodFill", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("deltree", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Floating tree remover tool"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$deltree);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"deltree", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("farwand", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Wand at a distance tool"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$farwand);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"farwand", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("lrbuild", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/lrbuild"));
            b.description((Component)TextComponent.of((String)"Long-range building tool"));
            b.parts((Collection)ImmutableList.of((Object)this.primaryPart, (Object)this.secondaryPart));
            b.action(this::cmd$lrbuild);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"longrangebuildtool", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$none(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"none", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.none(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$selwand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"selwand", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.selwand(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$navwand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"navwand", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.navwand(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$info(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"info", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.info(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$tree(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"tree", (Class[])new Class[]{Player.class, LocalSession.class, TreeGenerator.TreeType.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.tree(this.extract$player(parameters), this.extract$session(parameters), this.extract$type(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$stacker(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"stacker", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.stacker(this.extract$player(parameters), this.extract$session(parameters), this.extract$range(parameters), this.extract$mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$repl(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"repl", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.repl(this.extract$player(parameters), this.extract$session(parameters), this.extract$pattern(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$cycler(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"cycler", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.cycler(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$floodfill(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"floodFill", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.floodFill(this.extract$player(parameters), this.extract$session(parameters), this.extract$pattern2(parameters), this.extract$range2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$deltree(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"deltree", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.deltree(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$farwand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"farwand", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.farwand(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$lrbuild(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolCommands.class, (String)"longrangebuildtool", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.longrangebuildtool(this.extract$player(parameters), this.extract$session(parameters), this.extract$primary(parameters), this.extract$secondary(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player extract$player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private TreeGenerator.TreeType extract$type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private int extract$range(CommandParameters parameters) {
        return (Integer)this.rangePart.value(parameters).asSingle(integer_Key);
    }

    private Mask extract$mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private Pattern extract$pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private Pattern extract$pattern2(CommandParameters parameters) {
        return (Pattern)this.patternPart2.value(parameters).asSingle(pattern_Key);
    }

    private int extract$range2(CommandParameters parameters) {
        return (Integer)this.rangePart2.value(parameters).asSingle(integer_Key);
    }

    private Pattern extract$primary(CommandParameters parameters) {
        return (Pattern)this.primaryPart.value(parameters).asSingle(pattern_Key);
    }

    private Pattern extract$secondary(CommandParameters parameters) {
        return (Pattern)this.secondaryPart.value(parameters).asSingle(pattern_Key);
    }
}

