/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.SelectionCommands;
import com.sk89q.worldedit.command.argument.SelectorChoice;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.internal.annotation.Chunk3d;
import com.sk89q.worldedit.internal.annotation.MultiDirection;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class SelectionCommandsRegistration
implements CommandRegistration<SelectionCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<BlockVector3> blockVector3_Key = Key.of(BlockVector3.class);
    private static final Key<BlockVector3> blockVector3_chunk3d_Key = Key.of(BlockVector3.class, Chunk3d.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<BlockVector3> blockVector3_multiDirection_Key = Key.of(BlockVector3.class, MultiDirection.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<SelectorChoice> selectorChoice_Key = Key.of(SelectorChoice.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<World> world_Key = Key.of(World.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private CommandManager commandManager;
    private SelectionCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument coordinatesPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"coordinates"), (Component)TextComponent.of((String)"Coordinates to set position 1 to")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(blockVector3_Key)).build();
    private final CommandArgument coordinatesPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"coordinates"), (Component)TextComponent.of((String)"Coordinates to set position 2 to")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(blockVector3_Key)).build();
    private final CommandArgument coordinatesPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"coordinates"), (Component)TextComponent.of((String)"The chunk to select")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(blockVector3_chunk3d_Key)).build();
    private final NoArgCommandFlag expandSelectionPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Expand your selection to encompass all chunks that are part of it")).build();
    private final NoArgCommandFlag useChunkCoordinatesPart = CommandParts.flag((char)'c', (Component)TextComponent.of((String)"Use chunk coordinates instead of block coordinates")).build();
    private final NoArgCommandFlag navWandPart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"Get a navigation wand")).build();
    private final CommandArgument amountPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"amount"), (Component)TextComponent.of((String)"Amount to contract the selection by")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument reverseAmountPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"reverseAmount"), (Component)TextComponent.of((String)"Amount to contract the selection by in the other direction")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument directionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"direction"), (Component)TextComponent.of((String)"Direction to contract")).defaultsTo((Iterable)ImmutableList.of((Object)"me")).ofTypes((Collection)ImmutableList.of(blockVector3_multiDirection_Key)).build();
    private final CommandArgument amountPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"amount"), (Component)TextComponent.of((String)"Amount to shift the selection by")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument amountPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"amount"), (Component)TextComponent.of((String)"Amount to expand the selection by in all directions")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag onlyHorizontalPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Only expand horizontally")).build();
    private final NoArgCommandFlag onlyVerticalPart = CommandParts.flag((char)'v', (Component)TextComponent.of((String)"Only expand vertically")).build();
    private final CommandArgument amountPart4 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"amount"), (Component)TextComponent.of((String)"Amount to contract the selection by in all directions")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag onlyHorizontalPart2 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Only contract horizontally")).build();
    private final NoArgCommandFlag onlyVerticalPart2 = CommandParts.flag((char)'v', (Component)TextComponent.of((String)"Only contract vertically")).build();
    private final NoArgCommandFlag clipboardInfoPart = CommandParts.flag((char)'c', (Component)TextComponent.of((String)"Get clipboard info instead")).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask of blocks to match")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final NoArgCommandFlag clipboardDistrPart = CommandParts.flag((char)'c', (Component)TextComponent.of((String)"Get the distribution of the clipboard instead")).build();
    private final NoArgCommandFlag separateStatesPart = CommandParts.flag((char)'d', (Component)TextComponent.of((String)"Separate blocks by state")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Gets page from a previous distribution.")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument selectorPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"selector"), (Component)TextComponent.of((String)"Selector to switch to")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(selectorChoice_Key)).build();
    private final NoArgCommandFlag setDefaultSelectorPart = CommandParts.flag((char)'d', (Component)TextComponent.of((String)"Set default selector")).build();

    private SelectionCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static SelectionCommandsRegistration builder() {
        return new SelectionCommandsRegistration();
    }

    public SelectionCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public SelectionCommandsRegistration containerInstance(SelectionCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public SelectionCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public SelectionCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("/pos1", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set position 1"));
            b.parts((Collection)ImmutableList.of((Object)this.coordinatesPart));
            b.action(this::cmd$_pos1);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"pos1", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, BlockVector3.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/pos2", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set position 2"));
            b.parts((Collection)ImmutableList.of((Object)this.coordinatesPart2));
            b.action(this::cmd$_pos2);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"pos2", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, BlockVector3.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hpos1", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set position 1 to targeted block"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$_hpos1);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"hpos1", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hpos2", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set position 2 to targeted block"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$_hpos2);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"hpos2", (Class[])new Class[]{Player.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/chunk", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set the selection to your current chunk."));
            b.footer((Component)TextComponent.of((String)"This command selects 256-block-tall areas,\nwhich can be specified by the y-coordinate.\nE.g. -c x,1,z will select from y=256 to y=511."));
            b.parts((Collection)ImmutableList.of((Object)this.coordinatesPart3, (Object)this.expandSelectionPart, (Object)this.useChunkCoordinatesPart));
            b.action(this::cmd$_chunk);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"chunk", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, BlockVector3.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/wand", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Get the wand item"));
            b.footer((Component)TextComponent.of((String)"You must have also have permission to use at least one of the features of the requested wand."));
            b.parts((Collection)ImmutableList.of((Object)this.navWandPart));
            b.action(this::cmd$_wand);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"wand", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("toggleeditwand", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Remind the user that the wand is now a tool and can be unbound with /tool none."));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$toggleeditwand);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"toggleWand", (Class[])new Class[]{Player.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/contract", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Contract the selection area"));
            b.parts((Collection)ImmutableList.of((Object)this.amountPart, (Object)this.reverseAmountPart, (Object)this.directionPart));
            b.action(this::cmd$_contract);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"contract", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Integer.TYPE, Integer.TYPE, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/shift", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Shift the selection area"));
            b.parts((Collection)ImmutableList.of((Object)this.amountPart2, (Object)this.directionPart));
            b.action(this::cmd$_shift);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"shift", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Integer.TYPE, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/outset", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Outset the selection area"));
            b.parts((Collection)ImmutableList.of((Object)this.amountPart3, (Object)this.onlyHorizontalPart, (Object)this.onlyVerticalPart));
            b.action(this::cmd$_outset);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"outset", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/inset", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Inset the selection area"));
            b.parts((Collection)ImmutableList.of((Object)this.amountPart4, (Object)this.onlyHorizontalPart2, (Object)this.onlyVerticalPart2));
            b.action(this::cmd$_inset);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"inset", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/size", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Get information about the selection"));
            b.parts((Collection)ImmutableList.of((Object)this.clipboardInfoPart));
            b.action(this::cmd$_size);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"size", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/count", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Counts the number of blocks matching a mask"));
            b.parts((Collection)ImmutableList.of((Object)this.maskPart));
            b.action(this::cmd$_count);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"count", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, EditSession.class, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/distr", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Get the distribution of blocks in the selection"));
            b.parts((Collection)ImmutableList.of((Object)this.clipboardDistrPart, (Object)this.separateStatesPart, (Object)this.pagePart));
            b.action(this::cmd$_distr);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"distr", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/sel", b -> {
            b.aliases((Collection)ImmutableList.of((Object)";", (Object)"/desel", (Object)"/deselect"));
            b.description((Component)TextComponent.of((String)"Choose a region selector"));
            b.parts((Collection)ImmutableList.of((Object)this.selectorPart, (Object)this.setDefaultSelectorPart));
            b.action(this::cmd$_sel);
        });
    }

    private int cmd$_pos1(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"pos1", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, BlockVector3.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.pos1(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$coordinates(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_pos2(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"pos2", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, BlockVector3.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.pos2(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$coordinates2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_hpos1(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"hpos1", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.hpos1(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_hpos2(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"hpos2", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.hpos2(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_chunk(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"chunk", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, BlockVector3.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.chunk(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$coordinates3(parameters), this.extract$expandSelection(parameters), this.extract$useChunkCoordinates(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_wand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"wand", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.wand(this.extract$player(parameters), this.extract$session(parameters), this.extract$navWand(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$toggleeditwand(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"toggleWand", (Class[])new Class[]{Player.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.toggleWand(this.extract$player(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_contract(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"contract", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Integer.TYPE, Integer.TYPE, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.contract(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$amount(parameters), this.extract$reverseAmount(parameters), this.extract$direction(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_shift(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"shift", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Integer.TYPE, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.shift(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$amount2(parameters), this.extract$direction(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_outset(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"outset", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.outset(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$amount3(parameters), this.extract$onlyHorizontal(parameters), this.extract$onlyVertical(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_inset(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"inset", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.inset(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$amount4(parameters), this.extract$onlyHorizontal2(parameters), this.extract$onlyVertical2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_size(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"size", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.size(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$clipboardInfo(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_count(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"count", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, EditSession.class, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            int result = this.containerInstance.count(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$mask(parameters));
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_distr(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"distr", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.distr(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$clipboardDistr(parameters), this.extract$separateStates(parameters), this.extract$page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_sel(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, (String)"select", (Class[])new Class[]{Actor.class, World.class, LocalSession.class, SelectorChoice.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.select(this.extract$actor(parameters), this.extract$world(parameters), this.extract$session(parameters), this.extract$selector(parameters), this.extract$setDefaultSelector(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private World extract$world(CommandParameters parameters) {
        return (World)RegistrationUtil.requireOptional(world_Key, (String)"world", (Optional)parameters.injectedValue(world_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private BlockVector3 extract$coordinates(CommandParameters parameters) {
        return (BlockVector3)this.coordinatesPart.value(parameters).asSingle(blockVector3_Key);
    }

    private BlockVector3 extract$coordinates2(CommandParameters parameters) {
        return (BlockVector3)this.coordinatesPart2.value(parameters).asSingle(blockVector3_Key);
    }

    private Player extract$player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private BlockVector3 extract$coordinates3(CommandParameters parameters) {
        return (BlockVector3)this.coordinatesPart3.value(parameters).asSingle(blockVector3_chunk3d_Key);
    }

    private boolean extract$expandSelection(CommandParameters parameters) {
        return this.expandSelectionPart.in(parameters);
    }

    private boolean extract$useChunkCoordinates(CommandParameters parameters) {
        return this.useChunkCoordinatesPart.in(parameters);
    }

    private boolean extract$navWand(CommandParameters parameters) {
        return this.navWandPart.in(parameters);
    }

    private int extract$amount(CommandParameters parameters) {
        return (Integer)this.amountPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$reverseAmount(CommandParameters parameters) {
        return (Integer)this.reverseAmountPart.value(parameters).asSingle(integer_Key);
    }

    private List<BlockVector3> extract$direction(CommandParameters parameters) {
        return this.directionPart.value(parameters).asMultiple(blockVector3_multiDirection_Key);
    }

    private int extract$amount2(CommandParameters parameters) {
        return (Integer)this.amountPart2.value(parameters).asSingle(integer_Key);
    }

    private int extract$amount3(CommandParameters parameters) {
        return (Integer)this.amountPart3.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$onlyHorizontal(CommandParameters parameters) {
        return this.onlyHorizontalPart.in(parameters);
    }

    private boolean extract$onlyVertical(CommandParameters parameters) {
        return this.onlyVerticalPart.in(parameters);
    }

    private int extract$amount4(CommandParameters parameters) {
        return (Integer)this.amountPart4.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$onlyHorizontal2(CommandParameters parameters) {
        return this.onlyHorizontalPart2.in(parameters);
    }

    private boolean extract$onlyVertical2(CommandParameters parameters) {
        return this.onlyVerticalPart2.in(parameters);
    }

    private boolean extract$clipboardInfo(CommandParameters parameters) {
        return this.clipboardInfoPart.in(parameters);
    }

    private EditSession extract$editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private Mask extract$mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private boolean extract$clipboardDistr(CommandParameters parameters) {
        return this.clipboardDistrPart.in(parameters);
    }

    private boolean extract$separateStates(CommandParameters parameters) {
        return this.separateStatesPart.in(parameters);
    }

    private Integer extract$page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private SelectorChoice extract$selector(CommandParameters parameters) {
        return (SelectorChoice)((Object)this.selectorPart.value(parameters).asSingle(selectorChoice_Key));
    }

    private boolean extract$setDefaultSelector(CommandParameters parameters) {
        return this.setDefaultSelectorPart.in(parameters);
    }
}

