/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.BrushCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.ClipboardMask;
import com.sk89q.worldedit.internal.annotation.VertHeight;
import com.sk89q.worldedit.regions.factory.RegionFactory;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class BrushCommandsRegistration
implements CommandRegistration<BrushCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Mask> mask_clipboardMask_Key = Key.of(Mask.class, ClipboardMask.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<Integer> integer_vertHeight_Key = Key.of(Integer.class, VertHeight.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<RegionFactory> regionFactory_Key = Key.of(RegionFactory.class);
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<BiomeType> biomeType_Key = Key.of(BiomeType.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private BrushCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to set")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument radiusPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the sphere")).defaultsTo((Iterable)ImmutableList.of((Object)"2")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag hollowPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Create hollow spheres instead")).build();
    private final CommandArgument radiusPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the cylinder")).defaultsTo((Iterable)ImmutableList.of((Object)"2")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument heightPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"height"), (Component)TextComponent.of((String)"The height of the cylinder")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag hollowPart2 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Create hollow cylinders instead")).build();
    private final NoArgCommandFlag ignoreAirPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Don't paste air from the clipboard")).build();
    private final NoArgCommandFlag usingOriginPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Paste starting at the target location, instead of centering on it")).build();
    private final NoArgCommandFlag pasteEntitiesPart = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Paste entities if available")).build();
    private final NoArgCommandFlag pasteBiomesPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Paste biomes if available")).build();
    private final ArgAcceptingCommandFlag sourceMaskPart = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"Skip blocks matching this mask in the clipboard")).withRequiredArg().argNamed(TranslatableComponent.of((String)"sourceMask")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mask_clipboardMask_Key)).build();
    private final CommandArgument radiusPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to sample for softening")).defaultsTo((Iterable)ImmutableList.of((Object)"2")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument iterationsPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"iterations"), (Component)TextComponent.of((String)"The number of iterations to perform")).defaultsTo((Iterable)ImmutableList.of((Object)"4")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask of blocks to use for the heightmap")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument radiusPart4 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to extinguish")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument radiusPart5 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to apply gravity in")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final ArgAcceptingCommandFlag heightPart2 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Affect blocks between the given height, upwards and downwards, rather than the target location Y + radius")).withRequiredArg().argNamed(TranslatableComponent.of((String)"height")).defaultsTo((Iterable)ImmutableList.of((Object)"default-vertical-height")).ofTypes((Collection)ImmutableList.of(integer_vertHeight_Key)).build();
    private final CommandArgument radiusPart6 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"Radius to kill mobs in")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag killPetsPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Also kill pets")).build();
    private final NoArgCommandFlag killNpcsPart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"Also kill NPCs")).build();
    private final NoArgCommandFlag killGolemsPart = CommandParts.flag((char)'g', (Component)TextComponent.of((String)"Also kill golems")).build();
    private final NoArgCommandFlag killAnimalsPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Also kill animals")).build();
    private final NoArgCommandFlag killAmbientPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Also kill ambient mobs")).build();
    private final NoArgCommandFlag killWithNamePart = CommandParts.flag((char)'t', (Component)TextComponent.of((String)"Also kill mobs with name tags")).build();
    private final NoArgCommandFlag killFriendlyPart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Also kill all friendly mobs (Applies the flags `-abgnpt`)")).build();
    private final NoArgCommandFlag killArmorStandsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Also destroy armor stands")).build();
    private final NoArgCommandFlag killWaterPart = CommandParts.flag((char)'w', (Component)TextComponent.of((String)"Also kill water mobs")).build();
    private final CommandArgument imageNamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"imageName"), (Component)TextComponent.of((String)"The name of the image")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument radiusPart7 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The size of the brush")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument intensityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"intensity"), (Component)TextComponent.of((String)"The intensity of the brush")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag erasePart = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Erase blocks instead of filling them")).build();
    private final NoArgCommandFlag flattenPart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Don't change blocks above the selected height")).build();
    private final NoArgCommandFlag randomizePart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Randomizes the brush's height slightly.")).build();
    private final CommandArgument shapePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"shape"), (Component)TextComponent.of((String)"The shape of the region")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(regionFactory_Key)).build();
    private final CommandArgument expressionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"expression"), (Component)TextComponent.of((String)"Expression to apply")).defaultsTo((Iterable)ImmutableList.of((Object)"y-=0.2")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag useRawCoordsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Use the game's coordinate origin")).build();
    private final NoArgCommandFlag usePlacementPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Use the placement position as the origin")).build();
    private final CommandArgument densityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"density"), (Component)TextComponent.of((String)"The density of the brush")).defaultsTo((Iterable)ImmutableList.of((Object)"20")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"The type of tree to use")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(treeType_Key)).build();
    private final NoArgCommandFlag stackPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Whether to stack snow")).build();
    private final CommandArgument biomeTypePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"biomeType"), (Component)TextComponent.of((String)"The biome type")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(biomeType_Key)).build();

    private BrushCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static BrushCommandsRegistration builder() {
        return new BrushCommandsRegistration();
    }

    public BrushCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public BrushCommandsRegistration containerInstance(BrushCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public BrushCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public BrushCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("none", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"unbind"));
            b.description((Component)TextComponent.of((String)"Unbind a bound brush from your current item"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$none);
        });
        this.commandManager.register("sphere", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"s"));
            b.description((Component)TextComponent.of((String)"Choose the sphere brush"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.radiusPart, (Object)this.hollowPart));
            b.action(this::cmd$sphere);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"sphereBrush", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("cylinder", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"cyl", (Object)"c"));
            b.description((Component)TextComponent.of((String)"Choose the cylinder brush"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.radiusPart2, (Object)this.heightPart, (Object)this.hollowPart2));
            b.action(this::cmd$cylinder);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"cylinderBrush", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Double.TYPE, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("clipboard", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"copy"));
            b.description((Component)TextComponent.of((String)"Choose the clipboard brush"));
            b.parts((Collection)ImmutableList.of((Object)this.ignoreAirPart, (Object)this.usingOriginPart, (Object)this.pasteEntitiesPart, (Object)this.pasteBiomesPart, (Object)this.sourceMaskPart));
            b.action(this::cmd$clipboard);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"clipboardBrush", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("smooth", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Choose the terrain softener brush"));
            b.footer((Component)TextComponent.of((String)"Example: '/brush smooth 2 4 grass_block,dirt,stone'"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart3, (Object)this.iterationsPart, (Object)this.maskPart));
            b.action(this::cmd$smooth);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"smoothBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Integer.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("extinguish", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"ex"));
            b.description((Component)TextComponent.of((String)"Shortcut fire extinguisher brush"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart4));
            b.action(this::cmd$extinguish);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"extinguishBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("gravity", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"grav"));
            b.description((Component)TextComponent.of((String)"Gravity brush, simulates the effect of gravity"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart5, (Object)this.heightPart2));
            b.action(this::cmd$gravity);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"gravityBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Integer.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("butcher", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"kill"));
            b.description((Component)TextComponent.of((String)"Butcher brush, kills mobs within a radius"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart6, (Object)this.killPetsPart, (Object)this.killNpcsPart, (Object)this.killGolemsPart, (Object)this.killAnimalsPart, (Object)this.killAmbientPart, (Object)this.killWithNamePart, (Object)this.killFriendlyPart, (Object)this.killArmorStandsPart, (Object)this.killWaterPart));
            b.action(this::cmd$butcher);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"butcherBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("heightmap", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Heightmap brush, raises or lowers terrain using an image heightmap"));
            b.parts((Collection)ImmutableList.of((Object)this.imageNamePart, (Object)this.radiusPart7, (Object)this.intensityPart, (Object)this.erasePart, (Object)this.flattenPart, (Object)this.randomizePart));
            b.action(this::cmd$heightmap);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"heightmapBrush", (Class[])new Class[]{Player.class, LocalSession.class, String.class, Double.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("deform", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Deform brush, applies an expression to an area"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7, (Object)this.expressionPart, (Object)this.useRawCoordsPart, (Object)this.usePlacementPart));
            b.action(this::cmd$deform);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"deform", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, String.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("set", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set brush, sets all blocks in the area"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7, (Object)this.patternPart));
            b.action(this::cmd$set);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"set", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("forest", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Forest brush, creates a forest in the area"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7, (Object)this.densityPart, (Object)this.typePart));
            b.action(this::cmd$forest);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"forest", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Double.TYPE, TreeGenerator.TreeType.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("raise", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Raise brush, raise all blocks by one"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7));
            b.action(this::cmd$raise);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"raise", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("lower", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Lower brush, lower all blocks by one"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7));
            b.action(this::cmd$lower);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"lower", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("snow", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Snow brush, sets snow in the area"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7, (Object)this.stackPart));
            b.action(this::cmd$snow);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"snow", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("biome", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Biome brush, sets biomes in the area"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7, (Object)this.biomeTypePart));
            b.action(this::cmd$biome);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"biome", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, BiomeType.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$none(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"none", (Class[])new Class[]{Player.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.none(this.extract$player(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$sphere(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"sphereBrush", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.sphereBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$pattern(parameters), this.extract$radius(parameters), this.extract$hollow(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$cylinder(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"cylinderBrush", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Double.TYPE, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.cylinderBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$pattern(parameters), this.extract$radius2(parameters), this.extract$height(parameters), this.extract$hollow2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$clipboard(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"clipboardBrush", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.clipboardBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$ignoreAir(parameters), this.extract$usingOrigin(parameters), this.extract$pasteEntities(parameters), this.extract$pasteBiomes(parameters), this.extract$sourceMask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$smooth(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"smoothBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Integer.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.smoothBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius3(parameters), this.extract$iterations(parameters), this.extract$mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$extinguish(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"extinguishBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.extinguishBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius4(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$gravity(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"gravityBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Integer.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.gravityBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius5(parameters), this.extract$height2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$butcher(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"butcherBrush", (Class[])new Class[]{Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.butcherBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius6(parameters), this.extract$killPets(parameters), this.extract$killNpcs(parameters), this.extract$killGolems(parameters), this.extract$killAnimals(parameters), this.extract$killAmbient(parameters), this.extract$killWithName(parameters), this.extract$killFriendly(parameters), this.extract$killArmorStands(parameters), this.extract$killWater(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$heightmap(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"heightmapBrush", (Class[])new Class[]{Player.class, LocalSession.class, String.class, Double.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.heightmapBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$imageName(parameters), this.extract$radius7(parameters), this.extract$intensity(parameters), this.extract$erase(parameters), this.extract$flatten(parameters), this.extract$randomize(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$deform(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"deform", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, String.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.deform(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius7(parameters), this.extract$expression(parameters), this.extract$useRawCoords(parameters), this.extract$usePlacement(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$set(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"set", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.set(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius7(parameters), this.extract$pattern(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$forest(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"forest", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Double.TYPE, TreeGenerator.TreeType.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.forest(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius7(parameters), this.extract$density(parameters), this.extract$type(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$raise(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"raise", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.raise(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius7(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$lower(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"lower", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.lower(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius7(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$snow(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"snow", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.snow(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius7(parameters), this.extract$stack(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$biome(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"biome", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, BiomeType.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.biome(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius7(parameters), this.extract$biomeType(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player extract$player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private Pattern extract$pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private double extract$radius(CommandParameters parameters) {
        return (Double)this.radiusPart.value(parameters).asSingle(double_Key);
    }

    private boolean extract$hollow(CommandParameters parameters) {
        return this.hollowPart.in(parameters);
    }

    private double extract$radius2(CommandParameters parameters) {
        return (Double)this.radiusPart2.value(parameters).asSingle(double_Key);
    }

    private int extract$height(CommandParameters parameters) {
        return (Integer)this.heightPart.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$hollow2(CommandParameters parameters) {
        return this.hollowPart2.in(parameters);
    }

    private boolean extract$ignoreAir(CommandParameters parameters) {
        return this.ignoreAirPart.in(parameters);
    }

    private boolean extract$usingOrigin(CommandParameters parameters) {
        return this.usingOriginPart.in(parameters);
    }

    private boolean extract$pasteEntities(CommandParameters parameters) {
        return this.pasteEntitiesPart.in(parameters);
    }

    private boolean extract$pasteBiomes(CommandParameters parameters) {
        return this.pasteBiomesPart.in(parameters);
    }

    private Mask extract$sourceMask(CommandParameters parameters) {
        return (Mask)this.sourceMaskPart.value(parameters).asSingle(mask_clipboardMask_Key);
    }

    private double extract$radius3(CommandParameters parameters) {
        return (Double)this.radiusPart3.value(parameters).asSingle(double_Key);
    }

    private int extract$iterations(CommandParameters parameters) {
        return (Integer)this.iterationsPart.value(parameters).asSingle(integer_Key);
    }

    private Mask extract$mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private double extract$radius4(CommandParameters parameters) {
        return (Double)this.radiusPart4.value(parameters).asSingle(double_Key);
    }

    private double extract$radius5(CommandParameters parameters) {
        return (Double)this.radiusPart5.value(parameters).asSingle(double_Key);
    }

    private Integer extract$height2(CommandParameters parameters) {
        return (Integer)this.heightPart2.value(parameters).asSingle(integer_vertHeight_Key);
    }

    private double extract$radius6(CommandParameters parameters) {
        return (Double)this.radiusPart6.value(parameters).asSingle(double_Key);
    }

    private boolean extract$killPets(CommandParameters parameters) {
        return this.killPetsPart.in(parameters);
    }

    private boolean extract$killNpcs(CommandParameters parameters) {
        return this.killNpcsPart.in(parameters);
    }

    private boolean extract$killGolems(CommandParameters parameters) {
        return this.killGolemsPart.in(parameters);
    }

    private boolean extract$killAnimals(CommandParameters parameters) {
        return this.killAnimalsPart.in(parameters);
    }

    private boolean extract$killAmbient(CommandParameters parameters) {
        return this.killAmbientPart.in(parameters);
    }

    private boolean extract$killWithName(CommandParameters parameters) {
        return this.killWithNamePart.in(parameters);
    }

    private boolean extract$killFriendly(CommandParameters parameters) {
        return this.killFriendlyPart.in(parameters);
    }

    private boolean extract$killArmorStands(CommandParameters parameters) {
        return this.killArmorStandsPart.in(parameters);
    }

    private boolean extract$killWater(CommandParameters parameters) {
        return this.killWaterPart.in(parameters);
    }

    private String extract$imageName(CommandParameters parameters) {
        return (String)this.imageNamePart.value(parameters).asSingle(string_Key);
    }

    private double extract$radius7(CommandParameters parameters) {
        return (Double)this.radiusPart7.value(parameters).asSingle(double_Key);
    }

    private double extract$intensity(CommandParameters parameters) {
        return (Double)this.intensityPart.value(parameters).asSingle(double_Key);
    }

    private boolean extract$erase(CommandParameters parameters) {
        return this.erasePart.in(parameters);
    }

    private boolean extract$flatten(CommandParameters parameters) {
        return this.flattenPart.in(parameters);
    }

    private boolean extract$randomize(CommandParameters parameters) {
        return this.randomizePart.in(parameters);
    }

    private LocalSession extract$localSession(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"localSession", (Optional)parameters.injectedValue(localSession_Key));
    }

    private RegionFactory extract$shape(CommandParameters parameters) {
        return (RegionFactory)this.shapePart.value(parameters).asSingle(regionFactory_Key);
    }

    private String extract$expression(CommandParameters parameters) {
        return (String)this.expressionPart.value(parameters).asSingle(string_Key);
    }

    private boolean extract$useRawCoords(CommandParameters parameters) {
        return this.useRawCoordsPart.in(parameters);
    }

    private boolean extract$usePlacement(CommandParameters parameters) {
        return this.usePlacementPart.in(parameters);
    }

    private double extract$density(CommandParameters parameters) {
        return (Double)this.densityPart.value(parameters).asSingle(double_Key);
    }

    private TreeGenerator.TreeType extract$type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private boolean extract$stack(CommandParameters parameters) {
        return this.stackPart.in(parameters);
    }

    private BiomeType extract$biomeType(CommandParameters parameters) {
        return (BiomeType)this.biomeTypePart.value(parameters).asSingle(biomeType_Key);
    }
}

