/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ToolCommands;
import com.sk89q.worldedit.command.factory.ReplaceFactory;
import com.sk89q.worldedit.command.factory.TreeGeneratorFactory;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.brush.ButcherBrush;
import com.sk89q.worldedit.command.tool.brush.ClipboardBrush;
import com.sk89q.worldedit.command.tool.brush.CylinderBrush;
import com.sk89q.worldedit.command.tool.brush.GravityBrush;
import com.sk89q.worldedit.command.tool.brush.HollowCylinderBrush;
import com.sk89q.worldedit.command.tool.brush.HollowSphereBrush;
import com.sk89q.worldedit.command.tool.brush.ImageHeightmapBrush;
import com.sk89q.worldedit.command.tool.brush.OperationFactoryBrush;
import com.sk89q.worldedit.command.tool.brush.SmoothBrush;
import com.sk89q.worldedit.command.tool.brush.SphereBrush;
import com.sk89q.worldedit.command.util.AsyncCommandBuilder;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.CreatureButcher;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.Contextual;
import com.sk89q.worldedit.function.factory.ApplyLayer;
import com.sk89q.worldedit.function.factory.ApplyRegion;
import com.sk89q.worldedit.function.factory.BiomeFactory;
import com.sk89q.worldedit.function.factory.Deform;
import com.sk89q.worldedit.function.factory.Paint;
import com.sk89q.worldedit.function.factory.Snow;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.ClipboardMask;
import com.sk89q.worldedit.internal.annotation.VertHeight;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.factory.CylinderRegionFactory;
import com.sk89q.worldedit.regions.factory.RegionFactory;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.request.RequestExtent;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.asset.AssetLoadTask;
import com.sk89q.worldedit.util.asset.AssetLoader;
import com.sk89q.worldedit.util.asset.holder.ImageHeightmap;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Optional;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class BrushCommands {
    private final WorldEdit worldEdit;
    private static final Component UNBIND_COMMAND_COMPONENT = ((TextComponent.Builder)TextComponent.builder((String)"/brush unbind", (TextColor)TextColor.AQUA).clickEvent(ClickEvent.suggestCommand((String)"/brush unbind"))).build();

    public BrushCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="none", aliases={"unbind"}, desc="Unbind a bound brush from your current item")
    void none(Player player, LocalSession session) throws WorldEditException {
        ToolCommands.setToolNone(player, session, true);
    }

    @Command(name="sphere", aliases={"s"}, desc="Choose the sphere brush")
    @CommandPermissions(value={"worldedit.brush.sphere"})
    public void sphereBrush(Player player, LocalSession session, @Arg(desc="The pattern of blocks to set") Pattern pattern, @Arg(desc="The radius of the sphere", def={"2"}) double radius, @Switch(name=104, desc="Create hollow spheres instead") boolean hollow) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setFill(pattern);
        tool.setSize(radius);
        if (hollow) {
            tool.setBrush(new HollowSphereBrush(), "worldedit.brush.sphere");
        } else {
            tool.setBrush(new SphereBrush(), "worldedit.brush.sphere");
        }
        player.printInfo((Component)TranslatableComponent.of((String)"worldedit.brush.sphere.equip", (Component[])new Component[]{TextComponent.of((String)String.format("%.0f", radius))}));
        ToolCommands.sendUnbindInstruction(player, UNBIND_COMMAND_COMPONENT);
    }

    @Command(name="cylinder", aliases={"cyl", "c"}, desc="Choose the cylinder brush")
    @CommandPermissions(value={"worldedit.brush.cylinder"})
    public void cylinderBrush(Player player, LocalSession session, @Arg(desc="The pattern of blocks to set") Pattern pattern, @Arg(desc="The radius of the cylinder", def={"2"}) double radius, @Arg(desc="The height of the cylinder", def={"1"}) int height, @Switch(name=104, desc="Create hollow cylinders instead") boolean hollow) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        this.worldEdit.checkMaxBrushRadius(height);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setFill(pattern);
        tool.setSize(radius);
        if (hollow) {
            tool.setBrush(new HollowCylinderBrush(height), "worldedit.brush.cylinder");
        } else {
            tool.setBrush(new CylinderBrush(height), "worldedit.brush.cylinder");
        }
        player.printInfo((Component)TranslatableComponent.of((String)"worldedit.brush.cylinder.equip", (Component[])new Component[]{TextComponent.of((int)((int)radius)), TextComponent.of((int)height)}));
        ToolCommands.sendUnbindInstruction(player, UNBIND_COMMAND_COMPONENT);
    }

    @Command(name="clipboard", aliases={"copy"}, desc="Choose the clipboard brush")
    @CommandPermissions(value={"worldedit.brush.clipboard"})
    public void clipboardBrush(Player player, LocalSession session, @Switch(name=97, desc="Don't paste air from the clipboard") boolean ignoreAir, @Switch(name=111, desc="Paste starting at the target location, instead of centering on it") boolean usingOrigin, @Switch(name=101, desc="Paste entities if available") boolean pasteEntities, @Switch(name=98, desc="Paste biomes if available") boolean pasteBiomes, @ClipboardMask @ArgFlag(name=109, desc="Skip blocks matching this mask in the clipboard") Mask sourceMask) throws WorldEditException {
        ClipboardHolder holder = session.getClipboard();
        Clipboard clipboard = holder.getClipboard();
        ClipboardHolder newHolder = new ClipboardHolder(clipboard);
        newHolder.setTransform(holder.getTransform());
        BlockVector3 size = clipboard.getDimensions();
        this.worldEdit.checkMaxBrushRadius((double)size.getBlockX() / 2.0 - 1.0);
        this.worldEdit.checkMaxBrushRadius((double)size.getBlockY() / 2.0 - 1.0);
        this.worldEdit.checkMaxBrushRadius((double)size.getBlockZ() / 2.0 - 1.0);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setBrush(new ClipboardBrush(newHolder, ignoreAir, usingOrigin, pasteEntities, pasteBiomes, sourceMask), "worldedit.brush.clipboard");
        player.printInfo((Component)TranslatableComponent.of((String)"worldedit.brush.clipboard.equip"));
        ToolCommands.sendUnbindInstruction(player, UNBIND_COMMAND_COMPONENT);
    }

    @Command(name="smooth", desc="Choose the terrain softener brush", descFooter="Example: '/brush smooth 2 4 grass_block,dirt,stone'")
    @CommandPermissions(value={"worldedit.brush.smooth"})
    public void smoothBrush(Player player, LocalSession session, @Arg(desc="The radius to sample for softening", def={"2"}) double radius, @Arg(desc="The number of iterations to perform", def={"4"}) int iterations, @Arg(desc="The mask of blocks to use for the heightmap", def={""}) Mask mask) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setSize(radius);
        tool.setBrush(new SmoothBrush(iterations, mask), "worldedit.brush.smooth");
        player.printInfo((Component)TranslatableComponent.of((String)"worldedit.brush.smooth.equip", (Component[])new Component[]{TextComponent.of((int)((int)radius)), TextComponent.of((int)iterations), TextComponent.of((String)(mask == null ? "any block" : "filter"))}));
        ToolCommands.sendUnbindInstruction(player, UNBIND_COMMAND_COMPONENT);
    }

    @Command(name="extinguish", aliases={"ex"}, desc="Shortcut fire extinguisher brush")
    @CommandPermissions(value={"worldedit.brush.ex"})
    public void extinguishBrush(Player player, LocalSession session, @Arg(desc="The radius to extinguish", def={"5"}) double radius) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setFill(BlockTypes.AIR.getDefaultState());
        tool.setSize(radius);
        tool.setMask(new BlockTypeMask((Extent)new RequestExtent(), BlockTypes.FIRE));
        tool.setBrush(new SphereBrush(), "worldedit.brush.ex");
        player.printInfo((Component)TranslatableComponent.of((String)"worldedit.brush.extinguish.equip", (Component[])new Component[]{TextComponent.of((int)((int)radius))}));
        ToolCommands.sendUnbindInstruction(player, UNBIND_COMMAND_COMPONENT);
    }

    @Command(name="gravity", aliases={"grav"}, desc="Gravity brush, simulates the effect of gravity")
    @CommandPermissions(value={"worldedit.brush.gravity"})
    public void gravityBrush(Player player, LocalSession session, @Arg(desc="The radius to apply gravity in", def={"5"}) double radius, @VertHeight @ArgFlag(name=104, desc="Affect blocks between the given height, upwards and downwards, rather than the target location Y + radius", def={"default-vertical-height"}) Integer height) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setSize(radius);
        tool.setBrush(new GravityBrush(height), "worldedit.brush.gravity");
        player.printInfo((Component)TranslatableComponent.of((String)"worldedit.brush.gravity.equip", (Component[])new Component[]{TextComponent.of((int)((int)radius))}));
        ToolCommands.sendUnbindInstruction(player, UNBIND_COMMAND_COMPONENT);
    }

    @Command(name="butcher", aliases={"kill"}, desc="Butcher brush, kills mobs within a radius")
    @CommandPermissions(value={"worldedit.brush.butcher"})
    public void butcherBrush(Player player, LocalSession session, @Arg(desc="Radius to kill mobs in", def={"5"}) double radius, @Switch(name=112, desc="Also kill pets") boolean killPets, @Switch(name=110, desc="Also kill NPCs") boolean killNpcs, @Switch(name=103, desc="Also kill golems") boolean killGolems, @Switch(name=97, desc="Also kill animals") boolean killAnimals, @Switch(name=98, desc="Also kill ambient mobs") boolean killAmbient, @Switch(name=116, desc="Also kill mobs with name tags") boolean killWithName, @Switch(name=102, desc="Also kill all friendly mobs (Applies the flags `-abgnpt`)") boolean killFriendly, @Switch(name=114, desc="Also destroy armor stands") boolean killArmorStands, @Switch(name=119, desc="Also kill water mobs") boolean killWater) throws WorldEditException {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        double maxRadius = config.maxBrushRadius;
        if (player.hasPermission("worldedit.butcher")) {
            maxRadius = Math.max(config.maxBrushRadius, config.butcherMaxRadius);
        }
        if (radius > maxRadius) {
            player.printError((Component)TranslatableComponent.of((String)"worldedit.brush.radius-too-large", (Component[])new Component[]{TextComponent.of((double)maxRadius)}));
            return;
        }
        CreatureButcher flags = new CreatureButcher(player);
        flags.or(191, killFriendly);
        flags.or(1, killPets, "worldedit.butcher.pets");
        flags.or(2, killNpcs, "worldedit.butcher.npcs");
        flags.or(8, killGolems, "worldedit.butcher.golems");
        flags.or(4, killAnimals, "worldedit.butcher.animals");
        flags.or(16, killAmbient, "worldedit.butcher.ambient");
        flags.or(32, killWithName, "worldedit.butcher.tagged");
        flags.or(64, killArmorStands, "worldedit.butcher.armorstands");
        flags.or(128, killWater, "worldedit.butcher.water");
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setSize(radius);
        tool.setBrush(new ButcherBrush(flags), "worldedit.brush.butcher");
        player.printInfo((Component)TranslatableComponent.of((String)"worldedit.brush.butcher.equip", (Component[])new Component[]{TextComponent.of((int)((int)radius))}));
        ToolCommands.sendUnbindInstruction(player, UNBIND_COMMAND_COMPONENT);
    }

    @Command(name="heightmap", desc="Heightmap brush, raises or lowers terrain using an image heightmap")
    @CommandPermissions(value={"worldedit.brush.heightmap"})
    void heightmapBrush(Player player, LocalSession session, @Arg(desc="The name of the image") String imageName, @Arg(desc="The size of the brush", def={"5"}) double radius, @Arg(desc="The intensity of the brush", def={"5"}) double intensity, @Switch(name=101, desc="Erase blocks instead of filling them") boolean erase, @Switch(name=102, desc="Don't change blocks above the selected height") boolean flatten, @Switch(name=114, desc="Randomizes the brush's height slightly.") boolean randomize) throws WorldEditException {
        Optional<AssetLoader<ImageHeightmap>> loader = this.worldEdit.getAssetLoaders().getAssetLoader(ImageHeightmap.class, imageName);
        if (loader.isPresent()) {
            this.worldEdit.checkMaxBrushRadius(radius);
            BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
            AssetLoadTask<ImageHeightmap> task = new AssetLoadTask<ImageHeightmap>(loader.get(), imageName);
            AsyncCommandBuilder.wrap(task, player).registerWithSupervisor(this.worldEdit.getSupervisor(), "Loading asset " + imageName).setDelayMessage((Component)TranslatableComponent.of((String)"worldedit.asset.load.loading")).setWorkingMessage((Component)TranslatableComponent.of((String)"worldedit.asset.load.still-loading")).onSuccess((Component)TranslatableComponent.of((String)"worldedit.brush.heightmap.equip", (Component[])new Component[]{TextComponent.of((int)((int)radius))}), heightmap -> {
                tool.setSize(radius);
                tool.setBrush(new ImageHeightmapBrush((ImageHeightmap)heightmap, intensity, erase, flatten, randomize), "worldedit.brush.heightmap");
                ToolCommands.sendUnbindInstruction(player, UNBIND_COMMAND_COMPONENT);
            }).onFailure((Component)TranslatableComponent.of((String)"worldedit.asset.load.failed"), this.worldEdit.getPlatformManager().getPlatformCommandManager().getExceptionConverter()).buildAndExec(this.worldEdit.getExecutorService());
        } else {
            player.printError((Component)TranslatableComponent.of((String)"worldedit.brush.heightmap.unknown", (Component[])new Component[]{TextComponent.of((String)imageName)}));
        }
    }

    @Command(name="deform", desc="Deform brush, applies an expression to an area")
    @CommandPermissions(value={"worldedit.brush.deform"})
    public void deform(Player player, LocalSession localSession, @Arg(desc="The shape of the region") RegionFactory shape, @Arg(desc="The size of the brush", def={"5"}) double radius, @Arg(desc="Expression to apply", def={"y-=0.2"}) String expression, @Switch(name=114, desc="Use the game's coordinate origin") boolean useRawCoords, @Switch(name=111, desc="Use the placement position as the origin") boolean usePlacement) throws WorldEditException {
        Deform deform = new Deform(expression);
        if (useRawCoords) {
            deform.setMode(Deform.Mode.RAW_COORD);
        } else if (usePlacement) {
            deform.setMode(Deform.Mode.OFFSET);
            deform.setOffset(localSession.getPlacementPosition(player).toVector3());
        }
        BrushCommands.setOperationBasedBrush(player, localSession, radius, deform, shape, "worldedit.brush.deform");
    }

    @Command(name="set", desc="Set brush, sets all blocks in the area")
    @CommandPermissions(value={"worldedit.brush.set"})
    public void set(Player player, LocalSession localSession, @Arg(desc="The shape of the region") RegionFactory shape, @Arg(desc="The size of the brush", def={"5"}) double radius, @Arg(desc="The pattern of blocks to set") Pattern pattern) throws WorldEditException {
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new ApplyRegion(new ReplaceFactory(pattern)), shape, "worldedit.brush.set");
    }

    @Command(name="forest", desc="Forest brush, creates a forest in the area")
    @CommandPermissions(value={"worldedit.brush.forest"})
    public void forest(Player player, LocalSession localSession, @Arg(desc="The shape of the region") RegionFactory shape, @Arg(desc="The size of the brush", def={"5"}) double radius, @Arg(desc="The density of the brush", def={"20"}) double density, @Arg(desc="The type of tree to use") TreeGenerator.TreeType type) throws WorldEditException {
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new Paint(new TreeGeneratorFactory(type), density / 100.0), shape, "worldedit.brush.forest");
    }

    @Command(name="raise", desc="Raise brush, raise all blocks by one")
    @CommandPermissions(value={"worldedit.brush.raise"})
    public void raise(Player player, LocalSession localSession, @Arg(desc="The shape of the region") RegionFactory shape, @Arg(desc="The size of the brush", def={"5"}) double radius) throws WorldEditException {
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new Deform("y-=1", Deform.Mode.RAW_COORD), shape, "worldedit.brush.raise");
    }

    @Command(name="lower", desc="Lower brush, lower all blocks by one")
    @CommandPermissions(value={"worldedit.brush.lower"})
    public void lower(Player player, LocalSession localSession, @Arg(desc="The shape of the region") RegionFactory shape, @Arg(desc="The size of the brush", def={"5"}) double radius) throws WorldEditException {
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new Deform("y+=1", Deform.Mode.RAW_COORD), shape, "worldedit.brush.lower");
    }

    @Command(name="snow", desc="Snow brush, sets snow in the area")
    @CommandPermissions(value={"worldedit.brush.snow"})
    public void snow(Player player, LocalSession localSession, @Arg(desc="The shape of the region") RegionFactory shape, @Arg(desc="The size of the brush", def={"5"}) double radius, @Switch(name=115, desc="Whether to stack snow") boolean stack) throws WorldEditException {
        if (shape instanceof CylinderRegionFactory) {
            shape = new CylinderRegionFactory(radius);
        }
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new ApplyLayer(new Snow(stack)), shape, "worldedit.brush.snow");
    }

    @Command(name="biome", desc="Biome brush, sets biomes in the area")
    @CommandPermissions(value={"worldedit.brush.biome"})
    public void biome(Player player, LocalSession localSession, @Arg(desc="The shape of the region") RegionFactory shape, @Arg(desc="The size of the brush", def={"5"}) double radius, @Arg(desc="The biome type") BiomeType biomeType) throws WorldEditException {
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new ApplyRegion(new BiomeFactory(biomeType)), shape, "worldedit.brush.biome");
        player.printInfo((Component)TranslatableComponent.of((String)"worldedit.setbiome.warning"));
    }

    static void setOperationBasedBrush(Player player, LocalSession session, double radius, Contextual<? extends Operation> factory, RegionFactory shape, String permission) throws WorldEditException {
        WorldEdit.getInstance().checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setSize(radius);
        tool.setFill(null);
        tool.setBrush(new OperationFactoryBrush(factory, shape, session), permission);
        player.printInfo((Component)TranslatableComponent.of((String)"worldedit.brush.operation.equip", (Component[])new Component[]{TextComponent.of((String)factory.toString())}));
        ToolCommands.sendUnbindInstruction(player, UNBIND_COMMAND_COMPONENT);
    }
}

