/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public enum Instrument {
    PIANO(0),
    BASS_DRUM(1),
    SNARE_DRUM(2),
    STICKS(3),
    BASS_GUITAR(4),
    FLUTE(5),
    BELL(6),
    GUITAR(7),
    CHIME(8),
    XYLOPHONE(9),
    IRON_XYLOPHONE(10),
    COW_BELL(11),
    DIDGERIDOO(12),
    BIT(13),
    BANJO(14),
    PLING(15),
    ZOMBIE(16),
    SKELETON(17),
    CREEPER(18),
    DRAGON(19),
    WITHER_SKELETON(20),
    PIGLIN(21),
    CUSTOM_HEAD(22);

    private final byte type;
    private static final Map<Byte, Instrument> BY_DATA;

    private Instrument(int type) {
        this.type = (byte)type;
    }

    @ApiStatus.Internal
    public byte getType() {
        return this.type;
    }

    @ApiStatus.Internal
    @Nullable
    public static Instrument getByType(byte type) {
        return BY_DATA.get(type);
    }

    static {
        BY_DATA = Maps.newHashMap();
        for (Instrument instrument : Instrument.values()) {
            BY_DATA.put(instrument.getType(), instrument);
        }
    }
}

