/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.utils;

import dev.lone.itemsadder.api.CustomStack;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import me.jet315.minions.Core;
import me.jet315.minions.hooks.listeners.HBDLoadListener;
import me.jet315.minions.loader.SkinLoader;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.reflection.MinecraftVersion;
import me.jet315.minions.reflection.ReflectionUtils;
import me.jet315.minions.storage.gui.GUIItem;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.XMaterial;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Utils {
    public static String putLevelAndStatsPlaceHolder(Minion minion, String string) {
        return string.replaceAll("%STATS%", String.valueOf(minion.getStats())).replaceAll("%LEVEL%", String.valueOf(minion.getLevel()));
    }

    public static ItemStack generateHead(String string) {
        return SkinLoader.getHead(string);
    }

    public static ItemStack generateHead(OfflinePlayer offlinePlayer) {
        return SkinLoader.getHead(offlinePlayer.getName());
    }

    public static ItemStack generateHead(String string, String string2) {
        HeadDatabaseAPI headDatabaseAPI;
        ItemStack itemStack = null;
        if (string.contains("hbd-") || string.contains("hdb-")) {
            if (HBDLoadListener.isHBDLoaded) {
                try {
                    headDatabaseAPI = new HeadDatabaseAPI();
                    itemStack = headDatabaseAPI.getItemHead(string.replaceAll("hbd-", "").replaceAll("hdb-", ""));
                }
                catch (NoClassDefFoundError | NullPointerException throwable) {
                    System.out.println("JetsMinions >> Error occurred while loading head: " + string + "(HeadDatabase returned an error)");
                }
            }
        } else {
            itemStack = SkinLoader.getHead(string);
        }
        if (itemStack == null) {
            itemStack = new ItemStack(XMaterial.PLAYER_HEAD.parseMaterial());
            if (string.contains("hbd-") || string.contains("hdb-")) {
                return itemStack;
            }
            System.out.println("JetsMinions >> Error occurred while loading head: " + string + " please report to Jet.");
        }
        headDatabaseAPI = (SkullMeta)itemStack.getItemMeta();
        headDatabaseAPI.setDisplayName(string2);
        itemStack.setItemMeta((ItemMeta)headDatabaseAPI);
        return itemStack;
    }

    public static ItemStack copyItemMeta(ItemStack itemStack, ItemStack itemStack2) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemMeta itemMeta2 = itemStack2.getItemMeta();
        if (itemMeta.getLore() != null && itemMeta.getLore().size() > 0) {
            itemMeta2.setLore(itemMeta.getLore());
        }
        itemMeta2.setDisplayName(itemMeta.getDisplayName());
        itemStack2.setItemMeta(itemMeta2);
        return itemStack2;
    }

    public static BlockFace minionFaceToBlockFace(MinionFace minionFace) {
        return BlockFace.valueOf((String)minionFace.toString());
    }

    public static GUIItem itemStackParser(String string, String string2, int n, String string3, String string4, List<String> list, long l, int n2) {
        try {
            ItemStack itemStack;
            String[] stringArray = string3.split(":");
            String string5 = Utils.translateColorCodes(string4);
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray.length > 1) {
                if (stringArray[0].equalsIgnoreCase("skull") || stringArray[0].equalsIgnoreCase("skull_item")) {
                    if (stringArray[1].equalsIgnoreCase("%defaultskin%")) {
                        bl = true;
                        itemStack = XMaterial.PLAYER_HEAD.parseItem();
                    } else if (stringArray[1].equalsIgnoreCase("%playersname%")) {
                        bl2 = true;
                        itemStack = XMaterial.PLAYER_HEAD.parseItem();
                    } else {
                        itemStack = Utils.generateHead(stringArray[1], string5);
                    }
                } else {
                    itemStack = XMaterial.requestXMaterial(stringArray[0], Byte.valueOf(stringArray[1])).parseItem();
                }
            } else {
                itemStack = XMaterial.fromString(stringArray[0]).parseItem();
            }
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(string5);
            if (list != null && list.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string6 : list) {
                    arrayList.add(Utils.translateColorCodes(string6));
                }
                itemMeta.setLore(arrayList);
            }
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            if (n2 != 0) {
                itemMeta.setCustomModelData(Integer.valueOf(n2));
            }
            itemStack.setItemMeta(itemMeta);
            return new GUIItem(itemStack, string2, n, bl, bl2, l);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            System.out.println(string + " > Error processing item " + string3 + " (Item is null)");
            return null;
        }
    }

    public static MinionFace getDirection(double d) {
        if (d < -300.0) {
            return MinionFace.SOUTH;
        }
        if (d < -240.0) {
            return MinionFace.WEST;
        }
        if (d < -150.0) {
            return MinionFace.NORTH;
        }
        if (d < -50.0) {
            return MinionFace.EAST;
        }
        if (d < 60.0) {
            return MinionFace.SOUTH;
        }
        if (d <= 135.0) {
            return MinionFace.WEST;
        }
        if (d <= 215.0) {
            return MinionFace.NORTH;
        }
        if (d <= 310.0) {
            return MinionFace.EAST;
        }
        return MinionFace.SOUTH;
    }

    public static float minionFaceToYaw(MinionFace minionFace) {
        if (minionFace == MinionFace.NORTH) {
            return 180.0f;
        }
        if (minionFace == MinionFace.EAST) {
            return 270.0f;
        }
        if (minionFace == MinionFace.SOUTH) {
            return 360.0f;
        }
        if (minionFace == MinionFace.WEST) {
            return 90.0f;
        }
        return 0.0f;
    }

    public static EntityType damageToEntityType(short s) {
        switch (s) {
            case 4: {
                return EntityType.ELDER_GUARDIAN;
            }
            case 5: {
                return EntityType.WITHER_SKELETON;
            }
            case 6: {
                return EntityType.STRAY;
            }
            case 23: {
                return EntityType.HUSK;
            }
            case 27: {
                return EntityType.ZOMBIE_VILLAGER;
            }
            case 28: {
                return EntityType.SKELETON_HORSE;
            }
            case 29: {
                return EntityType.ZOMBIE_HORSE;
            }
            case 31: {
                return EntityType.DONKEY;
            }
            case 32: {
                return EntityType.MULE;
            }
            case 34: {
                return EntityType.EVOKER;
            }
            case 35: {
                return EntityType.VEX;
            }
            case 36: {
                return EntityType.VINDICATOR;
            }
            case 50: {
                return EntityType.CREEPER;
            }
            case 51: {
                return EntityType.SKELETON;
            }
            case 52: {
                return EntityType.SPIDER;
            }
            case 54: {
                return EntityType.ZOMBIE;
            }
            case 55: {
                return EntityType.SLIME;
            }
            case 56: {
                return EntityType.GHAST;
            }
            case 57: {
                return EntityType.valueOf((String)"PIG_ZOMBIE");
            }
            case 58: {
                return EntityType.ENDERMAN;
            }
            case 59: {
                return EntityType.CAVE_SPIDER;
            }
            case 60: {
                return EntityType.SILVERFISH;
            }
            case 61: {
                return EntityType.BLAZE;
            }
            case 62: {
                return EntityType.MAGMA_CUBE;
            }
            case 65: {
                return EntityType.BAT;
            }
            case 66: {
                return EntityType.WITCH;
            }
            case 67: {
                return EntityType.ENDERMITE;
            }
            case 68: {
                return EntityType.GUARDIAN;
            }
            case 69: {
                return EntityType.SHULKER;
            }
            case 90: {
                return EntityType.PIG;
            }
            case 91: {
                return EntityType.SHEEP;
            }
            case 92: {
                return EntityType.COW;
            }
            case 93: {
                return EntityType.CHICKEN;
            }
            case 94: {
                return EntityType.SQUID;
            }
            case 95: {
                return EntityType.WOLF;
            }
            case 96: {
                return EntityType.MUSHROOM_COW;
            }
            case 98: {
                return EntityType.OCELOT;
            }
            case 100: {
                return EntityType.HORSE;
            }
            case 101: {
                return EntityType.RABBIT;
            }
            case 102: {
                return EntityType.POLAR_BEAR;
            }
            case 103: {
                return EntityType.LLAMA;
            }
            case 105: {
                return EntityType.PARROT;
            }
            case 120: {
                return EntityType.VILLAGER;
            }
        }
        return null;
    }

    public static ItemStack getSmeltedItemStack(ItemStack itemStack) {
        Material material;
        if (itemStack == null) {
            return null;
        }
        if (Core.getInstance().getHooks().isItemAddedEnabled() && CustomStack.byItemStack((ItemStack)itemStack) != null) {
            return itemStack;
        }
        Material material2 = itemStack.getType();
        Material material3 = XMaterial.COD.parseMaterial();
        Material material4 = XMaterial.CHICKEN.parseMaterial();
        Material material5 = XMaterial.BEEF.parseMaterial();
        Material material6 = XMaterial.NETHER_QUARTZ_ORE.parseMaterial();
        Material material7 = XMaterial.PORKCHOP.parseMaterial();
        Material material8 = XMaterial.ANCIENT_DEBRIS.parseMaterial();
        if (ReflectionUtils.mcVersion == MinecraftVersion.MC1_17 || ReflectionUtils.mcVersion == MinecraftVersion.MC1_18 || ReflectionUtils.mcVersion == MinecraftVersion.MC1_19 || ReflectionUtils.mcVersion == MinecraftVersion.MC1_20) {
            material = XMaterial.RAW_GOLD.parseMaterial();
            Material material9 = XMaterial.RAW_COPPER.parseMaterial();
            Material material10 = XMaterial.RAW_IRON.parseMaterial();
            Material material11 = XMaterial.COBBLED_DEEPSLATE.parseMaterial();
            if (material2 == material) {
                return new ItemStack(XMaterial.GOLD_INGOT.parseMaterial(), itemStack.getAmount());
            }
            if (material2 == material9) {
                return new ItemStack(XMaterial.COPPER_INGOT.parseMaterial(), itemStack.getAmount());
            }
            if (material2 == material10) {
                return new ItemStack(XMaterial.IRON_INGOT.parseMaterial(), itemStack.getAmount());
            }
            if (material5 == material11) {
                return new ItemStack(XMaterial.DEEPSLATE.parseMaterial(), itemStack.getAmount());
            }
        }
        if (material3 == material2) {
            return new ItemStack(XMaterial.COOKED_COD.parseMaterial(), itemStack.getAmount());
        }
        if (material2 == material4) {
            return new ItemStack(Material.COOKED_CHICKEN, itemStack.getAmount());
        }
        if (material2 == material5) {
            return new ItemStack(Material.COOKED_BEEF, itemStack.getAmount());
        }
        if (material2 == material6) {
            return new ItemStack(Material.QUARTZ, itemStack.getAmount());
        }
        if (material2 == material8) {
            return new ItemStack(XMaterial.NETHERITE_SCRAP.parseItem());
        }
        if (material2 == material7) {
            return new ItemStack(XMaterial.COOKED_PORKCHOP.parseMaterial(), itemStack.getAmount());
        }
        switch (material2) {
            case MUTTON: {
                return new ItemStack(Material.COOKED_MUTTON, itemStack.getAmount());
            }
            case RABBIT: {
                return new ItemStack(Material.COOKED_RABBIT, itemStack.getAmount());
            }
            case POTATO: {
                return new ItemStack(Material.BAKED_POTATO, itemStack.getAmount());
            }
            case IRON_ORE: {
                return new ItemStack(Material.IRON_INGOT, itemStack.getAmount());
            }
            case GOLD_ORE: {
                return new ItemStack(Material.GOLD_INGOT, itemStack.getAmount());
            }
            case SAND: {
                return new ItemStack(Material.GLASS, itemStack.getAmount());
            }
            case COBBLESTONE: {
                return new ItemStack(Material.STONE, itemStack.getAmount());
            }
            case CLAY_BALL: {
                return new ItemStack(XMaterial.BRICK.parseMaterial(), itemStack.getAmount());
            }
            case NETHERRACK: {
                return new ItemStack(XMaterial.NETHER_BRICK.parseMaterial(), itemStack.getAmount());
            }
            case CLAY: {
                return new ItemStack(Material.CLAY_BALL, itemStack.getAmount() * 4);
            }
            case DIAMOND_ORE: {
                return new ItemStack(Material.DIAMOND, itemStack.getAmount());
            }
            case LAPIS_ORE: {
                material = XMaterial.LAPIS_LAZULI.parseItem();
                material.setAmount(itemStack.getAmount());
                return material;
            }
            case REDSTONE_ORE: {
                return new ItemStack(Material.REDSTONE, itemStack.getAmount());
            }
            case COAL_ORE: {
                return new ItemStack(Material.COAL, itemStack.getAmount());
            }
            case EMERALD_ORE: {
                return new ItemStack(Material.EMERALD, itemStack.getAmount());
            }
            case SPONGE: {
                if (itemStack.getDurability() == 0) {
                    return null;
                }
                return new ItemStack(Material.SPONGE, itemStack.getAmount());
            }
            case SALMON: {
                return XMaterial.COOKED_SALMON.parseItem();
            }
        }
        return itemStack;
    }

    public static String translateColorCodes(String string) {
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = string.substring(matcher.start(), matcher.end());
            String string3 = string2.replace('#', 'x');
            char[] cArray = string3.toCharArray();
            StringBuilder stringBuilder = new StringBuilder("");
            for (char c : cArray) {
                stringBuilder.append("&" + c);
            }
            string = string.replace(string2, stringBuilder.toString());
            matcher = pattern.matcher(string);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

