/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.storage.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.manager.MinionPlayer;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.storage.DataFile;
import me.jet315.minions.storage.database.DataController;
import me.jet315.minions.storage.database.DatabaseType;
import me.jet315.minions.storage.database.MinionStorageI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class YAML
extends DataFile
implements MinionStorageI {
    private DataController controller;

    public YAML(String string, Core core, DataController dataController) {
        super(string, core);
        this.controller = dataController;
    }

    @Override
    public boolean initialise() {
        return super.getConfig() != null;
    }

    @Override
    public void onShutdownSave() {
        for (Minion minion : Core.getInstance().getMinionManager().getAllMinions()) {
            this.saveMinionToDatabase(minion.getPlayerUUID(), minion);
        }
        this.saveFile();
    }

    @Override
    public void saveDatabase() {
        this.onShutdownSave();
    }

    @Override
    public void loadMinions() {
        int n = 0;
        int n2 = 0;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (this.getConfig().getConfigurationSection("Players") == null || this.getConfig().getConfigurationSection("Players").getKeys(false).size() == 0) {
            return;
        }
        for (String string : this.getConfig().getConfigurationSection("Players").getKeys(false)) {
            List list = this.getConfig().getStringList("Players." + string);
            for (String string2 : list) {
                Minion minion;
                String string3 = string;
                if (string.length() <= 25 && !Core.getInstance().getProperties().useUUIDS()) {
                    string3 = Bukkit.getOfflinePlayer((String)string).getUniqueId().toString();
                }
                if ((minion = this.controller.loadMinionFromString(UUID.fromString(string3), string2)) == null) {
                    if (hashMap.containsKey(string3)) {
                        hashMap.get(string3).add(string2);
                    } else {
                        hashMap.put(string3, new ArrayList());
                        hashMap.get(string3).add(string2);
                    }
                    ++n;
                    continue;
                }
                ++n2;
            }
        }
        System.out.println("[JetsMinions] Loaded " + n2 + "/" + (n2 + n) + " Minions");
        if (n > 0) {
            System.out.println("[JetsMinions] Waiting for server to load before loading " + n + " Minions");
            this.loadFailedMinions(hashMap);
        }
    }

    private void loadFailedMinions(final HashMap<String, List<String>> hashMap) {
        new BukkitRunnable(){
            int c = 500;

            public void run() {
                --this.c;
                if (hashMap.size() == 0 || this.c == 0) {
                    if (hashMap.size() == 0) {
                        System.out.println("[JetsMinions] All minions have successfully been loaded");
                    } else {
                        System.out.println("[JetsMinions] " + hashMap.size() + " minions have failed to load");
                    }
                    this.cancel();
                    return;
                }
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Iterator iterator2 = ((List)hashMap.get(string)).iterator();
                    while (iterator2.hasNext()) {
                        String string2 = (String)iterator2.next();
                        if (YAML.this.controller.loadMinionFromString(UUID.fromString(string), string2) == null) continue;
                        iterator2.remove();
                    }
                    if (((List)hashMap.get(string)).size() != 0) continue;
                    iterator.remove();
                }
            }
        }.runTaskTimer((Plugin)Core.getInstance(), 100L, 100L);
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.YAML;
    }

    @Override
    public void addMinionUUIDToDatabase(Minion minion) {
        this.getConfig().set("MinionUUIDs." + minion.getMinion().getArmorStand().getUniqueId(), (Object)"");
        if (this.controller.shouldSaveFile(false)) {
            this.saveFile();
        }
    }

    @Override
    public void removeMinionUUIDFromDatabase(UUID uUID) {
        this.getConfig().set("MinionUUIDs." + uUID, null);
        if (this.controller.shouldSaveFile(false)) {
            this.saveFile();
        }
    }

    @Override
    public void updateMinionUUIDList(ArrayList<UUID> arrayList) {
        for (String string : this.getConfig().getConfigurationSection("MinionUUIDs").getKeys(false)) {
            UUID uUID = UUID.fromString(string);
            if (arrayList.contains(uUID)) continue;
            this.getConfig().set("MinionUUIDs." + uUID, null);
        }
        if (this.controller.shouldSaveFile(true)) {
            this.saveFile();
        }
    }

    @Override
    public boolean isEntityMinion(Entity entity) {
        return this.getConfig().contains("MinionUUIDs." + entity.getUniqueId());
    }

    @Override
    public ArrayList<Location> getMinionLocationsFromUUID(UUID uUID) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        List list = this.getConfig().getStringList("Players." + uUID);
        if (list.size() > 0) {
            for (String string : list) {
                String[] stringArray = string.split(",");
                arrayList.add(new Location(Bukkit.getWorld((String)stringArray[1]), Double.valueOf(stringArray[2]).doubleValue(), Double.valueOf(stringArray[3]).doubleValue(), Double.valueOf(stringArray[4]).doubleValue()));
            }
        }
        return arrayList;
    }

    @Override
    public void deleteMinionFromDatabase(Location location, UUID uUID) {
        String string = location.getWorld().getName();
        String string2 = String.valueOf(location.getBlockX());
        String string3 = String.valueOf(location.getBlockY());
        String string4 = String.valueOf(location.getBlockZ());
        if (uUID != null) {
            this.getConfig().set("MinionUUIDs." + uUID, null);
        }
        for (String string5 : this.getConfig().getConfigurationSection("Players").getKeys(false)) {
            List list = this.getConfig().getStringList("Players." + string5);
            if (list.size() <= 0) continue;
            for (String string6 : list) {
                String[] stringArray = string6.split(",");
                if (!stringArray[1].equals(string) || !stringArray[2].equals(string2) || !stringArray[3].equals(string3) && !stringArray[3].equals(string3 + ".0") || !stringArray[4].equals(string4)) continue;
                list.remove(string6);
                this.getConfig().set("Players." + string5, (Object)list);
                Player player = null;
                for (Object object : Bukkit.getOnlinePlayers()) {
                    if (!object.getUniqueId().toString().equals(string5)) continue;
                    player = object;
                    break;
                }
                if (player != null && player.isOnline()) {
                    Object object;
                    MinionPlayer minionPlayer = Core.getInstance().getMinionManager().getMinionPlayer(UUID.fromString(string5));
                    object = (ArrayList)minionPlayer.getPlayersMinions().clone();
                    Iterator iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        Minion minion = (Minion)iterator.next();
                        if (!minion.getMinion().getArmorStand().getLocation().equals((Object)location)) continue;
                        Core.getInstance().getMinionManager().removeMinionFromList(minion);
                        minionPlayer.getPlayersMinions().remove(minion);
                        break;
                    }
                }
                if (this.controller.shouldSaveFile(true)) {
                    this.saveFile();
                }
                return;
            }
        }
    }

    @Override
    public void saveMinionToDatabase(UUID uUID, Minion minion) {
        String string = this.controller.getMinionToString(minion);
        String string2 = this.controller.getStorageIDForPlayer(uUID);
        ArrayList<String> arrayList = this.getConfig().getStringList("Players." + string2);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        String[] stringArray = this.controller.getMinionToString(minion).split(",");
        for (String string3 : arrayList) {
            String[] stringArray2 = string3.split(",");
            if (!stringArray2[0].equalsIgnoreCase(stringArray[0]) || !stringArray2[1].equalsIgnoreCase(stringArray[1]) || !stringArray2[2].equalsIgnoreCase(stringArray[2]) || !stringArray2[3].equalsIgnoreCase(stringArray[3]) || !stringArray2[4].equalsIgnoreCase(stringArray[4])) continue;
            arrayList.remove(string3);
            break;
        }
        arrayList.add(string);
        this.getConfig().set("Players." + string2, arrayList);
    }

    @Override
    public void removeMinionFromDatabase(UUID uUID, Minion minion) {
        String[] stringArray = this.controller.getMinionToString(minion).split(",");
        String string = this.controller.getStorageIDForPlayer(uUID);
        List list = this.getConfig().getStringList("Players." + string);
        if (list == null) {
            return;
        }
        for (String string2 : list) {
            String[] stringArray2 = string2.split(",");
            if (!stringArray2[0].equalsIgnoreCase(stringArray[0]) || !stringArray2[1].equalsIgnoreCase(stringArray[1]) || !stringArray2[2].equalsIgnoreCase(stringArray[2]) || !stringArray2[3].equalsIgnoreCase(stringArray[3]) || !stringArray2[4].equalsIgnoreCase(stringArray[4])) continue;
            list.remove(string2);
            break;
        }
        this.getConfig().set("Players." + string, (Object)list);
        if (this.controller.shouldSaveFile(true)) {
            this.saveFile();
        }
    }

    @Override
    public void updateMinionsHealthAndStatsInDatabase(UUID uUID, ArrayList<Minion> arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            String string = this.controller.getStorageIDForPlayer(uUID);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            List list = this.getConfig().getStringList("Players." + string);
            block0: for (Minion object : arrayList) {
                String string2 = this.controller.getMinionToString(object);
                String[] stringArray = string2.split(",");
                for (String string3 : list) {
                    String[] stringArray2 = string3.split(",");
                    if (!stringArray2[0].equalsIgnoreCase(stringArray[0]) || !stringArray2[1].equalsIgnoreCase(stringArray[1]) || !stringArray2[2].equalsIgnoreCase(stringArray[2]) || !stringArray2[3].equalsIgnoreCase(stringArray[3]) || !stringArray2[4].equalsIgnoreCase(stringArray[4])) continue;
                    arrayList2.add(string2);
                    list.remove(string3);
                    continue block0;
                }
            }
            for (String string4 : list) {
                arrayList2.add(string4);
            }
            this.getConfig().set("Players." + string, arrayList2);
            if (this.controller.shouldSaveFile(false)) {
                this.saveFile();
            }
        }
    }

    @Override
    public ArrayList<Location> getLocationOfAllMinions() {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        for (String string : this.getConfig().getConfigurationSection("Players").getKeys(false)) {
            List list = this.getConfig().getStringList("Players." + string);
            for (String string2 : list) {
                String[] stringArray = string2.split(",");
                arrayList.add(new Location(Bukkit.getWorld((String)stringArray[1]), Double.valueOf(stringArray[2]).doubleValue(), Double.valueOf(stringArray[3]).doubleValue(), Double.valueOf(stringArray[4]).doubleValue()));
            }
        }
        return arrayList;
    }

    @Override
    public void updateChestToDatabase(UUID uUID, Minion minion) {
        this.updateChestOrLevelToDatabase(uUID, minion);
        if (this.controller.shouldSaveFile(false)) {
            this.saveFile();
        }
    }

    @Override
    public void updateLevelToDatabase(UUID uUID, Minion minion) {
        this.updateChestToDatabase(uUID, minion);
        if (this.controller.shouldSaveFile(true)) {
            this.saveFile();
        }
    }

    private void updateChestOrLevelToDatabase(UUID uUID, Minion minion) {
        String string = this.controller.getMinionToString(minion);
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.controller.getStorageIDForPlayer(uUID);
        List list = this.getConfig().getStringList("Players." + string2);
        for (String string3 : list) {
            String[] stringArray2 = string3.split(",");
            if (!stringArray2[0].equalsIgnoreCase(stringArray[0]) || !stringArray2[1].equalsIgnoreCase(stringArray[1]) || !stringArray2[2].equalsIgnoreCase(stringArray[2]) || !stringArray2[3].equalsIgnoreCase(stringArray[3]) || !stringArray2[4].equalsIgnoreCase(stringArray[4])) continue;
            arrayList.add(string);
            list.remove(string3);
            break;
        }
        for (String string3 : list) {
            arrayList.add(string3);
        }
        this.getConfig().set("Players." + string2, arrayList);
    }
}

