/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.storage.database;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import me.jet315.minions.Core;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.storage.database.DataController;
import me.jet315.minions.storage.database.DatabaseType;
import me.jet315.minions.storage.database.SQLDatabase;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SQLite
extends SQLDatabase {
    private final String sqliteDB;
    private File databaseFile;
    private Connection connection;
    private DataController controller;
    public String sqliteCreateTableMinionDB = "CREATE TABLE IF NOT EXISTS minion_data (uuid CHAR(36), miniontype TINYTEXT,world TINYTEXT,xpos int, ypos int, zpos int, yaw int, health TINYTEXT, worldChest TINYTEXT, chestx int, chesty int, chestz int, stats int, level int, base64 TEXT);";
    public String sqliteCreateTableMinionUUIDDB = "CREATE TABLE IF NOT EXISTS minion_uuids(uuid CHAR(36), PRIMARY KEY (`uuid`));";

    public SQLite(String string, DataController dataController) {
        super(DatabaseType.SQLITE, dataController);
        this.sqliteDB = string;
        this.controller = dataController;
    }

    @Override
    public Connection openConnection() {
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.databaseFile);
        return this.connection;
    }

    @Override
    public boolean isConnectionOpen(Connection connection) {
        return false;
    }

    public boolean isConnectionOpen() {
        return this.connection != null && !this.connection.isClosed();
    }

    @Override
    public Connection getConnection() {
        if (!this.isConnectionOpen()) {
            return this.openConnection();
        }
        return this.connection;
    }

    @Override
    public boolean closeConnection(Connection connection) {
        return false;
    }

    public boolean closeConnection() {
        this.connection.close();
        return false;
    }

    @Override
    public boolean initialise() {
        this.databaseFile = new File(Core.getInstance().getDataFolder(), this.sqliteDB + ".db");
        if (!this.databaseFile.exists()) {
            try {
                Core.getInstance().getLogger().log(Level.SEVERE, "JetsMinions >> Creating SQLITE Database: " + this.sqliteDB + ".db");
                this.databaseFile.createNewFile();
            }
            catch (IOException iOException) {
                Core.getInstance().getLogger().log(Level.SEVERE, "JetsMinions >>  File write error: " + this.sqliteDB + ".db");
                return false;
            }
        }
        try {
            Statement statement = this.openConnection().createStatement();
            statement.executeUpdate(this.sqliteCreateTableMinionDB);
            statement.executeUpdate(this.sqliteCreateTableMinionUUIDDB);
            statement.close();
            this.closeConnection();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
        this.updateMinionUUIDList();
        return true;
    }

    @Override
    public void updateChestToDatabase(UUID uUID, Minion minion) {
    }

    @Override
    public void updateLevelToDatabase(UUID uUID, Minion minion) {
    }

    @Override
    public void updateDatabaseTask() {
    }

    private void updateMinionUUIDList() {
        try {
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM minion_uuids;");
            ResultSet resultSet = preparedStatement.executeQuery();
            final ArrayList<UUID> arrayList = new ArrayList<UUID>();
            while (resultSet.next()) {
                arrayList.add(UUID.fromString(resultSet.getString("uuid")));
            }
            resultSet.close();
            preparedStatement.close();
            this.closeConnection();
            Bukkit.getScheduler().runTask((Plugin)Core.getInstance(), new Runnable(){

                @Override
                public void run() {
                    SQLite.this.minionUUIDs.clear();
                    SQLite.this.minionUUIDs = arrayList;
                }
            });
        }
        catch (SQLException sQLException) {
            Bukkit.getLogger().log(Level.INFO, sQLException.getMessage());
            Bukkit.getLogger().log(Level.INFO, "JetsMinions > FAILED TO QUERY DATABASE > updateMinionUUIDList Method");
        }
    }
}

