/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.storage.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.manager.MinionPlayer;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.storage.database.DataController;
import me.jet315.minions.storage.database.DatabaseType;
import me.jet315.minions.storage.database.MinionStorageI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public abstract class SQLDatabase
implements MinionStorageI {
    private DatabaseType databaseType;
    private DataController controller;
    protected ArrayList<UUID> minionUUIDs = new ArrayList();

    public SQLDatabase(DatabaseType databaseType, DataController dataController) {
        this.controller = dataController;
        this.databaseType = databaseType;
    }

    public abstract Connection openConnection();

    public abstract boolean isConnectionOpen(Connection var1);

    public abstract Connection getConnection();

    public abstract boolean closeConnection(Connection var1);

    @Override
    public abstract boolean initialise();

    public abstract void updateDatabaseTask();

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public void onShutdownSave() {
    }

    @Override
    public void saveDatabase() {
    }

    @Override
    public void loadMinions() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Core.getInstance(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Connection connection = SQLDatabase.this.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM minion_data;");
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        SQLDatabase.this.controller.loadMinionFromString(UUID.fromString(resultSet.getString("uuid")), "" + resultSet.getString("miniontype") + "," + resultSet.getString("world") + "," + resultSet.getString("xpos") + "," + resultSet.getString("ypos") + "," + resultSet.getString("zpos") + "," + resultSet.getString("yaw") + "," + resultSet.getString("health") + "," + resultSet.getString("worldChest") + "," + resultSet.getString("chestx") + "," + resultSet.getString("chesty") + "," + resultSet.getString("chestz") + "," + resultSet.getString("stats") + "," + resultSet.getString("level") + "," + resultSet.getString("basae64") + ",");
                    }
                    resultSet.close();
                    preparedStatement.close();
                    SQLDatabase.this.closeConnection(connection);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    System.out.println("JetsMinions > FAILED TO QUERY DATABASE > loadPlayerMinionsOnJoin Method");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                finally {
                    try {
                        SQLDatabase.this.closeConnection(null);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void addMinionUUIDToDatabase(final Minion minion) {
        if (Core.getInstance().getProperties().isStoreMinionUUIDS()) {
            this.minionUUIDs.add(minion.getMinion().getArmorStand().getUniqueId());
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Core.getInstance(), new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Thread.sleep(new Random().nextInt(100) + 20);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Connection connection = SQLDatabase.this.getConnection();
                        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO minion_uuids (uuid) VALUES('" + minion.getMinion().getArmorStand().getUniqueId().toString() + "');");
                        preparedStatement.execute();
                        preparedStatement.close();
                        SQLDatabase.this.closeConnection(connection);
                    }
                    catch (SQLException sQLException) {
                        System.out.println(sQLException);
                        System.out.println("JetsMinions > FAILED TO QUERY DATABASE > addMinionToUUIDToDatabase Method");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                    finally {
                        try {
                            SQLDatabase.this.closeConnection(null);
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void removeMinionUUIDFromDatabase(final UUID uUID) {
        if (Core.getInstance().getProperties().isStoreMinionUUIDS()) {
            this.minionUUIDs.remove(uUID);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)Core.getInstance(), new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Thread.sleep(new Random().nextInt(100) + 20);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Connection connection = SQLDatabase.this.getConnection();
                        PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM minion_uuids WHERE uuid = '" + uUID.toString() + "';");
                        preparedStatement.execute();
                        preparedStatement.close();
                        SQLDatabase.this.closeConnection(connection);
                    }
                    catch (SQLException sQLException) {
                        System.out.println(sQLException);
                        System.out.println("JetsMinions > FAILED TO QUERY DATABASE > removeMinionUUIDFromDatabase Method");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                    finally {
                        try {
                            SQLDatabase.this.closeConnection(null);
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void updateMinionUUIDList(ArrayList<UUID> arrayList) {
    }

    @Override
    public boolean isEntityMinion(Entity entity) {
        return this.minionUUIDs.contains(entity.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Location> getMinionLocationsFromUUID(UUID uUID) {
        try {
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM minion_data WHERE uuid = " + uUID.toString() + ";");
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<Location> arrayList = new ArrayList<Location>();
            while (resultSet.next()) {
                arrayList.add(new Location(Bukkit.getWorld((String)resultSet.getString("world")), (double)resultSet.getInt("xpos"), (double)resultSet.getInt("ypos"), (double)resultSet.getInt("zpos")));
            }
            resultSet.close();
            preparedStatement.close();
            this.closeConnection(connection);
            ArrayList<Location> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            System.out.println("JetsMinions > FAILED TO QUERY DATABASE > getMinionLocationsFromUUID Method");
            ArrayList<Location> arrayList = null;
            return arrayList;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        finally {
            try {
                this.closeConnection(null);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void deleteMinionFromDatabase(final Location location, UUID uUID) {
        final String string = location.getWorld().getName();
        final int n = location.getBlockX();
        int n2 = location.getBlockY();
        final int n3 = location.getBlockZ();
        if (uUID != null) {
            this.removeMinionUUIDFromDatabase(uUID);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Core.getInstance(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Connection connection = SQLDatabase.this.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM minion_data WHERE world = '" + string + "' AND xpos = '" + n + "' AND zpos = '" + n3 + "';");
                    preparedStatement.execute();
                    block15: for (final MinionPlayer minionPlayer : Core.getInstance().getMinionManager().getMinionPlayers()) {
                        for (final Minion minion : minionPlayer.getPlayersMinions()) {
                            if (!minion.getMinion().getArmorStand().getLocation().equals((Object)location)) continue;
                            Bukkit.getScheduler().runTask((Plugin)Core.getInstance(), new Runnable(){

                                @Override
                                public void run() {
                                    Core.getInstance().getMinionManager().removeMinionFromList(minion);
                                    minionPlayer.getPlayersMinions().remove(minion);
                                }
                            });
                            continue block15;
                        }
                    }
                    preparedStatement.close();
                    SQLDatabase.this.closeConnection(connection);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    System.out.println("JetsMinions > FAILED TO QUERY DATABASE > deleteMinionFromDatabase Method");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                finally {
                    try {
                        SQLDatabase.this.closeConnection(null);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void saveMinionToDatabase(final UUID uUID, final Minion minion) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Core.getInstance(), new Runnable(){

            @Override
            public void run() {
                try {
                    Connection connection = SQLDatabase.this.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO minion_data (uuid, miniontype,world,xpos, ypos, zpos, yaw, health, worldChest, chestx, chesty, chestz, stats, level, base64) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);");
                    preparedStatement.setString(1, SQLDatabase.this.controller.getStorageIDForPlayer(uUID));
                    preparedStatement.setString(2, minion.getIdentifier());
                    preparedStatement.setString(3, minion.getMinion().getArmorStand().getLocation().getWorld().getName());
                    preparedStatement.setInt(4, minion.getMinion().getArmorStand().getLocation().getBlockX());
                    preparedStatement.setInt(5, minion.getMinion().getArmorStand().getLocation().getBlockY());
                    preparedStatement.setInt(6, minion.getMinion().getArmorStand().getLocation().getBlockZ());
                    preparedStatement.setInt(7, (int)minion.getMinion().getArmorStand().getLocation().getYaw());
                    preparedStatement.setString(8, minion.getHealth() + "/" + minion.getMaxHealth());
                    preparedStatement.setString(9, minion.getMinion().getAttachedChest() == null ? "null" : minion.getMinion().getAttachedChest().getLocation().getWorld().getName());
                    preparedStatement.setInt(10, minion.getMinion().getAttachedChest() == null ? 0 : minion.getMinion().getAttachedChest().getLocation().getBlockX());
                    preparedStatement.setInt(11, minion.getMinion().getAttachedChest() == null ? 0 : minion.getMinion().getAttachedChest().getLocation().getBlockY());
                    preparedStatement.setInt(12, minion.getMinion().getAttachedChest() == null ? 0 : minion.getMinion().getAttachedChest().getLocation().getBlockZ());
                    preparedStatement.setInt(13, minion.getStats());
                    preparedStatement.setInt(14, minion.getLevel());
                    preparedStatement.setString(15, minion.getRawBase64());
                    preparedStatement.execute();
                    preparedStatement.close();
                    SQLDatabase.this.closeConnection(connection);
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    System.out.println("JetsMinions > FAILED TO QUERY DATABASE > saveMinionToDatabase Method");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                finally {
                    try {
                        SQLDatabase.this.closeConnection(null);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void removeMinionFromDatabase(final UUID uUID, Minion minion) {
        final Location location = minion.getMinion().getArmorStand().getLocation();
        final String string = location.getWorld().getName();
        final int n = location.getBlockX();
        final int n2 = location.getBlockY();
        final int n3 = location.getBlockZ();
        if (minion.getMinion().getArmorStand().getUniqueId() != null) {
            this.removeMinionUUIDFromDatabase(minion.getMinion().getArmorStand().getUniqueId());
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Core.getInstance(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Connection connection = SQLDatabase.this.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM minion_data WHERE uuid = '" + SQLDatabase.this.controller.getStorageIDForPlayer(uUID) + "' AND world = '" + string + "' AND xpos = '" + n + "' AND ypos = '" + n2 + "' AND zpos = '" + n3 + "';");
                    preparedStatement.execute();
                    preparedStatement.close();
                    SQLDatabase.this.closeConnection(connection);
                    block15: for (final MinionPlayer minionPlayer : Core.getInstance().getMinionManager().getMinionPlayers()) {
                        for (final Minion minion : minionPlayer.getPlayersMinions()) {
                            if (!minion.getMinion().getArmorStand().getLocation().equals((Object)location)) continue;
                            Bukkit.getScheduler().runTask((Plugin)Core.getInstance(), new Runnable(){

                                @Override
                                public void run() {
                                    Core.getInstance().getMinionManager().removeMinionFromList(minion);
                                    minionPlayer.getPlayersMinions().remove(minion);
                                }
                            });
                            continue block15;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException);
                    System.out.println("JetsMinions > FAILED TO QUERY DATABASE > removeMinionFromDatabase Method");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                finally {
                    try {
                        SQLDatabase.this.closeConnection(null);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void updateMinionsHealthAndStatsInDatabase(final UUID uUID, final ArrayList<Minion> arrayList) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Core.getInstance(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Minion minion : arrayList) {
                    try {
                        Connection connection = SQLDatabase.this.getConnection();
                        PreparedStatement preparedStatement = connection.prepareStatement("UPDATE minion_data SET health = ?, worldChest = ?, chestx = ?, chesty = ?, chestz = ?, stats = ?, level = ?, base64 = ? WHERE uuid = ? AND world = ? AND xpos = ? AND ypos = ? AND zpos = ?;");
                        preparedStatement.setString(1, minion.getHealth() + "/" + minion.getMaxHealth());
                        preparedStatement.setString(2, minion.getMinion().getAttachedChest() == null ? "null" : minion.getMinion().getAttachedChest().getLocation().getWorld().getName());
                        preparedStatement.setInt(3, minion.getMinion().getAttachedChest() == null ? 0 : minion.getMinion().getAttachedChest().getLocation().getBlockX());
                        preparedStatement.setInt(4, minion.getMinion().getAttachedChest() == null ? 0 : minion.getMinion().getAttachedChest().getLocation().getBlockY());
                        preparedStatement.setInt(5, minion.getMinion().getAttachedChest() == null ? 0 : minion.getMinion().getAttachedChest().getLocation().getBlockZ());
                        preparedStatement.setInt(6, minion.getStats());
                        preparedStatement.setInt(7, minion.getLevel());
                        preparedStatement.setString(8, minion.getRawBase64());
                        preparedStatement.setString(9, SQLDatabase.this.controller.getStorageIDForPlayer(uUID));
                        preparedStatement.setString(10, minion.getMinion().getArmorStand().getLocation().getWorld().getName());
                        preparedStatement.setInt(11, minion.getMinion().getArmorStand().getLocation().getBlockX());
                        preparedStatement.setInt(12, minion.getMinion().getArmorStand().getLocation().getBlockY());
                        preparedStatement.setInt(13, minion.getMinion().getArmorStand().getLocation().getBlockZ());
                        preparedStatement.execute();
                        preparedStatement.close();
                        SQLDatabase.this.closeConnection(connection);
                    }
                    catch (SQLException sQLException) {
                        System.out.println(sQLException);
                        System.out.println("JetsMinions > FAILED TO QUERY DATABASE > updateMinionsHealthAndStatsInDatabase Method > Debug: " + uUID + " : " + arrayList.size());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                    finally {
                        try {
                            SQLDatabase.this.closeConnection(null);
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    @Override
    public ArrayList<Location> getLocationOfAllMinions() {
        return null;
    }
}

