/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.storage.database;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import me.jet315.minions.Core;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.storage.Properties;
import me.jet315.minions.storage.database.DataController;
import me.jet315.minions.storage.database.DatabaseType;
import me.jet315.minions.storage.database.SQLDatabase;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MySQL
extends SQLDatabase {
    private final String user;
    private final String database;
    private final String password;
    private final String port;
    private final String hostname;
    private boolean ssl;
    private HikariDataSource hikari;
    private DataController controller;

    public MySQL(Core core, Properties properties, String string, String string2, String string3, String string4, String string5, boolean bl, DataController dataController) {
        super(DatabaseType.MYSQL, dataController);
        this.hostname = string;
        this.port = string2;
        this.database = string3;
        this.user = string4;
        this.password = string5;
        this.controller = dataController;
        this.ssl = bl;
        this.connectToDB();
    }

    private void connectToDB() {
        this.hikari = new HikariDataSource();
        this.hikari.setJdbcUrl("jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.database);
        this.hikari.addDataSourceProperty("user", (Object)this.user);
        this.hikari.addDataSourceProperty("password", (Object)this.password);
        this.hikari.addDataSourceProperty("useSSL", (Object)(this.ssl ? "yes" : "no"));
    }

    @Override
    public Connection openConnection() {
        return this.hikari.getConnection();
    }

    @Override
    public boolean isConnectionOpen(Connection connection) {
        return connection != null && !connection.isClosed();
    }

    @Override
    public Connection getConnection() {
        return this.openConnection();
    }

    @Override
    public boolean closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initialise() {
        Statement statement;
        Connection connection;
        try {
            connection = this.getConnection();
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS minion_data (uuid CHAR(36), miniontype TINYTEXT,world TINYTEXT,xpos int, ypos int, zpos int, yaw int, health TINYTEXT, worldChest TINYTEXT, chestx int, chesty int, chestz int, stats int, level int, base64 TEXT);");
                    statement.close();
                    this.closeConnection(connection);
                    connection.close();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException sQLException) {
            Bukkit.getLogger().log(Level.INFO, "UNABLE TO CONNECT TO MYSQL DATABASE > ERROR > " + sQLException.getMessage());
            boolean bl = false;
            return bl;
        }
        try {
            connection = this.getConnection();
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS minion_uuids(uuid CHAR(36), PRIMARY KEY (`uuid`));");
                    statement.close();
                    this.closeConnection(connection);
                    connection.close();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException sQLException) {
            Bukkit.getLogger().log(Level.INFO, "UNABLE TO CONNECT TO MYSQL DATABASE > ERROR > " + sQLException.getMessage());
            boolean bl = false;
            return bl;
        }
        if (Core.getInstance().getProperties().isStoreMinionUUIDS()) {
            this.updateDatabaseTask();
            this.updateMinionUUIDList();
        }
        return true;
    }

    @Override
    public void updateChestToDatabase(UUID uUID, Minion minion) {
    }

    @Override
    public void updateLevelToDatabase(UUID uUID, Minion minion) {
    }

    @Override
    public void updateDatabaseTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Core.getInstance(), new Runnable(){

            @Override
            public void run() {
                MySQL.this.updateMinionUUIDList();
            }
        }, 200L, 200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMinionUUIDList() {
        try {
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM minion_uuids;");
            ResultSet resultSet = preparedStatement.executeQuery();
            final ArrayList<UUID> arrayList = new ArrayList<UUID>();
            while (resultSet.next()) {
                arrayList.add(UUID.fromString(resultSet.getString("uuid")));
            }
            resultSet.close();
            preparedStatement.close();
            this.closeConnection(connection);
            Bukkit.getScheduler().runTask((Plugin)Core.getInstance(), new Runnable(){

                @Override
                public void run() {
                    MySQL.this.minionUUIDs.clear();
                    MySQL.this.minionUUIDs = arrayList;
                }
            });
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            Bukkit.getLogger().log(Level.INFO, "JetsMinions > FAILED TO QUERY DATABASE > updateMinionUUIDList Method");
        }
    }
}

