/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.storage.database;

import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import java.util.logging.Level;
import me.jet315.minions.Core;
import me.jet315.minions.MinionAPI;
import me.jet315.minions.events.MinionLoadEvent;
import me.jet315.minions.manager.MinionPlayer;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.storage.ChestToLoad;
import me.jet315.minions.storage.MinionProperties;
import me.jet315.minions.storage.Properties;
import me.jet315.minions.storage.database.DatabaseType;
import me.jet315.minions.storage.database.MinionStorageI;
import me.jet315.minions.storage.database.MySQL;
import me.jet315.minions.storage.database.SQLite;
import me.jet315.minions.storage.database.YAML;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DataController {
    private MinionStorageI storage;
    protected long lastTimeSaved = System.currentTimeMillis();

    public DataController() {
        this.enable();
    }

    public void enable() {
        this.initialise();
    }

    private void initialise() {
        Core core = Core.getInstance();
        Properties properties = core.getProperties();
        this.storage = properties.getDatabaseType() == DatabaseType.MYSQL ? new MySQL(core, properties, properties.getMySQLHost(), properties.getMySQLPort(), properties.getMySQLDB(), properties.getMySQLUser(), properties.getMySQLPassword(), properties.isMySQLSSL(), this) : (properties.getDatabaseType() == DatabaseType.SQLITE ? new SQLite("players", this) : new YAML("players.yml", core, this));
        boolean bl = this.storage.initialise();
        if (!bl) {
            if (properties.getDatabaseType() != DatabaseType.YAML) {
                properties.setDatabaseType(DatabaseType.YAML);
                Bukkit.getLogger().log(Level.INFO, "JetsMinions >> ERROR >> SQL DATABASE FAILED TO INITALISE >> FALLING BACK TO YAML STORAGE");
                this.storage = new YAML("Players.yml", core, this);
                this.storage.initialise();
            } else {
                Bukkit.getLogger().log(Level.INFO, "JetsMinions >> ERROR >> UNABLE TO FIND A STORAGE DATABASE, DISABLING THE PLUGIN FOR SAFETY");
                Bukkit.getPluginManager().disablePlugin((Plugin)Core.getInstance());
                return;
            }
        }
    }

    public DatabaseType getDatabase() {
        return this.storage.getDatabaseType();
    }

    public MinionStorageI getStorage() {
        return this.storage;
    }

    protected Minion loadMinionFromString(UUID uUID, String string) {
        MinionEntity minionEntity2;
        Object object;
        String[] stringArray = string.split(",");
        World world = Bukkit.getWorld((String)stringArray[1]);
        if (world == null) {
            return null;
        }
        ChestToLoad chestToLoad = new ChestToLoad(null, 0, 0, 0);
        if (Bukkit.getWorld((String)stringArray[7]) != null) {
            chestToLoad = new ChestToLoad(Bukkit.getWorld((String)stringArray[7]), Integer.valueOf(stringArray[8]), Integer.valueOf(stringArray[9]), Integer.valueOf(stringArray[10]));
        }
        String string2 = null;
        if (stringArray.length >= 14) {
            string2 = stringArray[13];
        }
        String string3 = stringArray[6];
        int n = 0;
        int n2 = 20;
        if (string3.contains("/")) {
            object = string3.split("/");
            n = Integer.parseInt(object[0]);
            n2 = Integer.parseInt(object[1]);
        } else {
            n = Integer.valueOf(string3);
        }
        object = stringArray[0];
        double d = Double.valueOf(stringArray[2]);
        double d2 = Double.valueOf(stringArray[3]);
        double d3 = Double.valueOf(stringArray[4]);
        ArmorStand armorStand = null;
        if (!stringArray[2].contains(".") || !stringArray[4].contains(".")) {
            Core.getInstance().getDataController().getStorage().deleteMinionFromDatabase(new Location(world, (double)Integer.valueOf(stringArray[2]).intValue(), d2, (double)Integer.valueOf(stringArray[4]).intValue()), null);
            for (MinionEntity minionEntity2 : world.getNearbyEntities(new Location(world, d, d2, d3), 0.5, 0.5, 0.5)) {
                if (!MinionAPI.isMinion((Entity)minionEntity2)) continue;
                armorStand = (ArmorStand)minionEntity2;
                break;
            }
        }
        Location location = armorStand == null ? new Location(world, d, d2, d3, (float)Integer.valueOf(stringArray[5]).intValue(), 0.0f) : armorStand.getLocation();
        minionEntity2 = new MinionEntity(location, armorStand);
        MinionProperties minionProperties = Core.getInstance().getMinionManager().getMinionProperties().get(object);
        Class<? extends Minion> clazz = Core.getInstance().getMinionManager().getValidMinions().get(object);
        Minion minion = null;
        try {
            minion = clazz.getDeclaredConstructor(UUID.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, MinionEntity.class, MinionFace.class, ItemStack.class, Integer.TYPE).newInstance(new Object[]{uUID, minionProperties.isHealthEnabled(), minionProperties.getActionsPerHealth(), n, n2, Integer.valueOf(stringArray[11]), minionEntity2, Utils.getDirection(armorStand == null ? 0.0 : (double)armorStand.getLocation().getYaw()), minionProperties.getDisplayItem(), Integer.valueOf(stringArray[12])});
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        if (minion == null) {
            System.out.println("Minions > An error has occurred while trying to load " + string + " Minion (Reference for Dev - MinionObject null)");
            return null;
        }
        minion.setRawBase64(string2);
        MinionLoadEvent minionLoadEvent = new MinionLoadEvent(uUID, minion);
        Core.getInstance().getServer().getPluginManager().callEvent((Event)minionLoadEvent);
        if (minionLoadEvent.isCancelled()) {
            return minion;
        }
        Core.getInstance().getMinionManager().addMinion(minion);
        if (chestToLoad.isChestToLoad()) {
            minion.getMinion().setChestLocation(chestToLoad.getChest());
        }
        MinionPlayer minionPlayer = Core.getInstance().getMinionManager().getMinionPlayer(uUID);
        minionPlayer.getPlayersMinions().add(minion);
        return minion;
    }

    protected String getStorageIDForPlayer(UUID uUID) {
        return uUID.toString();
    }

    protected String getMinionToString(Minion minion) {
        String string = minion.getIdentifier();
        String string2 = minion.getMinion().getLoc().getWorld().getName();
        double d = this.round(minion.getMinion().getLoc().getX(), 1);
        double d2 = this.round(minion.getMinion().getLoc().getY(), 1);
        double d3 = this.round(minion.getMinion().getLoc().getZ(), 1);
        int n = (int)minion.getMinion().getLoc().getYaw();
        int n2 = minion.getStats();
        int n3 = minion.getLevel();
        String string3 = minion.getRawBase64();
        String string4 = "null";
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Location location = minion.getMinion().getAttachedChestLocation();
        if (location != null) {
            string4 = location.getWorld().getName();
            n4 = location.getBlockX();
            n5 = location.getBlockY();
            n6 = location.getBlockZ();
        }
        return string + "," + string2 + "," + d + "," + d2 + "," + d3 + "," + n + "," + minion.getHealth() + "/" + minion.getMaxHealth() + "," + string4 + "," + n4 + "," + n5 + "," + n6 + "," + n2 + "," + n3 + "," + string3;
    }

    protected boolean shouldSaveFile(boolean bl) {
        if (!bl && System.currentTimeMillis() - this.lastTimeSaved <= 30000L) {
            return false;
        }
        this.lastTimeSaved = System.currentTimeMillis();
        return true;
    }

    private double round(double d, int n) {
        int n2 = (int)Math.pow(10.0, n);
        return (double)Math.round(d * (double)n2) / (double)n2;
    }
}

