/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import me.jet315.minions.Core;
import me.jet315.minions.reflection.MinecraftVersion;
import me.jet315.minions.reflection.ReflectionUtils;
import me.jet315.minions.skins.MinionSkin;
import me.jet315.minions.storage.DataFile;
import me.jet315.minions.storage.MinionProperties;
import me.jet315.minions.storage.database.DatabaseType;
import me.jet315.minions.utils.FoodItem;
import me.jet315.minions.utils.MinionPermission;
import me.jet315.minions.utils.Utils;
import me.jet315.minions.utils.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;

public class Properties
extends DataFile {
    private String pluginPrefix;
    private boolean onlyAllowMinionPickupIfFullHealth;
    private int maxAllowedNameLength;
    private boolean useUUIDS = true;
    private int maximumChestDistanceFromMinion = 30;
    private int chestLinkTimeout = 30;
    private int maxMinionsInAChunk = -1;
    private boolean reduceExpGiven = false;
    private boolean disableSkins = false;
    private boolean feedMinionFromChest = false;
    private boolean delayMinionLoading = false;
    private int databaseSaveTime = 10;
    private boolean minionFunctionOffline = false;
    private String clickTypeToPickupMinion = "LEFT";
    private boolean storeMinionUUIDS;
    private List<FoodItem> foodItems = new ArrayList<FoodItem>();
    private List<String> disabledWorlds = new ArrayList<String>();
    private List<Material> disabledBlocks = new ArrayList<Material>();
    private List<EntityType> disabledEntities = new ArrayList<EntityType>();
    private List<MinionPermission> minionPermissions = new ArrayList<MinionPermission>();
    private List<Material> disabledItems = new ArrayList<Material>();
    private List<String> minionsToFeedFromChest = new ArrayList<String>();
    private DatabaseType databaseType;
    private String mySQLHost;
    private String mySQLUser;
    private String mySQLPassword;
    private String mySQLPort;
    private String mySQLDB;
    private boolean mySQLSSL;

    public Properties(String string, Core core) {
        super(string, core);
        this.loadProperties(core);
    }

    public void loadProperties(Core core) {
        int n;
        Object object;
        Object object2;
        this.pluginPrefix = Utils.translateColorCodes(this.getConfig().getString("PluginsPrefix"));
        this.onlyAllowMinionPickupIfFullHealth = this.getConfig().getBoolean("OnlyAllowMinionPickupIfFullHealth", true);
        this.disabledWorlds = this.getConfig().getStringList("DisabledWorlds");
        this.maxAllowedNameLength = this.getConfig().getInt("MaxAllowedNameLength", 16);
        this.useUUIDS = this.getConfig().getBoolean("UseUUIDs", true);
        this.maximumChestDistanceFromMinion = this.getConfig().getInt("MaximumChestDistanceFromMinion", 30);
        this.maxMinionsInAChunk = this.getConfig().getInt("MaxMinionsInAChunk", -1);
        this.reduceExpGiven = this.getConfig().getBoolean("NerfExpGiven", false);
        this.feedMinionFromChest = this.getConfig().getBoolean("FeedMinionFromChest", false);
        this.storeMinionUUIDS = this.getConfig().getBoolean("store_minion_uuids", true);
        this.delayMinionLoading = this.getConfig().getBoolean("delay_minion_loading", false);
        this.databaseSaveTime = this.getConfig().getInt("database.save_period", 10);
        this.minionFunctionOffline = this.getConfig().getBoolean("MinionFunctionOffline", false);
        this.minionsToFeedFromChest = this.getConfig().getStringList("MinionsToFeedFromChest");
        this.chestLinkTimeout = this.getConfig().getInt("ChestLinkTimeout", 30);
        if (this.getConfig().contains("PickupMinionAction")) {
            this.clickTypeToPickupMinion = this.getConfig().getString("PickupMinionAction").toUpperCase();
        }
        for (String string : this.getConfig().getStringList("FoodList")) {
            object2 = string.split(":");
            object = null;
            n = 0;
            try {
                if (((String[])object2).length >= 3) {
                    object = XMaterial.requestXMaterial((String)object2[0], Byte.valueOf((String)object2[1])).parseItem();
                    n = Integer.parseInt((String)object2[2]);
                } else {
                    object = XMaterial.fromString((String)object2[0]).parseItem();
                    n = Integer.parseInt((String)object2[1]);
                }
            }
            catch (Exception exception) {
                Bukkit.getLogger().log(Level.WARNING, "JetsMinions >> Unable to load food config value: " + string);
            }
            if (object == null || n <= 0) continue;
            this.foodItems.add(new FoodItem((ItemStack)object, n));
        }
        for (String string : this.getConfig().getStringList("DisabledBlocks")) {
            object2 = XMaterial.fromString(string).parseMaterial();
            if (object2 == null) {
                Bukkit.getLogger().log(Level.WARNING, "config.yml > Invalid block material: " + string + " does not exist");
                continue;
            }
            this.disabledBlocks.add((Material)object2);
        }
        for (String string : this.getConfig().getStringList("DisabledEntities")) {
            try {
                object2 = EntityType.valueOf((String)string);
                this.disabledEntities.add((EntityType)object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Bukkit.getLogger().log(Level.WARNING, "config.yml > Invalid block Entity: " + string + " does not exist");
            }
        }
        for (String string : this.getConfig().getStringList("DisabledItems")) {
            object2 = Material.valueOf((String)string);
            if (string == null) {
                Bukkit.getLogger().log(Level.WARNING, "config.yml > Invalid Disabled Item : " + string + " does not exist");
                continue;
            }
            this.disabledItems.add((Material)object2);
        }
        for (String string : this.getConfig().getStringList("MaxMinionsAllowed")) {
            object2 = string.split(":");
            object = object2[0];
            try {
                n = Integer.valueOf(object2[1]);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                Bukkit.getLogger().log(Level.WARNING, "config.yml > invalid permission node: " + string);
                continue;
            }
            this.minionPermissions.add(new MinionPermission((String)object, n));
        }
        for (String string : this.getConfig().getConfigurationSection("Minions").getKeys(false)) {
            Object object3;
            object2 = "Minions." + string + ".Settings";
            object = "Minions." + string + ".Health";
            String string2 = "Minions." + string + ".DisplayItem";
            int n2 = this.getConfig().getInt((String)object2 + ".TicksPerAnimation");
            int n3 = this.getConfig().getInt((String)object2 + ".TicksPerAction");
            String string3 = this.getConfig().getString((String)object2 + ".MinionNamePlaceholder", string);
            MinionSkin minionSkin = Core.getInstance().getSkinManager().getValidMinionSkins().get(this.getConfig().getString((String)object2 + ".DefaultSkin"));
            if (minionSkin == null) {
                Bukkit.getLogger().log(Level.WARNING, "Minion Skin: " + this.getConfig().getString((String)object2 + ".DefaultSkin") + " does not exist!");
                Bukkit.getLogger().log(Level.WARNING, "Failed to load minion: " + string);
                continue;
            }
            boolean bl = this.getConfig().getBoolean((String)object + ".EnableHealth");
            int n4 = this.getConfig().getInt((String)object + ".MaxHealth", 20);
            int n5 = this.getConfig().getInt((String)object + ".ActionPerHealth");
            boolean bl2 = this.getConfig().getBoolean((String)object + ".RightClickWithFoodToFeed");
            boolean bl3 = this.getConfig().getBoolean((String)object + ".FeedWithMoney");
            int n6 = this.getConfig().getInt((String)object + ".FeedWithMoneyCost");
            Material material = Material.valueOf((String)this.getConfig().getString(string2 + ".Item"));
            if (material == null) {
                Bukkit.getLogger().log(Level.WARNING, " config.yml Minion Display item: " + this.getConfig().getString(string2 + ".Item") + " is not valid!");
                Bukkit.getLogger().log(Level.WARNING, "Failed to load minion: " + string);
                continue;
            }
            ItemStack itemStack = new ItemStack(material, 1, (short)this.getConfig().getInt(string2 + ".Damage"));
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemStack.getType() == XMaterial.DOLPHIN_SPAWN_EGG.parseMaterial()) {
                if (ReflectionUtils.mcVersion != MinecraftVersion.MC1_8) {
                    object3 = Utils.damageToEntityType((short)this.getConfig().getInt(string2 + ".Damage"));
                    if (object3 != null) {
                        ((SpawnEggMeta)itemMeta).setSpawnedType((EntityType)object3);
                    }
                } else {
                    Bukkit.getLogger().log(Level.WARNING, "Custom Spawn eggs are currently only supported on 1.11+");
                }
            }
            if (this.getConfig().getInt(string2 + ".CustomModelData", 0) != 0) {
                itemMeta.setCustomModelData(Integer.valueOf(this.getConfig().getInt(string2 + ".CustomModelData", 0)));
            }
            if (this.getConfig().getBoolean(string2 + ".Glow")) {
                itemMeta.addEnchant(Enchantment.SILK_TOUCH, 1, true);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            itemMeta.setDisplayName(Utils.translateColorCodes(this.getConfig().getString(string2 + ".DisplayName")));
            object3 = new ArrayList();
            for (String string4 : this.getConfig().getStringList(string2 + ".Lore")) {
                object3.add(Utils.translateColorCodes(string4));
            }
            itemMeta.setLore((List)object3);
            itemStack.setItemMeta(itemMeta);
            core.getMinionManager().getMinionProperties().put(string, new MinionProperties(string, n3, n2, minionSkin, bl, n4, n5, bl2, bl3, n6, itemStack));
            core.getMinionManager().getMinionProperties().get(string).setMinionNamePlaceholder(string3);
            this.databaseType = this.getConfig().getBoolean("database.mysql.use", false) ? DatabaseType.MYSQL : (this.getConfig().getBoolean("database.sqlite.use", false) ? DatabaseType.SQLITE : DatabaseType.YAML);
            if (this.databaseType != DatabaseType.MYSQL) continue;
            this.mySQLHost = this.getConfig().getString("database.mysql.host");
            this.mySQLUser = this.getConfig().getString("database.mysql.user");
            this.mySQLPassword = this.getConfig().getString("database.mysql.password");
            this.mySQLPort = this.getConfig().getString("database.mysql.port");
            this.mySQLDB = this.getConfig().getString("database.mysql.db");
            this.mySQLSSL = this.getConfig().getBoolean("database.mysql.ssl");
        }
    }

    public String getPluginPrefix() {
        return this.pluginPrefix;
    }

    public boolean isOnlyAllowMinionPickupIfFullHealth() {
        return this.onlyAllowMinionPickupIfFullHealth;
    }

    public List<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public List<FoodItem> getFoodItems() {
        return this.foodItems;
    }

    public List<Material> getDisabledBlocks() {
        return this.disabledBlocks;
    }

    public List<MinionPermission> getMinionPermissions() {
        return this.minionPermissions;
    }

    public List<EntityType> getDisabledEntities() {
        return this.disabledEntities;
    }

    public int getMaxAllowedNameLength() {
        return this.maxAllowedNameLength;
    }

    public List<Material> getDisabledItems() {
        return this.disabledItems;
    }

    public boolean useUUIDS() {
        return this.useUUIDS;
    }

    public int getMaximumChestDistanceFromMinion() {
        return this.maximumChestDistanceFromMinion;
    }

    public String getClickTypeToPickupMinion() {
        return this.clickTypeToPickupMinion;
    }

    public int getMaxMinionsInAChunk() {
        return this.maxMinionsInAChunk;
    }

    public boolean isReduceExpGiven() {
        return this.reduceExpGiven;
    }

    public boolean isDisableSkins() {
        return this.disableSkins;
    }

    public boolean isFeedMinionFromChest() {
        return this.feedMinionFromChest;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public String getMySQLHost() {
        return this.mySQLHost;
    }

    public String getMySQLUser() {
        return this.mySQLUser;
    }

    public String getMySQLPassword() {
        return this.mySQLPassword;
    }

    public String getMySQLPort() {
        return this.mySQLPort;
    }

    public String getMySQLDB() {
        return this.mySQLDB;
    }

    public boolean isMySQLSSL() {
        return this.mySQLSSL;
    }

    public boolean isStoreMinionUUIDS() {
        return this.storeMinionUUIDS;
    }

    public boolean isDelayMinionLoading() {
        return this.delayMinionLoading;
    }

    public int getDatabaseSaveTime() {
        return this.databaseSaveTime;
    }

    public void setDatabaseSaveTime(int n) {
        this.databaseSaveTime = n;
    }

    public boolean isMinionFunctionOffline() {
        return this.minionFunctionOffline;
    }

    public List<String> getMinionsToFeedFromChest() {
        return this.minionsToFeedFromChest;
    }

    public int getChestLinkTimeout() {
        return this.chestLinkTimeout;
    }
}

