/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.storage;

import java.util.ArrayList;
import me.jet315.minions.Core;
import me.jet315.minions.loader.SkinLoader;
import me.jet315.minions.skins.MinionSkin;
import me.jet315.minions.storage.DataFile;
import me.jet315.minions.storage.gui.GUIItem;
import me.jet315.minions.storage.gui.InventorySettings;
import me.jet315.minions.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;

public class MinionSkins
extends DataFile {
    private boolean disableSkins = false;

    public MinionSkins(String string, Core core) {
        super(string, core);
        this.loadProperties();
        this.loadSkinCache();
        this.loadSkins(core);
        this.loadGUI(core);
        Bukkit.getScheduler().runTaskLater((Plugin)core, new Runnable(){

            @Override
            public void run() {
                SkinLoader.saveCacheToConfig();
            }
        }, 120L);
    }

    private void loadProperties() {
        this.disableSkins = this.getConfig().getBoolean("DisableSkins", false);
    }

    private void loadSkinCache() {
        for (String string : this.getConfig().getStringList("HeadCache")) {
            SkinLoader.getHead(string);
        }
    }

    private void loadGUI(Core core) {
        Bukkit.getScheduler().runTaskLater((Plugin)core, new Runnable(){

            @Override
            public void run() {
                String string = Utils.translateColorCodes(MinionSkins.this.getConfig().getString("SkinGUI.Settings.DisplayName"));
                int n = MinionSkins.this.getConfig().getInt("SkinGUI.Settings.Size");
                InventorySettings inventorySettings = new InventorySettings("Skins", n, string, new ArrayList<GUIItem>());
                for (String string2 : MinionSkins.this.getConfig().getConfigurationSection("SkinGUI").getKeys(false)) {
                    GUIItem gUIItem;
                    int n2;
                    if (string2.equalsIgnoreCase("settings")) continue;
                    String string3 = "SkinGUI." + string2;
                    try {
                        n2 = Integer.parseInt(MinionSkins.this.getConfig().getString(string3 + ".Slot"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = -1;
                    }
                    if ((gUIItem = Utils.itemStackParser("skins.yml", MinionSkins.this.getConfig().getString(string3 + ".Action"), n2, MinionSkins.this.getConfig().getString(string3 + ".Item"), MinionSkins.this.getConfig().getString(string3 + ".DisplayName"), MinionSkins.this.getConfig().getStringList(string3 + ".Lore"), 0L, MinionSkins.this.getConfig().getInt(string3 + ".ModelData", 0))) == null) continue;
                    inventorySettings.getGuiItems().add(gUIItem);
                }
                Core.getInstance().getGuiManager().getInventorySettings().add(inventorySettings);
            }
        }, 10L);
    }

    private void loadSkins(Core core) {
        for (String string : this.getConfig().getConfigurationSection("Skins").getKeys(false)) {
            String string2 = "Skins." + string;
            String string3 = Utils.translateColorCodes(this.getConfig().getString(string2 + ".DisplayName"));
            ItemStack itemStack = new ItemStack(Material.LEATHER_CHESTPLATE);
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStack.getItemMeta();
            String[] stringArray = this.getConfig().getString(string2 + ".Body").split(",");
            leatherArmorMeta.setColor(Color.fromBGR((int)Integer.valueOf(stringArray[2]), (int)Integer.valueOf(stringArray[1]), (int)Integer.valueOf(stringArray[0])));
            itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
            ItemStack itemStack2 = new ItemStack(Material.LEATHER_LEGGINGS);
            LeatherArmorMeta leatherArmorMeta2 = (LeatherArmorMeta)itemStack2.getItemMeta();
            String[] stringArray2 = this.getConfig().getString(string2 + ".Legs").split(",");
            leatherArmorMeta2.setColor(Color.fromBGR((int)Integer.valueOf(stringArray2[2]), (int)Integer.valueOf(stringArray2[1]), (int)Integer.valueOf(stringArray2[0])));
            itemStack2.setItemMeta((ItemMeta)leatherArmorMeta2);
            ItemStack itemStack3 = new ItemStack(Material.LEATHER_BOOTS);
            LeatherArmorMeta leatherArmorMeta3 = (LeatherArmorMeta)itemStack3.getItemMeta();
            String[] stringArray3 = this.getConfig().getString(string2 + ".Boots").split(",");
            leatherArmorMeta3.setColor(Color.fromBGR((int)Integer.valueOf(stringArray3[2]), (int)Integer.valueOf(stringArray3[1]), (int)Integer.valueOf(stringArray3[0])));
            itemStack3.setItemMeta((ItemMeta)leatherArmorMeta3);
            String string4 = Utils.translateColorCodes(this.getConfig().getString(string2 + ".HeadDisplayName"));
            String string5 = this.getConfig().getString(string2 + ".HeadItem");
            ItemStack itemStack4 = null;
            try {
                Material material = Material.valueOf((String)this.getConfig().getString(string2 + ".HandItem").toUpperCase());
                itemStack4 = new ItemStack(material);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string5.equalsIgnoreCase("%head%")) {
                core.getSkinManager().getValidMinionSkins().put(string, new MinionSkin(null, true, string4, itemStack, itemStack2, itemStack3, string3, itemStack4));
                continue;
            }
            core.getSkinManager().getValidMinionSkins().put(string, new MinionSkin(string5, false, string4, itemStack, itemStack2, itemStack3, string3, itemStack4));
        }
    }

    public boolean isDisableSkins() {
        return this.disableSkins;
    }
}

