/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.storage;

import java.io.File;
import java.io.IOException;
import me.jet315.minions.Core;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class DataFile {
    private File file;
    private FileConfiguration config;

    public DataFile(String string, Core core) {
        this.createFile(string, core);
        this.loadYaml(string, core);
    }

    private void createFile(String string, Core core) {
        try {
            if (!core.getDataFolder().exists()) {
                core.getDataFolder().mkdirs();
            }
            this.file = new File(core.getDataFolder(), string);
            if (!this.file.exists()) {
                core.getLogger().info(string + " not found, creating!");
                core.saveResource(string, false);
            } else {
                core.getLogger().info(string + " found, loading!");
            }
        }
        catch (Exception exception) {
            System.out.println(string + " failed to load..");
            exception.printStackTrace();
        }
    }

    private void loadYaml(String string, Core core) {
        this.config = YamlConfiguration.loadConfiguration((File)new File(core.getDataFolder(), string));
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void saveFile() {
        try {
            this.config.save(this.file);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

