/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.minions.types;

import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.events.SlayerSlayEvent;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.utils.FinishAnimation;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.MobXPDropTable;
import me.jet315.minions.utils.MovementUtils;
import me.jet315.minions.utils.Utils;
import me.jet315.minions.utils.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SlayerMinion
extends Minion {
    private int totalMobsKilled = 0;
    private String damager = "null";
    private int damageToGive = 100;
    private Random r = new Random();

    public SlayerMinion(UUID uUID, boolean bl, int n, int n2, int n3, int n4, MinionEntity minionEntity, MinionFace minionFace, ItemStack itemStack, int n5) {
        super(uUID, bl, n, n2, n3, n4, minionEntity, minionFace, itemStack, n5);
    }

    @Override
    public String getIdentifier() {
        return "Slayer";
    }

    @Override
    public String getAuthor() {
        return "Jet315";
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        this.inSpawnAnimation = true;
        MovementUtils.performStartingAnimation(this.getMinion().getArmorStand(), new FinishAnimation(){

            @Override
            public void finished() {
                SlayerMinion.this.inSpawnAnimation = false;
            }
        });
    }

    @Override
    public void onLoad() {
        String[] stringArray;
        super.onLoad();
        this.totalMobsKilled = this.getTotalActionsProcessed();
        if (this.getBase64AdditionalData() != null && (stringArray = this.getBase64AdditionalData().split(":")).length > 1) {
            this.setExp(Integer.valueOf(stringArray[1]));
        }
        this.damager = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getStringValue("SlayerDamager").toLowerCase();
        this.damageToGive = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getIntegerValue("DamageGivenBySlayer");
        if (this.damageToGive == -1) {
            this.damageToGive = 100;
        }
    }

    @Override
    public int getStats() {
        return this.totalMobsKilled;
    }

    @Override
    public ItemStack getItemInMinionsHand() {
        return new ItemStack(Material.DIAMOND_SWORD, 1);
    }

    @Override
    public void performAction() {
        if (this.inSpawnAnimation) {
            return;
        }
        ArrayList<LivingEntity> arrayList = new ArrayList<LivingEntity>();
        final boolean bl = this.getMinion().hasMinionGotAttachedChest();
        final boolean bl2 = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel()).toLowerCase().contains("smelt");
        String[] stringArray = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel()).toLowerCase().split(" ");
        String string = "5x5x5";
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.contains("x") && !string2.toUpperCase().contains("MAX") && !string2.contains(":")) {
                string = string2;
            }
            if (!string2.contains("looting_")) continue;
            n = Integer.valueOf(string2.split("_")[1]);
        }
        final int[] nArray = new int[3];
        String[] stringArray2 = string.split("x");
        nArray[0] = Integer.valueOf(stringArray2[0]);
        nArray[1] = Integer.valueOf(stringArray2[1]);
        nArray[2] = Integer.valueOf(stringArray2[2]);
        block1: for (Entity entity : this.getMinion().getArmorStand().getNearbyEntities((double)nArray[0], (double)nArray[1], (double)nArray[2])) {
            if (entity instanceof LivingEntity) {
                if (entity.isDead() || !entity.isValid() || !Core.getInstance().getHooks().canKillEntity((LivingEntity)entity)) continue;
                arrayList.add((LivingEntity)entity);
                ++this.totalMobsKilled;
                continue;
            }
            if (!(entity instanceof ExperienceOrb)) continue;
            for (Entity entity2 : this.getMinion().getArmorStand().getNearbyEntities((double)nArray[0], (double)nArray[1], (double)nArray[2])) {
                if (!(entity2 instanceof Player)) continue;
                continue block1;
            }
            this.setExp(this.getExp() + ((ExperienceOrb)entity).getExperience());
            entity.remove();
        }
        SlayerSlayEvent slayerSlayEvent = new SlayerSlayEvent((OfflinePlayer)this.getPlayer(), this, arrayList);
        Bukkit.getPluginManager().callEvent(slayerSlayEvent);
        if (slayerSlayEvent.isCancelled()) {
            return;
        }
        arrayList = slayerSlayEvent.getEntitiesToKill();
        if (arrayList.size() > 0) {
            super.performAction();
            for (LivingEntity livingEntity : arrayList) {
                int n2;
                if (livingEntity.isDead() || !livingEntity.isValid()) continue;
                if (livingEntity.getType() == EntityType.BLAZE) {
                    n2 = (int)(Math.random() * 3.0);
                    if (n2 >= 1) {
                        livingEntity.getWorld().dropItemNaturally(livingEntity.getLocation(), new ItemStack(Material.BLAZE_ROD, n2));
                    }
                } else if (livingEntity.getType().toString().equalsIgnoreCase("phantom") && (n2 = (int)(Math.random() * 3.0)) >= 2) {
                    livingEntity.getWorld().dropItemNaturally(livingEntity.getLocation(), XMaterial.PHANTOM_MEMBRANE.parseItem());
                }
                this.setExp(this.getExp() + MobXPDropTable.getEntityXPValue(livingEntity));
                if (livingEntity.getType() != null && livingEntity.getLocation() != null && livingEntity.getHealth() <= (double)this.damageToGive && n > 0 && livingEntity.getType() != EntityType.SLIME && livingEntity.getType() != EntityType.MAGMA_CUBE && this.r.nextInt(7) == 1) {
                    for (n2 = 0; n2 < n; ++n2) {
                        Entity entity = livingEntity.getWorld().spawnEntity(livingEntity.getLocation(), livingEntity.getType());
                        ((LivingEntity)entity).damage(10000.0);
                    }
                }
                livingEntity.damage((double)this.damageToGive, (Entity)(this.damager.equalsIgnoreCase("player") ? (this.getPlayer() == null ? this.getMinion().getArmorStand() : (this.getPlayer().isOnline() ? this.getPlayer() : null)) : (this.damager.equalsIgnoreCase("minion") ? this.getMinion().getArmorStand() : null)));
            }
            if (bl) {
                Bukkit.getScheduler().runTaskLater((Plugin)Core.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        for (Entity entity : SlayerMinion.this.getMinion().getArmorStand().getNearbyEntities((double)nArray[0], (double)nArray[1], (double)nArray[2])) {
                            ItemStack itemStack;
                            if (!(entity instanceof Item) || !entity.isValid() || (itemStack = ((Item)entity).getItemStack().clone()).getType() == Material.AIR || Core.getInstance().getProperties().getDisabledItems().contains(itemStack.getType())) continue;
                            int n = Core.getInstance().getHooks().getItemAmount((Item)entity);
                            if (n > 64) {
                                n = 64;
                                Core.getInstance().getHooks().setItemAmount((Item)entity, 64);
                            } else {
                                entity.remove();
                            }
                            itemStack.setAmount(n);
                            if (itemStack.getType() == Material.AIR) continue;
                            if (bl2) {
                                itemStack.setType(Utils.getSmeltedItemStack(itemStack).getType());
                            }
                            if (!bl) continue;
                            HashMap<Integer, ItemStack> hashMap = SlayerMinion.this.addItemToChest(itemStack);
                            if (!Core.getInstance().getMinionManager().getMinionFile().get(SlayerMinion.this.getIdentifier()).getBooleanValue("DropItemsOnFloorIfChestIsFull", true)) continue;
                            for (ItemStack itemStack2 : hashMap.values()) {
                                SlayerMinion.this.getMinion().getArmorStand().getWorld().dropItemNaturally(SlayerMinion.this.getMinion().getArmorStand().getLocation(), itemStack2);
                            }
                        }
                    }
                }, 5L);
            }
        }
    }

    @Override
    public void setExp(int n) {
        super.setExp(n);
        this.setBase64AdditionalData("EXP:" + this.getExp());
    }

    @Override
    public void onUnload() {
        this.setBase64AdditionalData("EXP:" + this.getExp());
    }

    @Override
    public String getRawBase64() {
        return Base64.getEncoder().encodeToString(("EXP:" + this.getExp()).getBytes());
    }
}

