/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.minions.types;

import java.util.ArrayList;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.utils.FinishAnimation;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.MovementUtils;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;

public class SellerMinion
extends Minion {
    private int totalItemsSold = 0;

    public SellerMinion(UUID uUID, boolean bl, int n, int n2, int n3, int n4, MinionEntity minionEntity, MinionFace minionFace, ItemStack itemStack, int n5) {
        super(uUID, bl, n, n2, n3, n4, minionEntity, minionFace, itemStack, n5);
    }

    @Override
    public String getIdentifier() {
        return "Seller";
    }

    @Override
    public String getAuthor() {
        return "Jet315";
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        this.inSpawnAnimation = true;
        MovementUtils.performStartingAnimation(this.getMinion().getArmorStand(), new FinishAnimation(){

            @Override
            public void finished() {
                SellerMinion.this.inSpawnAnimation = false;
            }
        });
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.totalItemsSold = this.getTotalActionsProcessed();
    }

    @Override
    public int getStats() {
        return this.totalItemsSold;
    }

    @Override
    public ItemStack getItemInMinionsHand() {
        return new ItemStack(Material.CHEST, 1);
    }

    @Override
    public void performAction() {
        if (this.inSpawnAnimation) {
            return;
        }
        boolean bl = this.getMinion().hasMinionGotAttachedChest();
        if (!bl) {
            return;
        }
        float f = 0.0f;
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (ItemStack itemStack : this.getMinion().getAttachedChest().getInventory()) {
            float f2;
            if (itemStack == null || !((f2 = Core.getInstance().getHooks().getSellPriceOfItem(this.getPlayer(), itemStack)) > 0.0f)) continue;
            f += f2;
            arrayList.add(itemStack);
        }
        for (ItemStack itemStack : arrayList) {
            this.getMinion().getAttachedChest().getInventory().remove(itemStack);
        }
        float f3 = Float.valueOf(Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel()).replaceAll("[^\\d.]", "")).floatValue();
        if (f > 0.0f) {
            super.performAction();
            if (Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("RoundSellPriceToWholeNumber", true)) {
                Core.economy.depositPlayer((OfflinePlayer)this.getPlayer(), (double)Math.round(f * f3));
            } else {
                Core.economy.depositPlayer((OfflinePlayer)this.getPlayer(), (double)(f * f3));
            }
            this.totalItemsSold += arrayList.size();
        }
    }
}

