/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.minions.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.events.MinerBlockBreakEvent;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.utils.FinishAnimation;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.MovementUtils;
import me.jet315.minions.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.inventory.ItemStack;

public class MinerMinion
extends Minion {
    private boolean isMinionDisabled = false;
    private int amountOfBlocksToMine = 1;

    public MinerMinion(UUID uUID, boolean bl, int n, int n2, int n3, int n4, MinionEntity minionEntity, MinionFace minionFace, ItemStack itemStack, int n5) {
        super(uUID, bl, n, n2, n3, n4, minionEntity, minionFace, itemStack, n5);
    }

    @Override
    public String getIdentifier() {
        return "Miner";
    }

    @Override
    public String getAuthor() {
        return "Jet315";
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        this.inSpawnAnimation = true;
        Block block = this.getMinion().getArmorStand().getLocation().getBlock();
        Block block2 = block.getRelative(Utils.minionFaceToBlockFace(this.getRotation()));
        if (block2 == null || block2.getType() == Material.AIR || block2.getType() != Material.COBBLESTONE) {
            if (block.getRelative(BlockFace.EAST) != null && block.getRelative(BlockFace.EAST).getType() == Material.COBBLESTONE) {
                this.setRotation(MinionFace.EAST);
            } else if (block.getRelative(BlockFace.SOUTH) != null && block.getRelative(BlockFace.SOUTH).getType() == Material.COBBLESTONE) {
                this.setRotation(MinionFace.SOUTH);
            } else if (block.getRelative(BlockFace.WEST) != null && block.getRelative(BlockFace.WEST).getType() == Material.COBBLESTONE) {
                this.setRotation(MinionFace.WEST);
            } else if (block.getRelative(BlockFace.NORTH) != null && block.getRelative(BlockFace.NORTH).getType() == Material.COBBLESTONE) {
                this.setRotation(MinionFace.NORTH);
            }
        }
        this.workoutBlocksToMine();
        block2 = block.getRelative(Utils.minionFaceToBlockFace(this.getRotation()));
        if (block2 != null && !Core.getInstance().getHooks().canUseBlock(this.getPlayer(), block2)) {
            this.isMinionDisabled = true;
            if (this.getPlayer().isOnline()) {
                this.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionCannotPerformHere());
            }
        }
        MovementUtils.performStartingAnimation(this.getMinion().getArmorStand(), new FinishAnimation(){

            @Override
            public void finished() {
                MinerMinion.this.inSpawnAnimation = false;
            }
        });
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.workoutBlocksToMine();
    }

    @Override
    public ItemStack getItemInMinionsHand() {
        return new ItemStack(Material.DIAMOND_PICKAXE, 1);
    }

    @Override
    public void setRotation(MinionFace minionFace) {
        super.setRotation(minionFace);
        Block block = this.getMinion().getArmorStand().getLocation().getBlock().getRelative(Utils.minionFaceToBlockFace(this.getRotation()));
        if (block != null && !Core.getInstance().getHooks().canUseBlock(this.getPlayer(), block)) {
            this.isMinionDisabled = true;
            if (this.getPlayer().isOnline()) {
                this.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionCannotPerformHere());
            }
        }
    }

    @Override
    public void onLevelUp() {
        super.onLevelUp();
        this.workoutBlocksToMine();
    }

    @Override
    public void performAction() {
        boolean bl;
        if (this.inSpawnAnimation) {
            return;
        }
        BlockFace blockFace = Utils.minionFaceToBlockFace(this.getRotation());
        Block block = this.getMinion().getArmorStand().getLocation().getBlock().getRelative(blockFace);
        boolean bl2 = bl = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel()) != null && Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel()).toLowerCase().contains("smelt");
        if (this.isMinionDisabled) {
            if (Core.getInstance().getHooks().canUseBlock(this.getPlayer(), block)) {
                this.isMinionDisabled = false;
                return;
            }
            return;
        }
        boolean bl3 = false;
        for (int i = 1; i <= this.amountOfBlocksToMine; ++i) {
            if (i != 1) {
                block = block.getRelative(blockFace);
            }
            if (block == null || block.getType() == Material.AIR || !block.getWorld().isChunkLoaded(block.getX() >> 4, block.getZ() >> 4)) continue;
            for (Material material : Core.getInstance().getProperties().getDisabledBlocks()) {
                if (block.getType() != material) continue;
                return;
            }
            if (!bl3) {
                bl3 = true;
                super.performAction();
            }
            Collection<ItemStack> collection = Core.getInstance().getHooks().getDrops(block, new ItemStack(Material.DIAMOND_PICKAXE));
            MinerBlockBreakEvent object2 = new MinerBlockBreakEvent(this, block, collection);
            Bukkit.getPluginManager().callEvent((Event)object2);
            if (object2.isCancelled()) continue;
            EntityInteractEvent entityInteractEvent = new EntityInteractEvent((Entity)this.getMinion().getArmorStand(), block);
            Bukkit.getPluginManager().callEvent((Event)entityInteractEvent);
            if (entityInteractEvent.isCancelled()) continue;
            Core.getInstance().getHooks().mineBlock(block);
            this.addItemsToMiner(object2.getItemsToDrop(), bl);
        }
    }

    private void addItemsToMiner(Collection<ItemStack> collection, boolean bl) {
        for (ItemStack itemStack : collection) {
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            if (bl) {
                itemStack = Utils.getSmeltedItemStack(itemStack);
            }
            if (this.getMinion().hasMinionGotAttachedChest()) {
                HashMap<Integer, ItemStack> hashMap = this.addItemToChest(itemStack);
                if (!Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("DropItemsOnFloorIfChestIsFull", true)) continue;
                for (ItemStack itemStack2 : hashMap.values()) {
                    this.getMinion().getArmorStand().getWorld().dropItemNaturally(this.getMinion().getArmorStand().getLocation(), itemStack2);
                }
                continue;
            }
            if (!Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("DropItemsOnFloorIfChestIsFull", true)) continue;
            super.dropItemsOnFloor(itemStack, this.getMinion().getArmorStand().getLocation());
        }
    }

    private void workoutBlocksToMine() {
        try {
            String string = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel());
            int n = 32;
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i)) && (n == 32 || n == 124 || string.length() <= 2)) {
                    this.amountOfBlocksToMine = string.length() > i + 1 && Character.isDigit(string.charAt(i + 1)) ? Integer.valueOf(String.valueOf(string.charAt(i) + "" + string.charAt(i + 1))).intValue() : Integer.valueOf(String.valueOf(string.charAt(i))).intValue();
                    break;
                }
                n = string.charAt(i);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

