/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.minions.types;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.events.MinionWoodChopEvent;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.reflection.MinecraftVersion;
import me.jet315.minions.reflection.ReflectionUtils;
import me.jet315.minions.utils.FinishAnimation;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.MovementUtils;
import me.jet315.minions.utils.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Wood;

public class LumberjackMinion
extends Minion {
    private int woodChopped;
    private BlockFace[] blockFaces = new BlockFace[]{BlockFace.SELF, BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH};

    public LumberjackMinion(UUID uUID, boolean bl, int n, int n2, int n3, int n4, MinionEntity minionEntity, MinionFace minionFace, ItemStack itemStack, int n5) {
        super(uUID, bl, n, n2, n3, n4, minionEntity, minionFace, itemStack, n5);
    }

    @Override
    public String getIdentifier() {
        return "Lumberjack";
    }

    @Override
    public String getAuthor() {
        return "Jet315";
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        this.inSpawnAnimation = true;
        MovementUtils.performStartingAnimation(this.getMinion().getArmorStand(), new FinishAnimation(){

            @Override
            public void finished() {
                LumberjackMinion.this.inSpawnAnimation = false;
            }
        });
    }

    @Override
    public ItemStack getItemInMinionsHand() {
        return new ItemStack(Material.DIAMOND_AXE, 1);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.woodChopped = this.getTotalActionsProcessed();
    }

    @Override
    public int getStats() {
        return this.woodChopped;
    }

    @Override
    public void performAction() {
        String[] stringArray = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel()).split(" ");
        String string = "5x5x5";
        for (String string2 : stringArray) {
            if (!string2.contains("x")) continue;
            string = string2;
        }
        int[] nArray = new int[3];
        String[] stringArray2 = string.split("x");
        nArray[0] = Integer.valueOf(stringArray2[0]);
        nArray[1] = Integer.valueOf(stringArray2[1]);
        nArray[2] = Integer.valueOf(stringArray2[2]);
        Block block = this.getMinion().getArmorStand().getWorld().getBlockAt(this.getMinion().getArmorStand().getLocation());
        ArrayList<ItemStack> arrayList = this.populateDirtWithSapling(block.getRelative(BlockFace.DOWN), nArray[0], nArray[2]);
        ArrayList<ItemStack> arrayList2 = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("IntelligentWoodChopping", true) ? this.asyncChopWoodWithinRadius(block, nArray[0], nArray[1], nArray[2]) : this.asyncChopWoodWithinRadiusOLD(block, nArray[0], nArray[1], nArray[2]);
        arrayList2.addAll(arrayList);
        MinionWoodChopEvent minionWoodChopEvent = new MinionWoodChopEvent(this, arrayList2);
        Bukkit.getPluginManager().callEvent((Event)minionWoodChopEvent);
        arrayList2 = minionWoodChopEvent.getItems();
        if (arrayList2.size() > 0) {
            super.performAction();
            if (this.getMinion().hasMinionGotAttachedChest()) {
                for (ItemStack itemStack : arrayList2) {
                    HashMap<Integer, ItemStack> hashMap = this.addItemToChest(itemStack);
                    if (!Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("DropItemsOnFloorIfChestIsFull", true)) continue;
                    for (ItemStack itemStack2 : hashMap.values()) {
                        this.getMinion().getArmorStand().getWorld().dropItemNaturally(this.getMinion().getArmorStand().getLocation(), itemStack2);
                    }
                }
            } else {
                for (ItemStack itemStack : arrayList2) {
                    this.getMinion().getArmorStand().getWorld().dropItemNaturally(this.getMinion().getArmorStand().getLocation(), itemStack);
                }
            }
            this.woodChopped += arrayList2.size();
        }
    }

    private ArrayList<ItemStack> asyncChopWoodWithinRadius(Block block, int n, int n2, int n3) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        int n4 = 0;
        int n5 = 0;
        Block block2 = block.getWorld().getBlockAt(block.getX() - n, block.getY() + 1, block.getZ() - n3);
        for (int i = block2.getX(); i <= block2.getX() + n * 2; ++i) {
            for (int j = block2.getZ(); j <= block2.getZ() + n3 * 2; ++j) {
                Block block3 = block.getWorld().getBlockAt(i, block2.getY(), j);
                if (block3.getType() == Material.AIR) continue;
                ArrayList<Block> arrayList2 = new ArrayList<Block>();
                arrayList2.add(block3);
                while (arrayList2.size() > 0) {
                    block3 = (Block)arrayList2.get(0);
                    for (BlockFace blockFace : this.blockFaces) {
                        Block block4 = block3.getRelative(blockFace);
                        if (block4.getType().toString().contains("LEAVES")) {
                            block4.setType(Material.AIR);
                            ++n5;
                            if (blockFace == BlockFace.SELF) continue;
                            arrayList2.add(block4);
                            continue;
                        }
                        if (!block4.getType().toString().contains("LOG") && !block4.getType().toString().contains("MUSHROOM_BLOCK") && !block4.getType().toString().contains("MUSHROOM_STEM")) continue;
                        for (ItemStack itemStack : block4.getDrops()) {
                            if (itemStack.getType() == Material.AIR) continue;
                            arrayList.add(itemStack);
                        }
                        block4.setType(Material.AIR);
                        ++n4;
                        if (blockFace == BlockFace.SELF) continue;
                        arrayList2.add(block4);
                    }
                    arrayList2.remove(0);
                }
            }
        }
        Core.getInstance().getHooks().lumberjackMineBlock(block2.getLocation(), XMaterial.OAK_LOG.parseItem(), n4 <= 0 ? 1 : n4);
        Core.getInstance().getHooks().lumberjackMineBlock(block2.getLocation(), XMaterial.OAK_LEAVES.parseItem(), n5 <= 0 ? 1 : n4);
        return arrayList;
    }

    private ArrayList<ItemStack> asyncChopWoodWithinRadiusOLD(Block block, int n, int n2, int n3) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        int n4 = 0;
        int n5 = 0;
        Block block2 = block.getWorld().getBlockAt(block.getX() - n, block.getY(), block.getZ() - n3);
        Block block3 = block.getWorld().getBlockAt(block.getX() + n, block.getY() + n2, block.getZ() + n3);
        for (int i = block2.getX(); i <= block3.getX(); ++i) {
            for (int j = block2.getY(); j <= block3.getY(); ++j) {
                for (int k = block2.getZ(); k <= block3.getZ(); ++k) {
                    Block block4 = block.getWorld().getBlockAt(i, j, k);
                    if (block4.getType() == Material.AIR) continue;
                    if (block4.getType().toString().contains("LEAVES")) {
                        block4.setType(Material.AIR);
                        ++n5;
                        continue;
                    }
                    if (!block4.getType().toString().contains("LOG") && !block4.getType().toString().contains("MUSHROOM_BLOCK") && !block4.getType().toString().contains("MUSHROOM_STEM")) continue;
                    ++n4;
                    for (ItemStack itemStack : block4.getDrops()) {
                        if (itemStack.getType() == Material.AIR) continue;
                        arrayList.add(itemStack);
                    }
                    block4.setType(Material.AIR);
                }
            }
        }
        Core.getInstance().getHooks().lumberjackMineBlock(block2.getLocation(), XMaterial.OAK_LOG.parseItem(), n4 <= 0 ? 1 : n4);
        Core.getInstance().getHooks().lumberjackMineBlock(block2.getLocation(), XMaterial.OAK_LEAVES.parseItem(), n5 <= 0 ? 1 : n5);
        return arrayList;
    }

    private ArrayList<ItemStack> populateDirtWithSapling(Block block, int n, int n2) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        Block block2 = block.getWorld().getBlockAt(block.getX() - n, block.getY(), block.getZ() - n2);
        Block block3 = block.getWorld().getBlockAt(block.getX() + n, block.getY(), block.getZ() + n2);
        Material material = XMaterial.OAK_SAPLING.parseMaterial();
        for (int i = block2.getX(); i <= block3.getX(); ++i) {
            for (int j = block2.getY(); j <= block3.getY(); ++j) {
                for (int k = block2.getZ(); k <= block3.getZ(); ++k) {
                    Block block4;
                    Block block5 = block.getWorld().getBlockAt(i, j, k);
                    if (block5.getType() != Material.DIRT && block5.getType() != XMaterial.GRASS_BLOCK.parseMaterial() && (!ReflectionUtils.isNewVersion || block5.getType() != XMaterial.PODZOL.parseMaterial() && block5.getType() != XMaterial.GRASS_PATH.parseMaterial() && block5.getType() != XMaterial.MYCELIUM.parseMaterial()) || (block4 = block5.getRelative(BlockFace.UP)).equals(block.getRelative(BlockFace.UP)) || !block4.getType().toString().contains("LOG") && !block4.getType().toString().contains("MUSHROOM_STEM")) continue;
                    for (ItemStack itemStack : block4.getDrops()) {
                        if (itemStack.getType() == Material.AIR) continue;
                        arrayList.add(itemStack);
                    }
                    if (!ReflectionUtils.isNewVersion) {
                        ItemStack itemStack;
                        if (ReflectionUtils.mcVersion == MinecraftVersion.MC1_8) {
                            block4.setType(material);
                            continue;
                        }
                        MaterialData materialData = block4.getState().getData();
                        itemStack = (Wood)materialData;
                        block4.setType(Material.valueOf((String)"SAPLING"));
                        BlockState blockState = block4.getState();
                        try {
                            Method method = null;
                            MaterialData materialData2 = blockState.getData();
                            for (Method method2 : materialData2.getClass().getMethods()) {
                                if (!method2.getName().equalsIgnoreCase("setspecies")) continue;
                                method = method2;
                                break;
                            }
                            method.invoke((Object)materialData2, itemStack.getSpecies());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        blockState.update();
                        continue;
                    }
                    block4.setType(this.getSaplingFromLog113AndAbove(block4.getType(), block4.getLocation()));
                }
            }
        }
        return arrayList;
    }

    private Material getSaplingFromLog113AndAbove(Material material, Location location) {
        switch (material.toString()) {
            case "OAK_LOG": {
                return XMaterial.OAK_SAPLING.parseMaterial();
            }
            case "CHERRY_LOG": {
                return XMaterial.CHERRY_SAPLING.parseMaterial();
            }
            case "SPRUCE_LOG": {
                return XMaterial.SPRUCE_SAPLING.parseMaterial();
            }
            case "BIRCH_LOG": {
                return XMaterial.BIRCH_SAPLING.parseMaterial();
            }
            case "JUNGLE_LOG": {
                return XMaterial.JUNGLE_SAPLING.parseMaterial();
            }
            case "ACACIA_LOG": {
                return XMaterial.ACACIA_SAPLING.parseMaterial();
            }
            case "DARK_OAK_LOG": {
                return XMaterial.DARK_OAK_SAPLING.parseMaterial();
            }
            case "RED_MUSHROOM_BLOCK": {
                return XMaterial.RED_MUSHROOM.parseMaterial();
            }
            case "BROWN_MUSHROOM_BLOCK": {
                return XMaterial.BROWN_MUSHROOM.parseMaterial();
            }
            case "MUSHROOM_STEM": {
                Material material2 = XMaterial.RED_MUSHROOM.parseMaterial();
                for (int i = 1; i < 6; ++i) {
                    Block block = location.getWorld().getBlockAt(new Location(location.getWorld(), (double)location.getBlockX(), (double)(location.getBlockY() + i + 3), (double)location.getBlockZ()));
                    if (block == null || block.getType() == Material.AIR || !block.getType().toString().contains("BROWN")) continue;
                    material2 = XMaterial.BROWN_MUSHROOM.parseMaterial();
                    break;
                }
                return material2;
            }
        }
        return XMaterial.OAK_SAPLING.parseMaterial();
    }
}

