/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.minions.types;

import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.MinionAPI;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.utils.FinishAnimation;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.MovementUtils;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class FeederMinion
extends Minion {
    private int totalHungerFed;

    public FeederMinion(UUID uUID, boolean bl, int n, int n2, int n3, int n4, MinionEntity minionEntity, MinionFace minionFace, ItemStack itemStack, int n5) {
        super(uUID, bl, n, n2, n3, n4, minionEntity, minionFace, itemStack, n5);
    }

    @Override
    public String getIdentifier() {
        return "Feeder";
    }

    @Override
    public String getAuthor() {
        return "Jet315";
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        this.inSpawnAnimation = true;
        MovementUtils.performStartingAnimation(this.getMinion().getArmorStand(), new FinishAnimation(){

            @Override
            public void finished() {
                FeederMinion.this.inSpawnAnimation = false;
            }
        });
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.totalHungerFed = this.getTotalActionsProcessed();
    }

    @Override
    public int getStats() {
        return this.totalHungerFed;
    }

    @Override
    public ItemStack getItemInMinionsHand() {
        return new ItemStack(Material.COOKED_BEEF, 1);
    }

    @Override
    public void performAction() {
        if (this.inSpawnAnimation) {
            return;
        }
        String[] stringArray = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel()).split(" ");
        String string = "5x5x5";
        for (String string2 : stringArray) {
            if (!string2.contains("x")) continue;
            string = string2;
        }
        int[] nArray = new int[3];
        String[] stringArray2 = string.split("x");
        nArray[0] = Integer.valueOf(stringArray2[0]);
        nArray[1] = Integer.valueOf(stringArray2[1]);
        nArray[2] = Integer.valueOf(stringArray2[2]);
        int n = 0;
        for (Entity entity : this.getMinion().getArmorStand().getNearbyEntities((double)nArray[0], (double)nArray[1], (double)nArray[2])) {
            Minion minion;
            if (!MinionAPI.isMinion(entity) || (minion = MinionAPI.getMinion(entity)) == null || minion.getHealth() > minion.getMaxHealth() - 4 || minion.getIdentifier().equalsIgnoreCase("feeder") && !Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("FeedOtherFeederMinions", true)) continue;
            n += minion.getMaxHealth() - minion.getHealth();
            minion.setHealth(minion.getMaxHealth());
        }
        if (n > 0) {
            super.performAction();
            this.totalHungerFed += n;
        }
    }
}

