/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.minions.types;

import java.util.HashMap;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.utils.FinishAnimation;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.MovementUtils;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CollectorMinion
extends Minion {
    private int totalItemsCollected = 0;
    private boolean containerFull = false;

    public CollectorMinion(UUID uUID, boolean bl, int n, int n2, int n3, int n4, MinionEntity minionEntity, MinionFace minionFace, ItemStack itemStack, int n5) {
        super(uUID, bl, n, n2, n3, n4, minionEntity, minionFace, itemStack, n5);
    }

    @Override
    public String getIdentifier() {
        return "Collector";
    }

    @Override
    public String getAuthor() {
        return "Jet315";
    }

    @Override
    public void onFirstSpawn() {
        super.onFirstSpawn();
        this.inSpawnAnimation = true;
        MovementUtils.performStartingAnimation(this.getMinion().getArmorStand(), new FinishAnimation(){

            @Override
            public void finished() {
                CollectorMinion.this.inSpawnAnimation = false;
            }
        });
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.totalItemsCollected = this.getTotalActionsProcessed();
    }

    @Override
    public int getStats() {
        return this.totalItemsCollected;
    }

    @Override
    public ItemStack getItemInMinionsHand() {
        return new ItemStack(Material.ENDER_PEARL, 1);
    }

    @Override
    public void performAction() {
        if (this.inSpawnAnimation) {
            return;
        }
        boolean bl = this.getMinion().hasMinionGotAttachedChest();
        if (this.containerFull && bl) {
            if (this.getMinion().getAttachedChest().getInventory().firstEmpty() > 0) {
                this.containerFull = false;
            } else {
                return;
            }
        }
        if (Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("DisableMinionIfContainerIsFull", false) && !bl) {
            return;
        }
        super.performAction();
        String[] stringArray = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel()).split(" ");
        String string = "5x5x5";
        for (String string2 : stringArray) {
            if (!string2.contains("x")) continue;
            string = string2;
        }
        int[] nArray = new int[3];
        String[] stringArray2 = string.split("x");
        nArray[0] = Integer.valueOf(stringArray2[0]);
        nArray[1] = Integer.valueOf(stringArray2[1]);
        nArray[2] = Integer.valueOf(stringArray2[2]);
        block1: for (String string2 : this.getMinion().getArmorStand().getNearbyEntities((double)nArray[0], (double)nArray[1], (double)nArray[2])) {
            Object object;
            if (string2 instanceof Item) {
                if (!string2.isValid() || string2.hasMetadata("NO_PICKUP") || string2.hasMetadata("no_pickup") || (object = ((Item)string2).getItemStack()).getType() == Material.AIR || Core.getInstance().getProperties().getDisabledItems().contains(object.getType()) || Core.getInstance().getHooks().isDisplayItem((ItemStack)object)) continue;
                int entity = Core.getInstance().getHooks().getItemAmount((Item)string2);
                if (entity > 64) {
                    entity = 64;
                    Core.getInstance().getHooks().setItemAmount((Item)string2, 64);
                } else {
                    string2.remove();
                }
                object.setAmount(entity);
                this.totalItemsCollected += object.getAmount();
                if (object.getType() == Material.AIR) continue;
                if (bl) {
                    HashMap<Integer, ItemStack> hashMap = this.addItemToChest((ItemStack)object);
                    if (Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("DropItemsOnFloorIfChestIsFull", true)) {
                        for (ItemStack itemStack : hashMap.values()) {
                            this.getMinion().getArmorStand().getWorld().dropItemNaturally(this.getMinion().getArmorStand().getLocation(), itemStack);
                        }
                        continue;
                    }
                    if (hashMap.size() <= 0 || !Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("DisableMinionIfContainerIsFull", false)) continue;
                    this.containerFull = true;
                    for (ItemStack itemStack : hashMap.values()) {
                        this.getMinion().getArmorStand().getWorld().dropItemNaturally(this.getMinion().getArmorStand().getLocation(), itemStack);
                    }
                    return;
                }
                if (Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getBooleanValue("DisableMinionIfContainerIsFull", false)) continue;
                this.getMinion().getArmorStand().getWorld().dropItemNaturally(this.getMinion().getArmorStand().getLocation(), (ItemStack)object);
                continue;
            }
            if (!(string2 instanceof ExperienceOrb)) continue;
            object = this.getMinion().getArmorStand().getNearbyEntities((double)nArray[0], (double)nArray[1], (double)nArray[2]).iterator();
            while (object.hasNext()) {
                Entity entity = (Entity)object.next();
                if (!(entity instanceof Player)) continue;
                continue block1;
            }
            this.setExp(this.getExp() + ((ExperienceOrb)string2).getExperience());
            string2.remove();
        }
    }
}

