/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.minions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import me.jet315.minions.Core;
import me.jet315.minions.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MinionFileConfiguration {
    private String minion;
    private File file;
    private FileConfiguration config;
    HashMap<Integer, String> settingsCashe = new HashMap();
    private HashMap<String, Integer> integerCache = new HashMap();
    private HashMap<String, Double> doubleCache = new HashMap();
    private HashMap<String, Boolean> cache = new HashMap();
    private HashMap<String, List<String>> listCache = new HashMap();

    public MinionFileConfiguration(String string) {
        this.minion = string;
        this.cache.clear();
        this.loadFileConfiguration(this.loadFolder());
    }

    public void setMaxUpgradeLevel(int n) {
        if (this.file.length() == 0L || this.file.length() == 0L && n > 1) {
            if (this.file.length() == 0L) {
                this.config.set("MaxLevel", (Object)1);
            } else {
                for (int i = 1; i <= n; ++i) {
                    if (i == 1) {
                        this.config.set("Settings.SettingsAtLevel" + i, null);
                        continue;
                    }
                    this.config.set("Levels.CostToUpgradeToLevel" + i, (Object)100);
                    this.config.set("Settings.SettingsAtLevel" + i, (Object)"CustomMinionSetting");
                    this.config.set("Messages.MessageOnUpgradeTo" + i, (Object)("&aYou have upgraded the minion to level " + i + "!"));
                }
                this.config.set("MaxLevel", (Object)n);
            }
            try {
                this.config.save(this.file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String getStringValue(String string) {
        return this.config.getString(string, "");
    }

    public int getIntegerValue(String string) {
        if (this.integerCache.containsKey(string)) {
            return this.integerCache.get(string);
        }
        int n = this.config.getInt(string, -1);
        this.integerCache.put(string, n);
        return n;
    }

    public double getDoubleValue(String string) {
        if (this.doubleCache.containsKey(string)) {
            return this.doubleCache.get(string);
        }
        double d = this.config.getDouble(string, -1.0);
        this.doubleCache.put(string, d);
        return d;
    }

    public boolean getBooleanValue(String string, boolean bl) {
        if (this.cache.containsKey(string)) {
            return this.cache.get(string);
        }
        this.cache.put(string, this.config.getBoolean(string, bl));
        return this.cache.get(string);
    }

    public List<String> getStringValues(String string) {
        if (this.listCache.containsKey(string)) {
            return this.listCache.get(string);
        }
        List list = this.config.getStringList(string);
        this.listCache.put(string, list);
        return list;
    }

    public int getMaxMinionLevel() {
        return this.config.getInt("MaxLevel");
    }

    public long getCostForNextUpgrade(int n) {
        return this.config.getLong("Levels.CostToUpgradeToLevel" + (n + 1));
    }

    public String getUpgradeMessage(int n) {
        return Utils.translateColorCodes(this.config.getString("Messages.MessageOnUpgradeTo" + n));
    }

    public String getSettingAtLevel(int n) {
        try {
            if (this.settingsCashe.containsKey(n)) {
                return this.settingsCashe.get(n);
            }
            String string = this.config.getString("Settings.SettingsAtLevel" + n);
            if (string == null) {
                throw new NullPointerException();
            }
            this.settingsCashe.put(n, string);
            return string;
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "[JetsMinions] >> Error occurred for minion " + this.minion + " when trying to get level " + n + " from the config");
            return this.config.getString("Settings.SettingsAtLevel" + this.getMaxMinionLevel());
        }
    }

    private void loadFileConfiguration(boolean bl) {
        if (bl) {
            this.file = new File(Core.getInstance().getDataFolder() + "/minionupgrades", this.minion + ".yml");
            if (!this.file.exists()) {
                try {
                    InputStream inputStream = Core.getInstance().getResource("minionupgrades/" + this.minion + ".yml");
                    if (inputStream != null) {
                        Core.getInstance().saveResource("minionupgrades/" + this.minion + ".yml", false);
                    } else {
                        this.file.createNewFile();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
        } else {
            Bukkit.getLogger().log(Level.INFO, "[JetsMinions] >> Error occurred while trying to load MinionSettings folder");
        }
    }

    private boolean loadFolder() {
        File file = new File(Core.getInstance().getDataFolder() + "/minionupgrades");
        if (!file.exists()) {
            return file.mkdir();
        }
        return true;
    }
}

