/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.minions;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.ArmorStand;

public class MinionEntity {
    private ArmorStand armorStand;
    private Location loc;
    private Chest attachedChest;
    private Location chestLocation;

    public MinionEntity(Location location, ArmorStand armorStand) {
        this.armorStand = armorStand;
        this.loc = location;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public void setArmorStand(ArmorStand armorStand) {
        this.armorStand = armorStand;
    }

    public boolean hasMinionGotAttachedChest() {
        return this.chestLocation != null;
    }

    public void setAttachedChest(Chest chest) {
        this.chestLocation = chest == null ? null : chest.getLocation();
        this.attachedChest = chest;
    }

    public Chest getAttachedChest() {
        if (this.chestLocation == null) {
            return null;
        }
        return (Chest)this.attachedChest.getBlock().getState();
    }

    public Location getAttachedChestLocation() {
        if (this.chestLocation == null) {
            return null;
        }
        return this.chestLocation;
    }

    public boolean isChestChunkLoaded() {
        if (this.chestLocation == null) {
            return false;
        }
        if (this.chestLocation.getWorld().isChunkLoaded(this.chestLocation.getBlockX() >> 4, this.chestLocation.getBlockZ() >> 4)) {
            if (this.attachedChest == null) {
                Block block = this.chestLocation.getBlock();
                if (block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST) {
                    this.attachedChest = (Chest)block.getState();
                } else {
                    this.setAttachedChest(null);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Location getLoc() {
        return this.loc;
    }

    public Location getChestLocation() {
        return this.chestLocation;
    }

    public void setChestLocation(Location location) {
        this.chestLocation = location;
    }
}

