/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.minions;

import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import me.jet315.minions.Core;
import me.jet315.minions.MinionAPI;
import me.jet315.minions.minions.IMinion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.reflection.ReflectionUtils;
import me.jet315.minions.skins.MinionSkin;
import me.jet315.minions.utils.FinishAnimation;
import me.jet315.minions.utils.FoodItem;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.MovementUtils;
import me.jet315.minions.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Minion
implements IMinion {
    private UUID playerUUID;
    private int health;
    private int maxHealth;
    private boolean useHealth;
    private int totalActionsProcessed;
    private MinionEntity minionEntity;
    private MinionFace direction;
    private ItemStack minionDisplayItem;
    private int actionsProcessedSinceHealthDrop = 0;
    private int actionsAllowedPerHeathDrop;
    private int level;
    private String originalName;
    private String base64AdditionalData;
    protected boolean inSpawnAnimation = false;
    protected boolean getIntoStarterPosition = false;
    private short animationStatus = 0;
    private int expCollected = 0;
    private int c = 0;
    protected boolean isMinionLoaded = false;
    private Player player = null;

    protected Minion(UUID uUID, boolean bl, int n, int n2, int n3, int n4, MinionEntity minionEntity, MinionFace minionFace, ItemStack itemStack, int n5) {
        this.playerUUID = uUID;
        this.health = n2;
        this.maxHealth = n3;
        this.useHealth = bl;
        this.totalActionsProcessed = n4;
        this.minionEntity = minionEntity;
        this.direction = minionFace;
        this.minionDisplayItem = itemStack;
        this.actionsAllowedPerHeathDrop = n;
        this.level = n5;
    }

    @Override
    public void setMinionSkin(MinionSkin minionSkin) {
        if (minionSkin == null) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)this.playerUUID);
        if (player == null) {
            player = Bukkit.getOfflinePlayer((UUID)this.playerUUID);
        }
        if (minionSkin.isUsePlayersHead()) {
            this.getMinion().getArmorStand().setHelmet(Utils.generateHead((OfflinePlayer)player));
        } else {
            this.getMinion().getArmorStand().setHelmet(minionSkin.getHeadSlot());
        }
        this.getMinion().getArmorStand().setChestplate(minionSkin.getBodySlot());
        this.getMinion().getArmorStand().setLeggings(minionSkin.getLegsSlot());
        this.getMinion().getArmorStand().setBoots(minionSkin.getBootsSlot());
        if (minionSkin.getHandItem() != null) {
            this.getMinion().getArmorStand().setItemInHand(minionSkin.getHandItem());
        }
    }

    @Override
    public void setMinionName(String string) {
        Player player;
        this.originalName = string;
        if (!this.getMinion().getArmorStand().isCustomNameVisible()) {
            this.getMinion().getArmorStand().setCustomNameVisible(true);
        }
        if ((player = Bukkit.getPlayer((UUID)this.playerUUID)) == null) {
            player = Bukkit.getOfflinePlayer((UUID)this.playerUUID);
        }
        this.getMinion().getArmorStand().setCustomName(string.replaceAll("%PLAYERNAME%", player.getName()).replaceAll("%STATS%", String.valueOf(this.totalActionsProcessed)).replaceAll("%LEVEL%", String.valueOf(this.level)));
    }

    @Override
    public int getStats() {
        return this.totalActionsProcessed;
    }

    @Override
    public int getExp() {
        return this.expCollected;
    }

    @Override
    public void setExp(int n) {
        this.expCollected = n;
    }

    @Override
    public boolean canPerformAction() {
        if (this.isMinionLoaded && this.getMinion().getArmorStand() == null) {
            ++this.c;
            if (this.c < 60) {
                return false;
            }
            Bukkit.getLogger().log(Level.INFO, "Minions >> Minion (" + this.getIdentifier() + ") located at " + this.minionEntity.getLoc().getX() + "," + this.minionEntity.getLoc().getY() + "," + this.minionEntity.getLoc().getZ() + ", world: " + this.minionEntity.getLoc().getWorld().getName() + " -  has been removed due to the armour_stand being deleted. This minion belonged to: " + this.getPlayerUUID());
            final Minion minion = this;
            Bukkit.getScheduler().runTaskLater((Plugin)Core.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Core.getInstance().getDataController().getStorage().removeMinionFromDatabase(Minion.this.playerUUID, minion);
                    Core.getInstance().getMinionManager().removeMinionFromList(minion);
                }
            }, 2L);
            return false;
        }
        if (!this.useHealth) {
            return true;
        }
        return this.health > 0;
    }

    @Override
    public void performAction() {
        ++this.totalActionsProcessed;
        if (!this.useHealth) {
            return;
        }
        ++this.actionsProcessedSinceHealthDrop;
        if (this.actionsProcessedSinceHealthDrop >= this.actionsAllowedPerHeathDrop) {
            --this.health;
            this.actionsProcessedSinceHealthDrop = 0;
            if (this.health == 0 && !Core.getInstance().getMessages().getMinionRanOutOfHealth().equalsIgnoreCase("none") && this.getPlayer() != null && this.getPlayer().isOnline()) {
                this.getPlayer().sendMessage(Core.getInstance().getMessages().getMinionRanOutOfHealth().replaceAll("%MINION_TYPE%", this.getIdentifier()).replaceAll("%MINION_DISPLAY_NAME%", this.getOriginalName()));
            }
        }
        if (this.health < this.maxHealth && (Core.getInstance().getProperties().isFeedMinionFromChest() || Core.getInstance().getProperties().getMinionsToFeedFromChest().contains(this.getIdentifier().toUpperCase())) && this.getMinion().getAttachedChest() != null) {
            block0: for (ItemStack itemStack : this.getMinion().getAttachedChest().getInventory().getContents()) {
                if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                for (FoodItem foodItem : Core.getInstance().getProperties().getFoodItems()) {
                    if (foodItem.getItemStack().getType() != itemStack.getType()) continue;
                    if (!ReflectionUtils.isNewVersion && foodItem.getItemStack().getDurability() != itemStack.getData().getData()) continue block0;
                    if (this.health != 0 && this.health + foodItem.getHealAmount() > this.maxHealth) continue;
                    this.setHealth(this.getHealth() + foodItem.getHealAmount());
                    if (this.getHealth() > this.maxHealth) {
                        this.setHealth(this.maxHealth);
                    }
                    itemStack.setAmount(itemStack.getAmount() - 1);
                    if (itemStack.getAmount() == 0) {
                        itemStack.setType(Material.AIR);
                    }
                    return;
                }
            }
        }
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public void setHealth(int n) {
        this.health = n;
    }

    @Override
    public ItemStack getItemInMinionsHand() {
        return this.getMinion().getArmorStand().getItemInHand();
    }

    @Override
    public int getActionsProcessedSinceHealthDrop() {
        return this.actionsProcessedSinceHealthDrop;
    }

    @Override
    public void setActionsProcessedSinceHealthDrop(int n) {
        this.actionsProcessedSinceHealthDrop = n;
    }

    @Override
    public int getTotalActionsProcessed() {
        return this.totalActionsProcessed;
    }

    @Override
    public void setTotalActionsProcessed(int n) {
        this.totalActionsProcessed = n;
    }

    @Override
    public void setRotation(MinionFace minionFace) {
        if (this.direction == minionFace) {
            return;
        }
        this.direction = minionFace;
        Core.getInstance().getDataController().getStorage().removeMinionUUIDFromDatabase(this.getMinion().getArmorStand().getUniqueId());
        ArmorStand armorStand = this.minionEntity.getArmorStand();
        ArmorStand armorStand2 = (ArmorStand)armorStand.getWorld().spawnEntity(new Location(armorStand.getWorld(), armorStand.getLocation().getX(), armorStand.getLocation().getY(), armorStand.getLocation().getZ(), Utils.minionFaceToYaw(minionFace), armorStand.getLocation().getPitch()), EntityType.ARMOR_STAND);
        armorStand2.setSmall(true);
        armorStand2.setArms(true);
        armorStand2.setGravity(false);
        armorStand2.setBasePlate(false);
        armorStand2.setCustomNameVisible(true);
        armorStand2.setCustomName(armorStand.getCustomName());
        armorStand2.setHelmet(armorStand.getHelmet());
        armorStand2.setChestplate(armorStand.getChestplate());
        armorStand2.setLeggings(armorStand.getLeggings());
        armorStand2.setBoots(armorStand.getBoots());
        armorStand2.setItemInHand(armorStand.getItemInHand());
        armorStand.remove();
        this.getMinion().setArmorStand(armorStand2);
        Core.getInstance().getDataController().getStorage().addMinionUUIDToDatabase(this);
    }

    @Override
    public MinionFace getRotation() {
        return this.direction;
    }

    @Override
    public MinionEntity getMinion() {
        return this.minionEntity;
    }

    @Override
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getOriginalName() {
        if (this.originalName != null) {
            return this.originalName;
        }
        return this.getMinion().getArmorStand().getCustomName();
    }

    public boolean isUseHealth() {
        return this.useHealth;
    }

    public int getActionsAllowedPerHeathDrop() {
        return this.actionsAllowedPerHeathDrop;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int n) {
        this.level = n;
    }

    @Override
    public void onLevelUp() {
        int n;
        String string;
        if (this.originalName != null) {
            this.setMinionName(this.originalName);
        }
        if ((string = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel())).toLowerCase().contains("handitem")) {
            n = string.indexOf("HANDITEM");
            int n2 = string.indexOf(" ", n);
            if (n2 == -1) {
                n2 = string.length();
            }
            Material material = Material.valueOf((String)string.substring(n, n2).split(":")[1]);
            this.minionEntity.getArmorStand().setItemInHand(new ItemStack(material));
        }
        if (string.toLowerCase().contains("enchanted")) {
            ItemStack itemStack = this.minionEntity.getArmorStand().getItemInHand().clone();
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.addEnchant(Enchantment.DIG_SPEED, 1, true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemStack.setItemMeta(itemMeta);
            this.minionEntity.getArmorStand().setItemInHand(itemStack);
        }
        if (string.toLowerCase().contains("fortune")) {
            n = string.indexOf("FORTUNE");
            int n3 = string.indexOf(" ", n);
            if (n3 == -1) {
                n3 = string.length();
            }
            int n4 = 1;
            try {
                n4 = Integer.valueOf(string.substring(n, n3).split(":")[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n4 > 0) {
                ItemStack itemStack = this.minionEntity.getArmorStand().getItemInHand().clone();
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.addEnchant(Enchantment.LOOT_BONUS_BLOCKS, n4, true);
                itemStack.setItemMeta(itemMeta);
                this.minionEntity.getArmorStand().setItemInHand(itemStack);
            }
        }
        if (string.contains("MAXHEALTH")) {
            int n5;
            n = string.indexOf("MAXHEALTH");
            int n6 = string.indexOf(" ", n);
            if (n6 == -1) {
                n6 = string.length();
            }
            this.maxHealth = n5 = Integer.valueOf(string.substring(n, n6).split(":")[1]).intValue();
        }
    }

    @Override
    public void onLoad() {
        this.direction = Utils.getDirection(this.getMinion().getArmorStand() == null ? 0.0 : (double)this.getMinion().getArmorStand().getLocation().getYaw());
        if (this.minionEntity.isChestChunkLoaded()) {
            // empty if block
        }
    }

    @Override
    public void performAnimation() {
        if (this.inSpawnAnimation) {
            return;
        }
        if (!this.isMinionLoaded) {
            return;
        }
        if (!this.canPerformAction()) {
            return;
        }
        if (!this.getIntoStarterPosition) {
            this.getToStartingPosition(new FinishAnimation(){

                @Override
                public void finished() {
                    Minion.this.getIntoStarterPosition = true;
                }
            });
            return;
        }
        if (this.animationStatus == 25) {
            this.animationStatus = (short)-1;
        }
        this.animationStatus = (short)(this.animationStatus + 1);
        this.getMinion().getArmorStand().setRightArmPose(MovementUtils.rightHandPickaxeMovement[this.animationStatus]);
    }

    private void getToStartingPosition(final FinishAnimation finishAnimation) {
        final int n = MovementUtils.moveRightHandUpSlightly.length;
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (this.counter >= n) {
                    this.cancel();
                    finishAnimation.finished();
                    return;
                }
                Minion.this.getMinion().getArmorStand().setRightArmPose(MovementUtils.moveRightHandUpSlightly[this.counter]);
                ++this.counter;
            }
        }.runTaskTimer((Plugin)Core.getInstance(), 0L, 1L);
    }

    @Override
    public void onFirstSpawn() {
        int n;
        String string = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel());
        if (string == null) {
            for (int i = 0; i < 3; ++i) {
                Bukkit.getLogger().log(Level.INFO, "JetsMinions >> Error getting settins for minion " + this.getIdentifier() + " Invalid level " + this.getLevel() + ".. Please check the " + this.getIdentifier() + ".yml file for any errors");
            }
            return;
        }
        String string2 = Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getSettingAtLevel(this.getLevel());
        if (string2.toLowerCase().contains("handitem")) {
            n = string2.indexOf("HANDITEM");
            int n2 = string2.indexOf(" ", n);
            if (n2 == -1) {
                n2 = string2.length();
            }
            Material material = Material.valueOf((String)string2.substring(n, n2).split(":")[1]);
            this.minionEntity.getArmorStand().setItemInHand(new ItemStack(material));
        }
        if (string2.toLowerCase().contains("enchanted")) {
            ItemStack itemStack = this.minionEntity.getArmorStand().getItemInHand().clone();
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.addEnchant(Enchantment.SILK_TOUCH, 1, true);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            itemStack.setItemMeta(itemMeta);
            this.minionEntity.getArmorStand().setItemInHand(itemStack);
        }
        if (string2.toUpperCase().contains("fortune")) {
            int n3;
            n = string2.indexOf("FORTUNE");
            int n4 = string2.indexOf(" ", n);
            if (n4 == -1) {
                n4 = string2.length();
            }
            if ((n3 = Integer.valueOf(string2.substring(n, n4).split(":")[1]).intValue()) > 0) {
                ItemStack itemStack = this.minionEntity.getArmorStand().getItemInHand().clone();
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.addEnchant(Enchantment.LOOT_BONUS_BLOCKS, n3, true);
                itemStack.setItemMeta(itemMeta);
                this.minionEntity.getArmorStand().setItemInHand(itemStack);
            }
        }
        if (string2.contains("MAXHEALTH")) {
            int n5;
            n = string2.indexOf("MAXHEALTH");
            int n6 = string2.indexOf(" ", n);
            if (n6 == -1) {
                n6 = string2.length();
            }
            this.maxHealth = n5 = Integer.valueOf(string2.substring(n, n6).split(":")[1]).intValue();
        }
    }

    @Override
    public void onPickUp() {
    }

    @Override
    public String getBase64AdditionalData() {
        if (this.base64AdditionalData == null) {
            return null;
        }
        try {
            return new String(Base64.getDecoder().decode(this.base64AdditionalData));
        }
        catch (Exception exception) {
            return this.base64AdditionalData;
        }
    }

    @Override
    public void setBase64AdditionalData(String string) {
        this.base64AdditionalData = Base64.getEncoder().encodeToString(string.getBytes());
    }

    @Override
    public void setRawBase64(String string) {
        this.base64AdditionalData = string;
    }

    @Override
    public String getRawBase64() {
        return this.base64AdditionalData;
    }

    @Override
    public void onUnload() {
    }

    @Override
    public HashMap<Integer, ItemStack> addItemToChest(ItemStack itemStack) {
        if (this.getMinion().hasMinionGotAttachedChest() && this.getMinion().isChestChunkLoaded()) {
            if (Core.getInstance().getHooks().isChestHookEnabled()) {
                boolean bl = Core.getInstance().getHooks().addItemsToChestHook(this.getPlayer(), itemStack, this.getMinion().getAttachedChest());
                if (!bl) {
                    HashMap<Integer, ItemStack> hashMap = new HashMap<Integer, ItemStack>();
                    hashMap.put(0, itemStack);
                    return hashMap;
                }
                return new HashMap<Integer, ItemStack>();
            }
            return this.getMinion().getAttachedChest().getInventory().addItem(new ItemStack[]{itemStack});
        }
        HashMap<Integer, ItemStack> hashMap = new HashMap<Integer, ItemStack>();
        hashMap.put(0, itemStack);
        return hashMap;
    }

    public void dropItemsOnFloor(ItemStack itemStack, Location location) {
        if (Core.getInstance().getHooks().isDropsHookEnabled() && this.getPlayer() != null && this.getPlayer().isOnline()) {
            Core.getInstance().getHooks().addItemsToPlayerInventory(this.getPlayer(), itemStack, location);
        } else {
            this.getMinion().getArmorStand().getWorld().dropItemNaturally(location, itemStack);
        }
    }

    @Override
    public boolean isMinionLoaded() {
        World world = Bukkit.getWorld((String)this.minionEntity.getLoc().getWorld().getName());
        if (world == null) {
            this.isMinionLoaded = false;
            return false;
        }
        if (world.isChunkLoaded(this.minionEntity.getLoc().getBlockX() >> 4, this.minionEntity.getLoc().getBlockZ() >> 4)) {
            if (this.minionEntity.getArmorStand() == null || !this.isMinionLoaded || !this.minionEntity.getArmorStand().isValid()) {
                for (Entity entity : world.getNearbyEntities(new Location(world, this.minionEntity.getLoc().getX(), this.minionEntity.getLoc().getY(), this.minionEntity.getLoc().getZ()), 0.1, 0.01, 0.1)) {
                    if (!MinionAPI.isMinion(entity)) continue;
                    this.minionEntity.setArmorStand((ArmorStand)entity);
                    break;
                }
            }
            this.minionEntity.isChestChunkLoaded();
            Player player = this.getPlayer();
            if (player != null && (player.isOnline() || Core.getInstance().getProperties().isMinionFunctionOffline())) {
                if (!this.isMinionLoaded) {
                    this.isMinionLoaded = true;
                    this.onLoad();
                    return true;
                }
                return true;
            }
            this.isMinionLoaded = false;
            this.onUnload();
            return false;
        }
        this.isMinionLoaded = false;
        return false;
    }

    protected Player getPlayer() {
        if (this.player != null) {
            return this.player;
        }
        this.player = Bukkit.getPlayer((UUID)this.playerUUID);
        return this.player;
    }

    @Override
    public int getMaxLevel() {
        if (Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()) == null) {
            return -1;
        }
        return Core.getInstance().getMinionManager().getMinionFile().get(this.getIdentifier()).getMaxMinionLevel();
    }
}

