/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.manager;

import java.util.ArrayList;
import java.util.Random;
import me.jet315.minions.Core;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.storage.MinionProperties;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class MinionTask {
    public MinionTask() {
        this.startTaskAction();
        this.startTaskAnimation();
        this.periodicSaveTask();
    }

    private void startTaskAction() {
        for (final MinionProperties minionProperties : Core.getInstance().getMinionManager().getMinionProperties().values()) {
            Bukkit.getScheduler().runTaskTimer((Plugin)Core.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (Core.getInstance().getMinionManager().getMinionsForType(minionProperties.getIdentifier()) == null) {
                        return;
                    }
                    ArrayList arrayList = (ArrayList)Core.getInstance().getMinionManager().getMinionsForType(minionProperties.getIdentifier()).clone();
                    if (arrayList == null) {
                        return;
                    }
                    for (Minion minion : arrayList) {
                        if (!minion.isMinionLoaded() || !minion.canPerformAction()) continue;
                        minion.performAction();
                    }
                }
            }, (long)(75 + new Random().nextInt(60)), (long)minionProperties.getDelayInAction());
        }
    }

    private void startTaskAnimation() {
        for (final MinionProperties minionProperties : Core.getInstance().getMinionManager().getMinionProperties().values()) {
            if (minionProperties.getDelayInAnimation() <= 0) continue;
            Bukkit.getScheduler().runTaskTimer((Plugin)Core.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (Core.getInstance().getMinionManager().getMinionsForType(minionProperties.getIdentifier()) == null) {
                        return;
                    }
                    ArrayList arrayList = (ArrayList)Core.getInstance().getMinionManager().getMinionsForType(minionProperties.getIdentifier()).clone();
                    if (arrayList == null) {
                        return;
                    }
                    for (Minion minion : arrayList) {
                        minion.performAnimation();
                    }
                }
            }, 100L, (long)minionProperties.getDelayInAnimation());
        }
    }

    private void periodicSaveTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)Core.getInstance(), new Runnable(){

            @Override
            public void run() {
                Core.getInstance().getDataController().getStorage().saveDatabase();
            }
        }, (long)(Core.getInstance().getProperties().getDatabaseSaveTime() * 20 * 60), (long)(Core.getInstance().getProperties().getDatabaseSaveTime() * 20 * 60));
    }
}

