/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.manager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import me.jet315.minions.manager.MinionPlayer;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.minions.MinionFileConfiguration;
import me.jet315.minions.storage.MinionProperties;
import me.jet315.minions.utils.MinionFace;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MinionManager {
    private HashMap<String, Class<? extends Minion>> validMinions = new HashMap();
    private HashMap<String, MinionProperties> minionProperties = new HashMap();
    private HashMap<String, MinionFileConfiguration> minionFile = new HashMap();
    private ConcurrentHashMap<String, ArrayList<Minion>> allMinions = new ConcurrentHashMap();
    private HashMap<Player, Minion> minionsToRename = new HashMap();
    private HashMap<Player, Minion> minionsToChest = new HashMap();
    private ArrayList<MinionPlayer> minionPlayers = new ArrayList();

    public boolean registerMinion(Class<? extends Minion> clazz) {
        try {
            Minion minion = clazz.getDeclaredConstructor(UUID.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, MinionEntity.class, MinionFace.class, ItemStack.class, Integer.TYPE).newInstance(null, true, 1, 1, 20, 1, null, null, null, 0);
            Method method = clazz.getMethod("getIdentifier", new Class[0]);
            String string = (String)method.invoke((Object)minion, new Object[0]);
            Method method2 = clazz.getMethod("getAuthor", new Class[0]);
            String string2 = (String)method2.invoke((Object)minion, new Object[0]);
            MinionFileConfiguration minionFileConfiguration = new MinionFileConfiguration(string);
            int n = minionFileConfiguration.getMaxMinionLevel();
            minionFileConfiguration.setMaxUpgradeLevel(n);
            this.minionFile.put(string, minionFileConfiguration);
            if (string == null || this.validMinions.containsKey(string)) {
                System.out.println("FAILED TO LOAD A CUSTOM MINION " + string + " (Identifier is null / already exists)");
                return false;
            }
            if (string2 == null) {
                Bukkit.getLogger().log(Level.INFO, "FAILED TO LOAD A CUSTOM MINION: Author for " + string + " does not exist");
                return false;
            }
            if (!this.minionProperties.containsKey(string)) {
                Bukkit.getLogger().log(Level.INFO, "Could not load minion: " + string + " due to a properties error. (Does not exist in the config.yml)");
                return false;
            }
            Bukkit.getLogger().log(Level.INFO, "[JetsMinions] Loaded Minion: " + string + " Made by " + string2);
            this.validMinions.put(string, clazz);
            this.allMinions.put(string, new ArrayList());
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Bukkit.getLogger().log(Level.INFO, "FAILED TO LOAD A CUSTOM MINION - StackTrace:");
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            Bukkit.getLogger().log(Level.INFO, "FAILED TO LOAD A CUSTOM MINION - StackTrace:");
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            Bukkit.getLogger().log(Level.INFO, "FAILED TO LOAD A CUSTOM MINION - StackTrace:");
            invocationTargetException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            Bukkit.getLogger().log(Level.INFO, "FAILED TO LOAD A CUSTOM MINION - StackTrace:");
            instantiationException.printStackTrace();
        }
        return false;
    }

    public HashMap<String, Class<? extends Minion>> getValidMinions() {
        return this.validMinions;
    }

    public ArrayList<? extends Minion> getAllMinions() {
        ArrayList<Minion> arrayList = new ArrayList<Minion>();
        for (String string : this.allMinions.keySet()) {
            for (Minion minion : this.allMinions.get(string)) {
                arrayList.add(minion);
            }
        }
        return arrayList;
    }

    public ArrayList<? extends Minion> getMinionsForType(String string) {
        return this.allMinions.get(string);
    }

    public void addMinion(Minion minion) {
        this.allMinions.get(minion.getIdentifier()).add(minion);
    }

    public void removeMinionFromList(Minion minion) {
        if (minion == null) {
            return;
        }
        this.allMinions.get(minion.getIdentifier()).remove(minion);
    }

    public Minion getMinionByLocation(Location location) {
        for (String string : this.allMinions.keySet()) {
            for (Minion minion : this.allMinions.get(string)) {
                if (minion.getMinion().getLoc() == null || !minion.getMinion().getLoc().getWorld().getName().equalsIgnoreCase(location.getWorld().getName()) || minion.getMinion().getLoc().getBlockX() != location.getBlockX() || minion.getMinion().getLoc().getBlockY() != location.getBlockY() || minion.getMinion().getLoc().getBlockZ() != location.getBlockZ()) continue;
                return minion;
            }
        }
        return null;
    }

    public HashMap<String, MinionProperties> getMinionProperties() {
        return this.minionProperties;
    }

    public MinionProperties getMinionProperties(String string) {
        for (String string2 : this.minionProperties.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return this.minionProperties.get(string2);
        }
        return null;
    }

    public HashMap<Player, Minion> getMinionsToRename() {
        return this.minionsToRename;
    }

    public ArrayList<MinionPlayer> getMinionPlayers() {
        return this.minionPlayers;
    }

    public MinionPlayer getMinionPlayer(UUID uUID) {
        for (MinionPlayer minionPlayer : this.minionPlayers) {
            if (!minionPlayer.equals(minionPlayer.getPlayerUUID())) continue;
            return minionPlayer;
        }
        MinionPlayer minionPlayer = new MinionPlayer(uUID);
        return minionPlayer;
    }

    public void removeMinionPlayer(MinionPlayer minionPlayer) {
        this.minionPlayers.remove(minionPlayer);
    }

    public HashMap<Player, Minion> getMinionsToChest() {
        return this.minionsToChest;
    }

    public HashMap<String, MinionFileConfiguration> getMinionFile() {
        return this.minionFile;
    }
}

