/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.listeners;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.MinionAPI;
import me.jet315.minions.events.PostMinionPlaceEvent;
import me.jet315.minions.events.PreMinionPlaceEvent;
import me.jet315.minions.manager.MinionPlayer;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.minions.MinionEntity;
import me.jet315.minions.reflection.ReflectionUtils;
import me.jet315.minions.skins.MinionSkin;
import me.jet315.minions.storage.MinionProperties;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.NBTUtils;
import me.jet315.minions.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MinionPlaceListener
implements Listener {
    private ArrayList<Player> players = new ArrayList();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMinionPlace(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = playerInteractEvent.getPlayer();
            ItemStack itemStack = ReflectionUtils.isNewVersion ? playerInteractEvent.getItem() : player.getInventory().getItemInHand();
            Block block = playerInteractEvent.getClickedBlock();
            if (block != null && itemStack != null && itemStack.getType() != Material.AIR) {
                for (MinionProperties minionProperties : Core.getInstance().getMinionManager().getMinionProperties().values()) {
                    int n;
                    Object object2;
                    int n2;
                    if (!minionProperties.isItemStack(itemStack)) continue;
                    playerInteractEvent.setCancelled(true);
                    if (this.players.contains(player)) {
                        return;
                    }
                    this.players.add(player);
                    this.removePlayer(player);
                    Block block2 = block.getRelative(BlockFace.UP);
                    if (block2.getType() != Material.AIR) {
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getCannotPlaceMinionHere());
                        return;
                    }
                    for (Entity object2 : block2.getChunk().getEntities()) {
                        ArmorStand armorStand;
                        if (!(object2 instanceof ArmorStand) || !MinionAPI.isMinion((Entity)(armorStand = (ArmorStand)object2)) || !armorStand.getLocation().getBlock().equals(block2)) continue;
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getCannotPlaceMinionHere());
                        return;
                    }
                    if (!Core.getInstance().getHooks().canUseBlock(playerInteractEvent.getPlayer(), block) && !player.isOp()) {
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getCannotPlaceMinionHere());
                        return;
                    }
                    for (String string : Core.getInstance().getProperties().getDisabledWorlds()) {
                        if (!string.equalsIgnoreCase(block.getLocation().getWorld().getName())) continue;
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getCannotPlaceMinionHere());
                        return;
                    }
                    MinionPlayer minionPlayer = Core.getInstance().getMinionManager().getMinionPlayer(player.getUniqueId());
                    if (!player.hasPermission("minions.admin.bypasslimit") || !player.hasPermission("minions.admin.*")) {
                        n2 = MinionAPI.getMaximumAllowedMinions(player, minionProperties.getIdentifier());
                        if (!MinionAPI.isPlayerAllowedToPlaceMinion(minionPlayer, minionProperties.getIdentifier())) {
                            player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMaxMinionAmount().replaceAll("%MAXAMOUNTALLOWED%", String.valueOf(n2)));
                            return;
                        }
                    }
                    if (Core.getInstance().getProperties().getMaxMinionsInAChunk() > 0) {
                        n2 = Core.getInstance().getProperties().getMaxMinionsInAChunk();
                        int n3 = 0;
                        for (Object object2 : block.getChunk().getEntities()) {
                            if (!MinionAPI.isMinion(object2)) continue;
                            ++n3;
                        }
                        if (n3 >= n2) {
                            player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getChunkMinionPlaceLimit().replaceAll("%CHUNKLIMIT%", String.valueOf(n2)));
                            return;
                        }
                    }
                    Location location = new Location(block2.getWorld(), (double)block2.getX() + 0.5, (double)block2.getY(), (double)block2.getZ() + 0.5, Utils.minionFaceToYaw(Utils.getDirection(player.getLocation().getYaw())), 0.0f);
                    for (Minion minion : Core.getInstance().getMinionManager().getAllMinions()) {
                        if (!minion.getMinion().getLoc().equals((Object)location)) continue;
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getCannotPlaceMinionHere());
                        return;
                    }
                    PreMinionPlaceEvent preMinionPlaceEvent = new PreMinionPlaceEvent(player, minionProperties.getIdentifier(), location);
                    Core.getInstance().getServer().getPluginManager().callEvent(preMinionPlaceEvent);
                    if (preMinionPlaceEvent.isCancelled()) {
                        return;
                    }
                    int n3 = Integer.valueOf(NBTUtils.getNBTValue(itemStack, "stats"));
                    int n4 = Integer.valueOf(NBTUtils.getNBTValue(itemStack, "level"));
                    try {
                        n = Integer.valueOf(NBTUtils.getNBTValue(itemStack, "health"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 20;
                    }
                    object2 = NBTUtils.getNBTValue(itemStack, "oldName");
                    if (itemStack.getAmount() > 1) {
                        itemStack.setAmount(itemStack.getAmount() - 1);
                    } else if (ReflectionUtils.isNewVersion) {
                        if (player.getInventory().getItemInMainHand().equals((Object)itemStack)) {
                            player.getInventory().setItemInMainHand(null);
                        } else {
                            player.getInventory().setItemInOffHand(null);
                        }
                    } else {
                        player.getInventory().setItemInHand(null);
                    }
                    ArmorStand armorStand = (ArmorStand)playerInteractEvent.getPlayer().getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
                    armorStand.setMetadata("Minion", (MetadataValue)new FixedMetadataValue((Plugin)Core.getInstance(), (Object)minionProperties.getIdentifier()));
                    armorStand.setSmall(true);
                    armorStand.setArms(true);
                    armorStand.setGravity(false);
                    armorStand.setBasePlate(false);
                    Class<? extends Minion> clazz = Core.getInstance().getMinionManager().getValidMinions().get(minionProperties.getIdentifier());
                    Minion minion = null;
                    try {
                        minion = clazz.getDeclaredConstructor(UUID.class, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, MinionEntity.class, MinionFace.class, ItemStack.class, Integer.TYPE).newInstance(new Object[]{player.getUniqueId(), minionProperties.isHealthEnabled(), minionProperties.getActionsPerHealth(), n, minionProperties.getMaxHealth(), n3, new MinionEntity(armorStand.getLocation(), armorStand), Utils.getDirection(armorStand.getLocation().getYaw()), minionProperties.getDisplayItem(), n4});
                    }
                    catch (InstantiationException minionSkin) {
                        minionSkin.printStackTrace();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                    }
                    if (minion == null) {
                        playerInteractEvent.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getErrorMessages());
                        return;
                    }
                    MinionSkin minionSkin = minionProperties.getDefaultMinionSkin();
                    minion.setMinionName((String)object2);
                    minion.setMinionSkin(minionSkin);
                    ItemStack itemStack2 = minionSkin.getHandItem() == null ? minion.getItemInMinionsHand() : minionSkin.getHandItem();
                    armorStand.setItemInHand(itemStack2);
                    minion.onFirstSpawn();
                    minion.onLoad();
                    Core.getInstance().getDataController().getStorage().addMinionUUIDToDatabase(minion);
                    Core.getInstance().getMinionManager().addMinion(minion);
                    minionPlayer.getPlayersMinions().add(minion);
                    PostMinionPlaceEvent postMinionPlaceEvent = new PostMinionPlaceEvent(player, minion);
                    Core.getInstance().getServer().getPluginManager().callEvent((Event)postMinionPlaceEvent);
                    return;
                }
            }
        }
    }

    private void removePlayer(final Player player) {
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)Core.getInstance(), new Runnable(){

            @Override
            public void run() {
                MinionPlaceListener.this.players.remove(player);
            }
        }, 5L);
    }
}

