/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.listeners;

import me.jet315.minions.Core;
import me.jet315.minions.MinionAPI;
import me.jet315.minions.events.MinionInteractEvent;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.reflection.ReflectionUtils;
import me.jet315.minions.storage.MinionProperties;
import me.jet315.minions.utils.FoodItem;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;

public class MinionInteractListener
implements Listener {
    @EventHandler
    public void onMinionInteractNameTag(PlayerInteractEntityEvent playerInteractEntityEvent) {
        ArmorStand armorStand;
        if (playerInteractEntityEvent.getPlayer().getInventory().getItemInHand().getType() == Material.NAME_TAG && playerInteractEntityEvent.getRightClicked().getType() == EntityType.ARMOR_STAND && MinionAPI.isMinion((Entity)(armorStand = (ArmorStand)playerInteractEntityEvent.getRightClicked()))) {
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMinionInteract(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        if (playerInteractAtEntityEvent.getRightClicked().getType() == EntityType.ARMOR_STAND) {
            ArmorStand armorStand = (ArmorStand)playerInteractAtEntityEvent.getRightClicked();
            if (MinionAPI.isMinion((Entity)armorStand)) {
                playerInteractAtEntityEvent.setCancelled(true);
            }
            for (Minion minion : Core.getInstance().getMinionManager().getAllMinions()) {
                ItemStack itemStack;
                if (!playerInteractAtEntityEvent.getRightClicked().equals(minion.getMinion().getArmorStand())) continue;
                MinionInteractEvent minionInteractEvent = new MinionInteractEvent(playerInteractAtEntityEvent.getPlayer(), minion);
                Core.getInstance().getServer().getPluginManager().callEvent((Event)minionInteractEvent);
                if (minionInteractEvent.isCancelled()) {
                    return;
                }
                ItemStack itemStack2 = itemStack = ReflectionUtils.isNewVersion ? playerInteractAtEntityEvent.getPlayer().getInventory().getItemInMainHand() : playerInteractAtEntityEvent.getPlayer().getInventory().getItemInHand();
                if (itemStack != null && itemStack.getType() != Material.AIR && minion.isUseHealth()) {
                    for (FoodItem foodItem : Core.getInstance().getProperties().getFoodItems()) {
                        if (foodItem.getItemStack().getType() != itemStack.getType()) continue;
                        if (!ReflectionUtils.isNewVersion && foodItem.getItemStack().getDurability() != itemStack.getData().getData()) break;
                        if (minion.getHealth() >= minion.getMaxHealth()) {
                            playerInteractAtEntityEvent.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getHealNotNeeded());
                            return;
                        }
                        minion.setHealth(minion.getHealth() + foodItem.getHealAmount());
                        if (minion.getHealth() > minion.getMaxHealth()) {
                            minion.setHealth(minion.getMaxHealth());
                        }
                        itemStack.setAmount(itemStack.getAmount() - 1);
                        if (itemStack.getAmount() == 0) {
                            playerInteractAtEntityEvent.getPlayer().getInventory().setItemInHand(new ItemStack(Material.AIR));
                        }
                        playerInteractAtEntityEvent.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getHealSuccessful().replaceAll("%HEALAMOUNT%", String.valueOf(foodItem.getHealAmount())));
                        return;
                    }
                }
                if (!playerInteractAtEntityEvent.getPlayer().getUniqueId().equals(minion.getPlayerUUID()) && !playerInteractAtEntityEvent.getPlayer().hasPermission("minions.admin.*") && !playerInteractAtEntityEvent.getPlayer().hasPermission("minions.admin.viewminion")) continue;
                MinionProperties minionProperties = Core.getInstance().getMinionManager().getMinionProperties().get(minion.getIdentifier());
                playerInteractAtEntityEvent.getPlayer().openInventory(Core.getInstance().getGuiManager().getInventory(playerInteractAtEntityEvent.getPlayer(), minionProperties.getIdentifier(), minionProperties, minion, null));
                return;
            }
        }
    }
}

