/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import me.jet315.minions.Core;
import me.jet315.minions.MinionAPI;
import me.jet315.minions.events.MinionBreakEvent;
import me.jet315.minions.events.MinionPickupEvent;
import me.jet315.minions.manager.MinionPlayer;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.storage.MinionProperties;
import me.jet315.minions.utils.NBTUtils;
import me.jet315.minions.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MinionDestroyListener
implements Listener {
    @EventHandler
    public void minionHurtListener(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity().getType() == EntityType.ARMOR_STAND && MinionAPI.isMinion(entityDamageEvent.getEntity()) && entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void ignite(EntityCombustEvent entityCombustEvent) {
        if (MinionAPI.isMinion(entityCombustEvent.getEntity())) {
            entityCombustEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void minionInteract(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        if (playerInteractAtEntityEvent.getRightClicked().getType() == EntityType.ARMOR_STAND) {
            if (!Core.getInstance().getProperties().getClickTypeToPickupMinion().contains("RIGHT")) {
                return;
            }
            if (Core.getInstance().getProperties().getClickTypeToPickupMinion().contains("SHIFT") ? !playerInteractAtEntityEvent.getPlayer().isSneaking() : playerInteractAtEntityEvent.getPlayer().isSneaking()) {
                return;
            }
            ArmorStand armorStand = (ArmorStand)playerInteractAtEntityEvent.getRightClicked();
            if (MinionAPI.isMinion((Entity)armorStand)) {
                playerInteractAtEntityEvent.setCancelled(true);
            }
            if (!this.minionDestroy(playerInteractAtEntityEvent.getRightClicked(), playerInteractAtEntityEvent.getPlayer())) {
                playerInteractAtEntityEvent.setCancelled(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void minionDestroyListener(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        ArmorStand armorStand;
        if (entityDamageByEntityEvent.getEntity().getType() == EntityType.ARMOR_STAND && MinionAPI.isMinion((Entity)(armorStand = (ArmorStand)entityDamageByEntityEvent.getEntity()))) {
            entityDamageByEntityEvent.setCancelled(true);
            if (!(entityDamageByEntityEvent.getDamager() instanceof Player)) {
                return;
            }
            Player player = (Player)entityDamageByEntityEvent.getDamager();
            if (!Core.getInstance().getProperties().getClickTypeToPickupMinion().contains("LEFT")) {
                this.openMinionInventory(entityDamageByEntityEvent.getEntity(), player);
                return;
            }
            if (Core.getInstance().getProperties().getClickTypeToPickupMinion().contains("SHIFT")) {
                if (!player.isSneaking()) {
                    return;
                }
            } else if (player.isSneaking()) {
                this.openMinionInventory(entityDamageByEntityEvent.getEntity(), player);
                return;
            }
            if (!this.minionDestroy(entityDamageByEntityEvent.getEntity(), player)) {
                entityDamageByEntityEvent.setCancelled(false);
            }
        }
    }

    public void openMinionInventory(Entity entity, Player player) {
        for (Minion minion : Core.getInstance().getMinionManager().getAllMinions()) {
            if (!entity.equals(minion.getMinion().getArmorStand()) || !player.getUniqueId().equals(minion.getPlayerUUID()) && !player.hasPermission("minions.admin.*") && !player.hasPermission("minions.admin.viewminion")) continue;
            MinionProperties minionProperties = Core.getInstance().getMinionManager().getMinionProperties().get(minion.getIdentifier());
            player.openInventory(Core.getInstance().getGuiManager().getInventory(player, minionProperties.getIdentifier(), minionProperties, minion, null));
            return;
        }
    }

    public boolean minionDestroy(final Entity entity, Player player) {
        for (Minion minion : Core.getInstance().getMinionManager().getAllMinions()) {
            Object object22;
            if (!entity.equals(minion.getMinion().getArmorStand())) continue;
            if (!minion.getPlayerUUID().equals(player.getUniqueId()) && !Core.getInstance().getHooks().canForceBreakMinion(minion, player.getPlayer())) break;
            if (minion.getHealth() < minion.getMaxHealth() && Core.getInstance().getProperties().isOnlyAllowMinionPickupIfFullHealth() && !player.isOp()) {
                player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionMustBeFullHealthToDestroy());
                return true;
            }
            MinionBreakEvent minionBreakEvent = new MinionBreakEvent(player, minion);
            Core.getInstance().getServer().getPluginManager().callEvent((Event)minionBreakEvent);
            if (minionBreakEvent.isCancelled()) {
                return true;
            }
            minion.onPickUp();
            MinionProperties minionProperties = Core.getInstance().getMinionManager().getMinionProperties().get(minion.getIdentifier());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("stats", String.valueOf(minion.getStats()));
            hashMap.put("level", String.valueOf(minion.getLevel()));
            hashMap.put("health", String.valueOf(minion.getHealth()));
            hashMap.put("type", minion.getIdentifier());
            hashMap.put("oldName", minion.getOriginalName());
            ItemStack itemStack = NBTUtils.setNBTData(minionProperties.getDisplayItem().clone(), hashMap);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(Utils.putLevelAndStatsPlaceHolder(minion, itemMeta.getDisplayName()));
            ArrayList<String> arrayList = new ArrayList<String>();
            if (itemMeta.getLore() != null && itemMeta.getLore().size() > 0) {
                for (Object object22 : itemMeta.getLore()) {
                    arrayList.add(Utils.putLevelAndStatsPlaceHolder(minion, (String)object22));
                }
                itemMeta.setLore(arrayList);
            }
            itemStack.setItemMeta(itemMeta);
            MinionPickupEvent minionPickupEvent = new MinionPickupEvent(player, itemStack);
            Bukkit.getPluginManager().callEvent((Event)minionPickupEvent);
            if (player.getInventory().firstEmpty() == -1) {
                player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getBreakMinionWithFullInventory());
                entity.getWorld().dropItemNaturally(entity.getLocation(), itemStack);
            } else {
                player.getInventory().addItem(new ItemStack[]{itemStack});
            }
            Core.getInstance().getDataController().getStorage().removeMinionFromDatabase(player.getUniqueId(), minion);
            Bukkit.getScheduler().runTaskLater((Plugin)Core.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Core.getInstance().getDataController().getStorage().removeMinionUUIDFromDatabase(entity.getUniqueId());
                }
            }, 1L);
            Core.getInstance().getMinionManager().removeMinionFromList(minion);
            object22 = null;
            object22 = minion.getPlayerUUID().equals(player.getUniqueId()) ? Core.getInstance().getMinionManager().getMinionPlayer(player.getUniqueId()) : Core.getInstance().getMinionManager().getMinionPlayer(minion.getPlayerUUID());
            if (object22 != null) {
                ((MinionPlayer)object22).getPlayersMinions().remove(minion);
                ArrayList arrayList2 = (ArrayList)((MinionPlayer)object22).getPlayersMinions().clone();
                for (Minion minion2 : arrayList2) {
                    if (!minion2.equals(minion)) continue;
                    ((MinionPlayer)object22).getPlayersMinions().remove(minion2);
                    break;
                }
            }
            entity.remove();
            return true;
        }
        if (player.hasPermission("minions.admin.break")) {
            Core.getInstance().getMinionManager().removeMinionFromList(Core.getInstance().getMinionManager().getMinionByLocation(entity.getLocation()));
            Core.getInstance().getDataController().getStorage().deleteMinionFromDatabase(entity.getLocation(), entity.getUniqueId());
            player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getAdminMinionDestroyMessage());
            entity.remove();
            return false;
        }
        return true;
    }
}

