/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import me.jet315.minions.Core;
import me.jet315.minions.events.MinionLevelUpEvent;
import me.jet315.minions.events.MinionPickupEvent;
import me.jet315.minions.manager.GUIManager;
import me.jet315.minions.manager.MinionGUI;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.reflection.ReflectionUtils;
import me.jet315.minions.storage.MinionProperties;
import me.jet315.minions.storage.gui.GUIItem;
import me.jet315.minions.storage.gui.InventorySettings;
import me.jet315.minions.utils.MinionFace;
import me.jet315.minions.utils.NBTUtils;
import me.jet315.minions.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class InventoryClickListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getInventory() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (ReflectionUtils.isNewVersion && inventoryClickEvent.getRawSlot() == 2 && inventoryClickEvent.getClickedInventory().getType().toString().equalsIgnoreCase("grindstone")) {
            for (MinionProperties object : Core.getInstance().getMinionManager().getMinionProperties().values()) {
                if (!object.isItemStack(inventoryClickEvent.getCurrentItem())) continue;
                inventoryClickEvent.setCancelled(true);
                return;
            }
        }
        for (InventorySettings inventorySettings : Core.getInstance().getGuiManager().getInventorySettings()) {
            if (!inventoryClickEvent.getView().getTitle().equals(inventorySettings.getDisplayName())) continue;
            inventoryClickEvent.setCancelled(true);
            if (!inventoryClickEvent.getClickedInventory().equals(inventoryClickEvent.getView().getTopInventory())) {
                return;
            }
            Player player = (Player)inventoryClickEvent.getWhoClicked();
            GUIManager gUIManager = Core.getInstance().getGuiManager();
            GUIItem gUIItem = null;
            for (GUIItem gUIItem2 : inventorySettings.getGuiItems()) {
                if (gUIItem2.isFillerItem() || gUIItem2.getSlot() != inventoryClickEvent.getRawSlot()) continue;
                gUIItem = gUIItem2;
                break;
            }
            if (gUIItem == null && (gUIItem = inventorySettings.getInventoryFiller()) == null) {
                return;
            }
            String string = gUIItem.getAction().toLowerCase();
            if (inventorySettings.getInventoryIdentifier().equalsIgnoreCase("store")) {
                switch (string) {
                    case "none": {
                        break;
                    }
                    case "close": {
                        player.closeInventory();
                        break;
                    }
                    default: {
                        Object object2;
                        player.closeInventory();
                        String string2 = gUIItem.getAction();
                        MinionProperties minionProperties = Core.getInstance().getMinionManager().getMinionProperties().get(string2);
                        long l = gUIItem.getCost();
                        if (minionProperties == null) {
                            player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.RED + string2 + " is not a valid minions type!");
                            break;
                        }
                        if (Core.getInstance().getHooks().getMinionEco() != null) {
                            if (!(Core.getInstance().getHooks().getMinionEco().getBalance(player) >= (double)l)) {
                                player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionStoreNotEnoughMoney().replaceAll("%MONEYNEEDED%", String.valueOf(l)).replaceAll("%MINIONTYPE%", minionProperties.getMinionNamePlaceholder()));
                                break;
                            }
                        } else {
                            player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getVaultNotInstalled());
                            break;
                        }
                        Core.getInstance().getHooks().getMinionEco().withdraw(player, l);
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("stats", String.valueOf(0));
                        hashMap.put("level", String.valueOf(1));
                        hashMap.put("type", string2);
                        hashMap.put("oldName", minionProperties.getDefaultMinionSkin().getDisplayName());
                        ItemStack itemStack = NBTUtils.setNBTData(minionProperties.getDisplayItem().clone(), hashMap);
                        ItemMeta itemMeta = itemStack.getItemMeta();
                        if (itemMeta.hasDisplayName()) {
                            itemMeta.setDisplayName(itemMeta.getDisplayName().replaceAll("%LEVEL%", "1").replaceAll("%STATS%", "0"));
                        }
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (itemMeta.getLore() != null && itemMeta.getLore().size() > 0) {
                            for (Object object2 : itemMeta.getLore()) {
                                arrayList.add(((String)object2).replaceAll("%LEVEL%", "1").replaceAll("%STATS%", "0"));
                            }
                            itemMeta.setLore(arrayList);
                        }
                        itemStack.setItemMeta(itemMeta);
                        MinionPickupEvent minionPickupEvent = new MinionPickupEvent(player, itemStack);
                        Bukkit.getPluginManager().callEvent((Event)minionPickupEvent);
                        object2 = player.getInventory().addItem(new ItemStack[]{itemStack});
                        if (((HashMap)object2).size() > 0) {
                            for (ItemStack itemStack2 : ((HashMap)object2).values()) {
                                player.getWorld().dropItemNaturally(player.getLocation(), itemStack2);
                            }
                        }
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionStorePurchase().replaceAll("%MONEYNEEDED%", String.valueOf(l)).replaceAll("%MINIONTYPE%", minionProperties.getMinionNamePlaceholder()));
                    }
                }
                return;
            }
            if (inventorySettings.getInventoryIdentifier().equalsIgnoreCase("skins")) {
                switch (string) {
                    case "none": {
                        break;
                    }
                    case "close": {
                        player.closeInventory();
                        return;
                    }
                    case "back": {
                        MinionGUI minionGUI = gUIManager.getPreviousInventorySetting().get(player);
                        player.closeInventory();
                        player.openInventory(gUIManager.getInventory(player, minionGUI.getMinionProperties().getIdentifier(), minionGUI.getMinionProperties(), minionGUI.getMinion(), null));
                        return;
                    }
                    case "default": {
                        gUIManager.getPreviousInventorySetting().get(player).getMinion().setMinionSkin(gUIManager.getPreviousInventorySetting().get(player).getMinionProperties().getDefaultMinionSkin());
                        player.closeInventory();
                        return;
                    }
                    default: {
                        if (Core.getInstance().getSkinManager().getValidMinionSkins().get(gUIItem.getAction()) != null) {
                            if (player.hasPermission("minions.skins.*") || player.hasPermission("minions.skins." + gUIItem.getAction())) {
                                gUIManager.getPreviousInventorySetting().get(player).getMinion().setMinionSkin(Core.getInstance().getSkinManager().getValidMinionSkins().get(gUIItem.getAction()));
                            } else {
                                player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getNoPermissionForSkin().replaceAll("%SKIN%", gUIItem.getAction()));
                            }
                        }
                        player.closeInventory();
                        return;
                    }
                }
                return;
            }
            MinionProperties minionProperties = gUIManager.getPreviousInventorySetting().get(player).getMinionProperties();
            Minion minion = gUIManager.getPreviousInventorySetting().get(player).getMinion();
            if (!inventorySettings.getInventoryIdentifier().equalsIgnoreCase(minion.getIdentifier())) continue;
            switch (string) {
                case "none": {
                    return;
                }
                case "close": {
                    player.closeInventory();
                    return;
                }
                case "rotate_north": {
                    gUIManager.getPreviousInventorySetting().get(player).getMinion().setRotation(MinionFace.NORTH);
                    player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionRotatedMessage().replaceAll("%DIRECTION%", "North"));
                    player.closeInventory();
                    return;
                }
                case "rotate_east": {
                    gUIManager.getPreviousInventorySetting().get(player).getMinion().setRotation(MinionFace.EAST);
                    player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionRotatedMessage().replaceAll("%DIRECTION%", "East"));
                    player.closeInventory();
                    return;
                }
                case "rotate_south": {
                    gUIManager.getPreviousInventorySetting().get(player).getMinion().setRotation(MinionFace.SOUTH);
                    player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionRotatedMessage().replaceAll("%DIRECTION%", "South"));
                    player.closeInventory();
                    return;
                }
                case "rotate_west": {
                    gUIManager.getPreviousInventorySetting().get(player).getMinion().setRotation(MinionFace.WEST);
                    player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionRotatedMessage().replaceAll("%DIRECTION%", "West"));
                    player.closeInventory();
                    return;
                }
                case "rotate": {
                    int n = (int)gUIManager.getPreviousInventorySetting().get(player).getMinion().getMinion().getArmorStand().getLocation().getYaw();
                    if (n >= 360) {
                        n = -90;
                    }
                    gUIManager.getPreviousInventorySetting().get(player).getMinion().setRotation(Utils.getDirection(n += 90));
                    player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionRotatedMessage().replaceAll("%DIRECTION%", minion.getRotation().toString()));
                    player.closeInventory();
                    return;
                }
                case "skins": {
                    player.closeInventory();
                    player.openInventory(gUIManager.getInventory(player, "skins", minionProperties, minion, inventoryClickEvent.getInventory()));
                    return;
                }
                case "attachchest": {
                    if (player.hasPermission("minions.player.linkchest") || player.hasPermission("minions.player.*")) {
                        if (minion.getMinion().hasMinionGotAttachedChest()) {
                            minion.getMinion().setAttachedChest(null);
                            player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getLinkAChestUnattached());
                            Core.getInstance().getDataController().getStorage().updateChestToDatabase(player.getUniqueId(), minion);
                            player.closeInventory();
                            return;
                        }
                        Core.getInstance().getMinionManager().getMinionsToChest().put(player, minion);
                        this.removePlayerFromChest(player);
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getLinkAChestMessage());
                    } else {
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getNoPermission());
                    }
                    player.closeInventory();
                    return;
                }
                case "rename": {
                    if (player.hasPermission("minions.player.rename") || player.hasPermission("minions.player.*")) {
                        Core.getInstance().getMinionManager().getMinionsToRename().put(player, gUIManager.getPreviousInventorySetting().get(player).getMinion());
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getRenameMessage());
                    } else {
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getNoPermission());
                    }
                    player.closeInventory();
                    return;
                }
                case "payheal": {
                    if (minionProperties.isFeedWithMoney()) {
                        if (Core.getInstance().getHooks().getMinionEco() != null) {
                            if (minion.getHealth() >= minion.getMaxHealth()) {
                                player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getHealNotNeeded());
                            } else if (Core.getInstance().getHooks().getMinionEco().getBalance(player) >= (double)minionProperties.getFeedWithMoneyCost()) {
                                Core.getInstance().getHooks().getMinionEco().withdraw(player, minionProperties.getFeedWithMoneyCost());
                                minion.setHealth(minion.getMaxHealth());
                                player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getHealSuccessful().replaceAll("%HEALAMOUNT%", String.valueOf(minion.getMaxHealth())));
                            } else {
                                player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getNotEnoughMoneyToHealMinion().replaceAll("%MONEYNEEDED%", String.valueOf(minionProperties.getFeedWithMoneyCost())));
                            }
                        } else {
                            player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getVaultNotInstalled());
                        }
                    }
                    player.closeInventory();
                    return;
                }
                case "heal": {
                    gUIManager.getPreviousInventorySetting().get(player).getMinion().setHealth(gUIManager.getPreviousInventorySetting().get(player).getMinion().getMaxHealth());
                    player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getHealSuccessful().replaceAll("%HEALAMOUNT%", String.valueOf(gUIManager.getPreviousInventorySetting().get(player).getMinion().getMaxHealth())));
                    player.closeInventory();
                    return;
                }
                case "exp": {
                    int n = gUIManager.getPreviousInventorySetting().get(player).getMinion().getExp();
                    gUIManager.getPreviousInventorySetting().get(player).getMinion().setExp(0);
                    player.closeInventory();
                    if (n <= 0) {
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionNoExpToCollect());
                        return;
                    }
                    player.giveExp(n);
                    player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionExpGiven().replaceAll("%EXP%", String.valueOf(n)));
                    Core.getInstance().getDataController().getStorage().updateLevelToDatabase(player.getUniqueId(), minion);
                    return;
                }
                case "levelup": {
                    player.closeInventory();
                    if (minion.getLevel() >= Core.getInstance().getMinionManager().getMinionFile().get(minion.getIdentifier()).getMaxMinionLevel()) {
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionAlreadyMaxLevel());
                        return;
                    }
                    long l = Core.getInstance().getMinionManager().getMinionFile().get(minion.getIdentifier()).getCostForNextUpgrade(minion.getLevel());
                    if (Core.getInstance().getHooks().getMinionEco() != null) {
                        if (Core.getInstance().getHooks().getMinionEco().getBalance(player) >= (double)l) {
                            MinionLevelUpEvent minionLevelUpEvent = new MinionLevelUpEvent(player, minion, minion.getLevel(), minion.getLevel() + 1, l);
                            Core.getInstance().getServer().getPluginManager().callEvent((Event)minionLevelUpEvent);
                            if (minionLevelUpEvent.isCancelled()) {
                                return;
                            }
                            Core.getInstance().getHooks().getMinionEco().withdraw(player, l);
                            player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMinionManager().getMinionFile().get(minion.getIdentifier()).getUpgradeMessage(minion.getLevel() + 1));
                            minion.setLevel(minion.getLevel() + 1);
                            minion.onLevelUp();
                            Core.getInstance().getDataController().getStorage().updateLevelToDatabase(player.getUniqueId(), minion);
                        } else {
                            player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getNotEnoughMoneyToUpgradeMinion().replaceAll("%MONEYNEEDED%", String.valueOf(l)));
                        }
                    } else {
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getVaultNotInstalled());
                    }
                    return;
                }
            }
            player.closeInventory();
            return;
        }
    }

    private void removePlayerFromChest(final Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)Core.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (Core.getInstance().getMinionManager().getMinionsToChest().containsKey(player)) {
                    Core.getInstance().getMinionManager().getMinionsToChest().remove(player);
                    if (player.isOnline()) {
                        player.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getLinkAChestFail());
                    }
                }
            }
        }, (long)Core.getInstance().getProperties().getChestLinkTimeout() * 20L);
    }
}

