/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.listeners;

import me.jet315.minions.Core;
import me.jet315.minions.minions.Minion;
import org.bukkit.block.Chest;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class ChestListeners
implements Listener {
    @EventHandler
    public void chestClick(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getClickedBlock() != null && playerInteractEvent.getClickedBlock().getState() instanceof Chest && Core.getInstance().getMinionManager().getMinionsToChest().containsKey(playerInteractEvent.getPlayer())) {
            if (!Core.getInstance().getHooks().canUseBlock(playerInteractEvent.getPlayer(), playerInteractEvent.getClickedBlock())) {
                playerInteractEvent.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getNoPermission());
                return;
            }
            playerInteractEvent.setCancelled(true);
            Minion minion = Core.getInstance().getMinionManager().getMinionsToChest().get(playerInteractEvent.getPlayer());
            if (Core.getInstance().getProperties().getMaximumChestDistanceFromMinion() != -1) {
                if (minion.getMinion().getArmorStand().getWorld() != playerInteractEvent.getClickedBlock().getWorld()) {
                    playerInteractEvent.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionChestToFar().replaceAll("%RANGEPLACED%", String.valueOf("UNKNOWN")).replaceAll("%REQUIREDRANGE%", String.valueOf(Core.getInstance().getProperties().getMaximumChestDistanceFromMinion())));
                    return;
                }
                int n = (int)minion.getMinion().getArmorStand().getLocation().distance(playerInteractEvent.getClickedBlock().getLocation());
                if (n >= Core.getInstance().getProperties().getMaximumChestDistanceFromMinion()) {
                    playerInteractEvent.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getMinionChestToFar().replaceAll("%RANGEPLACED%", String.valueOf(n)).replaceAll("%REQUIREDRANGE%", String.valueOf(Core.getInstance().getProperties().getMaximumChestDistanceFromMinion())));
                    return;
                }
            }
            playerInteractEvent.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getLinkAChestSuccess());
            Chest chest = (Chest)playerInteractEvent.getClickedBlock().getState();
            minion.getMinion().setAttachedChest(chest);
            Core.getInstance().getDataController().getStorage().updateChestToDatabase(playerInteractEvent.getPlayer().getUniqueId(), minion);
            Core.getInstance().getMinionManager().getMinionsToChest().remove(playerInteractEvent.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void chestBreak(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.getBlock().getState() instanceof Chest) {
            for (Minion minion : Core.getInstance().getMinionManager().getAllMinions()) {
                Chest chest;
                if (!minion.getMinion().isChestChunkLoaded() || (chest = minion.getMinion().getAttachedChest()) == null || !blockBreakEvent.getBlock().getWorld().getName().equalsIgnoreCase(chest.getBlock().getWorld().getName()) || blockBreakEvent.getBlock().getX() != chest.getX() || blockBreakEvent.getBlock().getY() != chest.getY() || blockBreakEvent.getBlock().getZ() != chest.getZ()) continue;
                minion.getMinion().setAttachedChest(null);
                blockBreakEvent.getPlayer().sendMessage(Core.getInstance().getProperties().getPluginPrefix() + Core.getInstance().getMessages().getLinkChestBroken());
                Core.getInstance().getDataController().getStorage().updateChestToDatabase(blockBreakEvent.getPlayer().getUniqueId(), minion);
            }
        }
    }
}

