/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.hooks;

import java.util.ArrayList;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.hooks.ProtectionPluginHook;
import me.jet315.minions.minions.Minion;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.events.island.IslandDeleteEvent;
import world.bentobox.bentobox.api.events.team.TeamKickEvent;
import world.bentobox.bentobox.api.events.team.TeamLeaveEvent;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;

public class BentoBoxHook
implements ProtectionPluginHook,
Listener {
    @Override
    public JavaPlugin getPluginHook() {
        return null;
    }

    @Override
    public boolean canBuild(Player player, Location location) {
        if (BentoBox.getInstance().getIslands().getIslandAt(location).isPresent()) {
            Island island = (Island)BentoBox.getInstance().getIslands().getIslandAt(location).get();
            if (island.getCenter() != null && island.getCenter().equals((Object)location)) {
                return Core.getInstance().getMinionManager().getMinionFile().get("Miner").getBooleanValue("BentoBoxMineCentreBlock", false) && island.isAllowed(BentoBox.getInstance().getPlayers().getUser(player.getUniqueId()), Flags.PLACE_BLOCKS);
            }
            if (island.isAllowed(BentoBox.getInstance().getPlayers().getUser(player.getUniqueId()), Flags.PLACE_BLOCKS)) {
                return true;
            }
        }
        return false;
    }

    @EventHandler
    private void onIslandDelete(IslandDeleteEvent islandDeleteEvent) {
        UUID uUID = islandDeleteEvent.getPlayerUUID();
        Island island = islandDeleteEvent.getIsland();
        this.deletePlayerMinionFromIsland(uUID, island);
    }

    @EventHandler
    private void onTeamKick(TeamKickEvent teamKickEvent) {
        Island island = teamKickEvent.getIsland();
        UUID uUID = teamKickEvent.getPlayerUUID();
        this.deletePlayerMinionFromIsland(uUID, island);
    }

    @EventHandler
    private void onTeamLeave(TeamLeaveEvent teamLeaveEvent) {
        Island island = teamLeaveEvent.getIsland();
        UUID uUID = teamLeaveEvent.getPlayerUUID();
        this.deletePlayerMinionFromIsland(uUID, island);
    }

    private void deletePlayerMinionFromIsland(UUID uUID, Island island) {
        ArrayList<Minion> arrayList = new ArrayList<Minion>();
        for (Minion minion : Core.getInstance().getMinionManager().getAllMinions()) {
            if (!island.inIslandSpace(minion.getMinion().getLoc()) || !minion.getPlayerUUID().toString().equalsIgnoreCase(uUID.toString())) continue;
            arrayList.add(minion);
        }
        for (Minion minion : arrayList) {
            Core.getInstance().getDataController().getStorage().deleteMinionFromDatabase(minion.getMinion().getLoc(), null);
            Core.getInstance().getMinionManager().removeMinionFromList(minion);
        }
    }
}

