/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.commands;

import java.util.ArrayList;
import me.jet315.minions.Core;
import me.jet315.minions.commands.CommandExecutor;
import me.jet315.minions.manager.MinionPlayer;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class ListCommand
extends CommandExecutor {
    public ListCommand() {
        this.setCommand("list");
        this.setLength(2);
        this.setBoth();
        this.setPermission("minions.admin.list");
        this.setUsage("/JetsMinions list <player>");
    }

    @Override
    public void execute(CommandSender commandSender, String[] stringArray) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)stringArray[1]);
        if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
            commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.RED + "Unknown player " + stringArray[1]);
            return;
        }
        if (offlinePlayer.isOnline()) {
            MinionPlayer minionPlayer = Core.getInstance().getMinionManager().getMinionPlayer(offlinePlayer.getUniqueId());
            ArrayList<Minion> arrayList = minionPlayer.getPlayersMinions();
            if (arrayList.size() == 0) {
                commandSender.sendMessage(Utils.translateColorCodes("&aThe user has no minions"));
                return;
            }
            int n = 1;
            for (Minion minion : arrayList) {
                Location location = minion.getMinion().getLoc();
                commandSender.sendMessage(Utils.translateColorCodes("&c" + n + ".&a " + minion.getIdentifier() + " &bX:" + location.getBlockX() + " Y:" + location.getBlockY() + " Z: " + location.getBlockZ() + " WORLD:" + location.getWorld().getName()));
                ++n;
            }
            return;
        }
        ArrayList<Location> arrayList = Core.getInstance().getDataController().getStorage().getMinionLocationsFromUUID(offlinePlayer.getUniqueId());
        if (arrayList.size() == 0) {
            commandSender.sendMessage(Utils.translateColorCodes("&aThe user has no minions"));
            return;
        }
        commandSender.sendMessage(Utils.translateColorCodes("&aThe user &b" + offlinePlayer.getName() + "&a has &b" + arrayList.size() + "&a minion(s)"));
        int n = 1;
        for (Location location : arrayList) {
            commandSender.sendMessage(Utils.translateColorCodes("&c" + n + ".&b X:" + location.getBlockX() + " Y:" + location.getBlockY() + " Z: " + location.getBlockZ() + " WORLD:" + location.getWorld().getName()));
            ++n;
        }
    }
}

