/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.commands;

import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.MinionAPI;
import me.jet315.minions.commands.CommandExecutor;
import me.jet315.minions.minions.Minion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class DebugCommand
extends CommandExecutor {
    public DebugCommand() {
        this.setCommand("debug");
        this.setLength(1);
        this.setPlayer();
        this.setPermission("minions.admin.debug");
        this.setUsage("/JetsMinions debug");
    }

    @Override
    public void execute(CommandSender commandSender, String[] stringArray) {
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "There are currently " + Core.getInstance().getMinionManager().getAllMinions().size() + " Minions on the server");
        ArmorStand armorStand = (ArmorStand)this.getEntity((Player)commandSender);
        if (armorStand == null) {
            commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.RED + "No ArmorStand can be found infront of you");
            return;
        }
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "ArmorStand UUID is " + armorStand.getUniqueId());
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "Armourstand location is " + armorStand.getLocation().getWorld() + "," + armorStand.getLocation().getX() + "," + armorStand.getLocation().getY() + "," + armorStand.getLocation().getZ());
        boolean bl = MinionAPI.isMinion((Entity)armorStand);
        if (!bl) {
            commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.RED + "ArmorStand UUID cannot be found within the players.yml config");
            return;
        }
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "ArmorStand is a possible Minion");
        Minion minion = Core.getInstance().getMinionManager().getMinionByLocation(armorStand.getLocation());
        if (minion == null) {
            commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.RED + "No minion object can be found for this Minion, so minion will not work");
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)minion.getPlayerUUID());
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "Minion is owned by: " + minion.getPlayerUUID() + " (" + (offlinePlayer == null ? "NULL" : offlinePlayer.getName()) + ")");
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "Minion is active: " + minion.isMinionLoaded());
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "Minions Health: " + minion.getHealth() + "/" + minion.getMaxHealth() + (minion.getHealth() == 0 ? ChatColor.RED + "(NEEDS FEEDING)" : ""));
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "Minion has attached chest: " + minion.getMinion().hasMinionGotAttachedChest());
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "Minions type | Level | Stats: " + minion.getIdentifier() + " | " + minion.getLevel() + " | " + minion.getStats());
    }

    private boolean getLookingAt(Player player, LivingEntity livingEntity) {
        Location location = player.getEyeLocation();
        Vector vector = livingEntity.getEyeLocation().toVector().subtract(location.toVector());
        double d = vector.normalize().dot(location.getDirection());
        return d > 0.99;
    }

    private Entity getEntity(Player player) {
        for (Entity entity : player.getNearbyEntities(10.0, 5.0, 10.0)) {
            if (entity.getType() != EntityType.ARMOR_STAND || !this.getLookingAt(player, (LivingEntity)entity)) continue;
            return entity;
        }
        return null;
    }
}

