/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions.commands;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import me.jet315.minions.Core;
import me.jet315.minions.MinionAPI;
import me.jet315.minions.commands.CommandExecutor;
import me.jet315.minions.manager.MinionPlayer;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.storage.database.DatabaseType;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CleanUpCommand
extends CommandExecutor {
    public CleanUpCommand() {
        this.setCommand("cleanup");
        this.setLength(1);
        this.setBoth();
        this.setPermission("minions.admin.cleanup");
        this.setUsage("/JetsMinions cleanup");
    }

    @Override
    public void execute(final CommandSender commandSender, String[] stringArray) {
        Serializable serializable;
        if (Core.getInstance().getProperties().getDatabaseType() == DatabaseType.MYSQL) {
            commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.RED + "Unable to do this command while database type is MYSQL");
            return;
        }
        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.RED + "Backing up players.yml, this cleanup process can take a while on larger servers");
        try {
            serializable = new File(Core.getInstance().getDataFolder() + File.separator + "backup/");
            if (!((File)serializable).exists()) {
                ((File)serializable).mkdirs();
            }
            Files.copy(new File(Core.getInstance().getDataFolder() + File.separator + "players.yml").toPath(), new File(((File)serializable).getPath() + File.separator + "backup_" + System.currentTimeMillis() + "_players.yml").toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            System.out.println(exception);
            commandSender.sendMessage(ChatColor.RED + "Unable to backup players.yml file");
            return;
        }
        serializable = Core.getInstance().getDataController().getStorage().getLocationOfAllMinions();
        if (((ArrayList)serializable).size() == 0) {
            commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "Cleanup Complete..");
            return;
        }
        ArrayList arrayList = new ArrayList();
        new BukkitRunnable((ArrayList)serializable, arrayList){
            int counter = 0;
            int cleanUps = 0;
            final /* synthetic */ ArrayList val$locs;
            final /* synthetic */ ArrayList val$uuidsToKeep;
            {
                this.val$locs = arrayList;
                this.val$uuidsToKeep = arrayList2;
            }

            public void run() {
                if (this.counter % 60 == 0 && this.counter != 0) {
                    commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.RED + this.counter + " Minions have been checked..");
                }
                if (this.counter >= this.val$locs.size()) {
                    Core.getInstance().getDataController().getStorage().updateMinionUUIDList(this.val$uuidsToKeep);
                    commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.GREEN + "Cleanup complete... " + this.cleanUps + " minions were purged, " + this.val$uuidsToKeep.size() + " minions were kept");
                    this.cancel();
                    return;
                }
                Location location = (Location)this.val$locs.get(this.counter);
                ++this.counter;
                try {
                    if (location.getWorld() != null) {
                        location.getChunk().load();
                        boolean bl = false;
                        for (Entity entity : location.getWorld().getNearbyEntities(location, 0.1, 0.1, 0.1)) {
                            if (!MinionAPI.isMinion(entity)) continue;
                            if (!this.val$uuidsToKeep.contains(entity.getUniqueId())) {
                                this.val$uuidsToKeep.add(entity.getUniqueId());
                            }
                            bl = true;
                        }
                        if (bl) {
                            return;
                        }
                    }
                    Core.getInstance().getDataController().getStorage().deleteMinionFromDatabase(location, null);
                    Minion minion = Core.getInstance().getMinionManager().getMinionByLocation(location);
                    if (minion != null) {
                        commandSender.sendMessage(Core.getInstance().getProperties().getPluginPrefix() + ChatColor.RED + "Purged minion located at: " + location.getWorld().getName().toString() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ());
                        Core.getInstance().getMinionManager().removeMinionFromList(minion);
                        MinionPlayer minionPlayer = Core.getInstance().getMinionManager().getMinionPlayer(minion.getPlayerUUID());
                        if (minionPlayer != null) {
                            minionPlayer.getPlayersMinions().remove(minion);
                        }
                        ++this.cleanUps;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.runTaskTimer((Plugin)Core.getInstance(), 1L, 1L);
    }
}

