/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions;

import java.util.ArrayList;
import java.util.UUID;
import me.jet315.minions.Core;
import me.jet315.minions.manager.MinionPlayer;
import me.jet315.minions.minions.Minion;
import me.jet315.minions.utils.MinionPermission;
import me.jet315.minions.utils.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MinionAPI {
    public static Core getInstance() {
        return Core.getInstance();
    }

    public static boolean isMinion(Entity entity) {
        if (entity instanceof ArmorStand) {
            if (!((ArmorStand)entity).isVisible()) {
                return false;
            }
            if (!Core.getInstance().getProperties().isStoreMinionUUIDS() && ((ArmorStand)entity).isSmall() && !((ArmorStand)entity).hasBasePlate() && ((ArmorStand)entity).hasArms() && ((ArmorStand)entity).getHelmet().getType() != null && ((ArmorStand)entity).getHelmet().getType() == XMaterial.PLAYER_HEAD.parseMaterial()) {
                return true;
            }
            if (Core.getInstance().getProperties().isStoreMinionUUIDS() && MinionAPI.getInstance().getDataController().getStorage().isEntityMinion(entity)) {
                return true;
            }
        }
        return false;
    }

    public static Minion getMinion(Entity entity) {
        for (Minion minion : Core.getInstance().getMinionManager().getAllMinions()) {
            if (!entity.equals(minion.getMinion().getArmorStand())) continue;
            return minion;
        }
        return null;
    }

    public static ArrayList<Minion> getPlayersMinions(UUID uUID) {
        return Core.getInstance().getMinionManager().getMinionPlayer(uUID).getPlayersMinions();
    }

    public static int getMaximumAllowedMinions(Player player, String string) {
        if (player == null) {
            return -1;
        }
        if (!player.hasPermission("minions.admin.bypasslimit") || player.hasPermission("minions.admin.*")) {
            int n = 0;
            int n2 = -1;
            for (MinionPermission minionPermission : Core.getInstance().getProperties().getMinionPermissions()) {
                if (!player.hasPermission(minionPermission.getPermission()) && !player.hasPermission(minionPermission.getPermission() + ":" + minionPermission.getAllowedMinions())) continue;
                if (minionPermission.getAllowedMinions() > n) {
                    n = minionPermission.getAllowedMinions();
                }
                if (string == null || !minionPermission.getPermission().contains(string) || !player.hasPermission(minionPermission.getPermission()) && !player.hasPermission(minionPermission.getPermission() + ":" + minionPermission.getAllowedMinions()) || minionPermission.getAllowedMinions() <= n2) continue;
                n2 = minionPermission.getAllowedMinions();
            }
            if (n2 != -1) {
                return n2;
            }
            return n;
        }
        return 999;
    }

    public static boolean isPlayerAllowedToPlaceMinion(MinionPlayer minionPlayer, String string) {
        Player player = Bukkit.getPlayer((UUID)minionPlayer.getPlayerUUID());
        if (player == null) {
            return false;
        }
        if (!player.hasPermission("minions.admin.bypasslimit") || player.hasPermission("minions.admin.*")) {
            int n = 0;
            int n2 = -1;
            for (MinionPermission minionPermission : Core.getInstance().getProperties().getMinionPermissions()) {
                if (!player.hasPermission(minionPermission.getPermission()) && !player.hasPermission(minionPermission.getPermission() + ":" + minionPermission.getAllowedMinions())) continue;
                if (minionPermission.getAllowedMinions() > n) {
                    n = minionPermission.getAllowedMinions();
                }
                if (string == null || !minionPermission.getPermission().contains(string) || !player.hasPermission(minionPermission.getPermission()) && !player.hasPermission(minionPermission.getPermission() + ":" + minionPermission.getAllowedMinions()) || minionPermission.getAllowedMinions() <= n2) continue;
                n2 = minionPermission.getAllowedMinions();
            }
            if (n2 != -1) {
                int n3 = MinionAPI.getTotalMinionsOfType(minionPlayer.getPlayerUUID(), string);
                return n3 < n2 && minionPlayer.getTotalMinions() < n;
            }
            return minionPlayer.getTotalMinions() < n;
        }
        return true;
    }

    public static int getTotalMinions(UUID uUID) {
        MinionPlayer minionPlayer = Core.getInstance().getMinionManager().getMinionPlayer(uUID);
        if (minionPlayer == null) {
            return -1;
        }
        int n = 0;
        return minionPlayer.getTotalMinions() + n;
    }

    public static int getTotalMinionsOfType(UUID uUID, String string) {
        int n = 0;
        for (Minion minion : Core.getInstance().getMinionManager().getAllMinions()) {
            if (!minion.getPlayerUUID().equals(uUID) || !minion.getIdentifier().equalsIgnoreCase(string) && !string.equalsIgnoreCase("*")) continue;
            ++n;
        }
        return n;
    }

    @Deprecated
    public static int currentMinions(Player player) {
        return MinionAPI.getTotalMinionsOfType(player.getUniqueId(), "*");
    }

    @Deprecated
    public static int currentMinionType(Player player, String string) {
        return MinionAPI.getTotalMinionsOfType(player.getUniqueId(), string);
    }
}

