/*
 * Decompiled with CFR 0.152.
 */
package me.jet315.minions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import me.jet315.minions.commands.CommandHandler;
import me.jet315.minions.hooks.Hooks;
import me.jet315.minions.listeners.ChatListener;
import me.jet315.minions.listeners.ChestListeners;
import me.jet315.minions.listeners.CraftingListener;
import me.jet315.minions.listeners.InventoryClickListener;
import me.jet315.minions.listeners.InventoryCloseListener;
import me.jet315.minions.listeners.MinionDestroyListener;
import me.jet315.minions.listeners.MinionEnterVehicleListener;
import me.jet315.minions.listeners.MinionInteractListener;
import me.jet315.minions.listeners.MinionPlaceListener;
import me.jet315.minions.listeners.PistonListener;
import me.jet315.minions.listeners.ResurrectEventListener;
import me.jet315.minions.loader.ExternalClassLoader;
import me.jet315.minions.loader.SkinLoader;
import me.jet315.minions.manager.GUIManager;
import me.jet315.minions.manager.MinionManager;
import me.jet315.minions.manager.MinionTask;
import me.jet315.minions.manager.SkinManager;
import me.jet315.minions.minions.types.CollectorMinion;
import me.jet315.minions.minions.types.FarmerMinion;
import me.jet315.minions.minions.types.FeederMinion;
import me.jet315.minions.minions.types.FisherMinion;
import me.jet315.minions.minions.types.LumberjackMinion;
import me.jet315.minions.minions.types.MinerMinion;
import me.jet315.minions.minions.types.SellerMinion;
import me.jet315.minions.minions.types.SlayerMinion;
import me.jet315.minions.reflection.ReflectionUtils;
import me.jet315.minions.storage.ConfigUpdater;
import me.jet315.minions.storage.ControlPanel;
import me.jet315.minions.storage.Messages;
import me.jet315.minions.storage.MinionSkins;
import me.jet315.minions.storage.MinionStore;
import me.jet315.minions.storage.Properties;
import me.jet315.minions.storage.database.DataController;
import me.jet315.minions.web.Metrics;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Core
extends JavaPlugin {
    private static Core instance;
    private MinionManager minionManager;
    private GUIManager guiManager;
    private SkinManager skinManager;
    private MinionTask minionTask;
    private Properties properties;
    private MinionStore store;
    private MinionSkins minionSkin;
    private ControlPanel controlPanel;
    private Messages messages;
    private Hooks hooks;
    private DataController dataController;
    public static Economy economy;

    public void onEnable() {
        Core.loadConfig0();
        long l = System.currentTimeMillis();
        Bukkit.getLogger().log(Level.INFO, "[JetsMinions] Initialising Plugin v" + this.getDescription().getVersion() + "...");
        instance = this;
        new Metrics();
        new ConfigUpdater(this);
        this.skinManager = new SkinManager();
        this.minionManager = new MinionManager();
        this.guiManager = new GUIManager();
        this.hooks = new Hooks("hooks.yml", this);
        this.minionSkin = new MinionSkins("skins.yml", this);
        this.properties = new Properties("config.yml", this);
        this.messages = new Messages("messages.yml", this);
        this.controlPanel = new ControlPanel("controlpanel.yml", this);
        this.dataController = new DataController();
        this.store = new MinionStore("store.yml", this);
        this.minionManager.registerMinion(MinerMinion.class);
        this.minionManager.registerMinion(SlayerMinion.class);
        this.minionManager.registerMinion(CollectorMinion.class);
        this.minionManager.registerMinion(FeederMinion.class);
        this.minionManager.registerMinion(LumberjackMinion.class);
        this.minionManager.registerMinion(FarmerMinion.class);
        this.minionManager.registerMinion(FisherMinion.class);
        this.minionManager.registerMinion(SellerMinion.class);
        new ExternalClassLoader(this);
        this.getCommand("jetsminions").setExecutor((CommandExecutor)new CommandHandler());
        this.setupEconomy();
        this.registerListeners();
        if (this.properties.isDelayMinionLoading()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.getDataController().getStorage().loadMinions(), 100L);
        } else {
            this.getDataController().getStorage().loadMinions();
        }
        this.minionTask = new MinionTask();
        Bukkit.getLogger().log(Level.INFO, "[JetsMinions] Initialising Complete in " + String.valueOf(System.currentTimeMillis() - l) + "ms");
    }

    public void onDisable() {
        this.dataController.getStorage().onShutdownSave();
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        SkinLoader.saveCacheToConfig();
        this.minionTask = null;
        this.minionManager = null;
        this.hooks = null;
        this.messages = null;
        this.properties = null;
        this.skinManager = null;
        this.store = null;
    }

    public void reloadConfiguration() {
        this.hooks = null;
        this.messages = null;
        this.properties = null;
        this.skinManager = null;
        this.minionSkin = null;
        this.controlPanel = null;
        this.store = null;
        this.skinManager = new SkinManager();
        this.guiManager = new GUIManager();
        this.minionSkin = new MinionSkins("skins.yml", this);
        this.properties = new Properties("config.yml", this);
        this.messages = new Messages("messages.yml", this);
        this.hooks = new Hooks("hooks.yml", this);
        this.controlPanel = new ControlPanel("controlpanel.yml", this);
        this.store = new MinionStore("store.yml", this);
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)new MinionPlaceListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new MinionInteractListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new MinionDestroyListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryCloseListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CraftingListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ChestListeners(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PistonListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new MinionEnterVehicleListener(), (Plugin)this);
        if (ReflectionUtils.isNewVersion) {
            Bukkit.getPluginManager().registerEvents((Listener)new ResurrectEventListener(), (Plugin)this);
        }
    }

    private boolean setupEconomy() {
        if (this.hooks.isUseVault()) {
            try {
                RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
                if (registeredServiceProvider != null) {
                    economy = (Economy)registeredServiceProvider.getProvider();
                }
                return economy != null;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return false;
            }
        }
        economy = null;
        return false;
    }

    public void resetMinionTasks() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.minionTask = null;
        this.minionTask = new MinionTask();
    }

    public static Core getInstance() {
        return instance;
    }

    public MinionManager getMinionManager() {
        return this.minionManager;
    }

    public MinionTask getMinionTask() {
        return this.minionTask;
    }

    public SkinManager getSkinManager() {
        return this.skinManager;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public Hooks getHooks() {
        return this.hooks;
    }

    public GUIManager getGuiManager() {
        return this.guiManager;
    }

    public MinionStore getStore() {
        return this.store;
    }

    public MinionSkins getMinionSkin() {
        return this.minionSkin;
    }

    public DataController getDataController() {
        return this.dataController;
    }

    static {
        economy = null;
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=1376090&resource_id=59972&nonce=2024426115").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

