/*
 * Decompiled with CFR 0.152.
 */
package net.Indyuce.mmocore.skill.cast.handler;

import io.lumine.mythic.lib.MythicLib;
import io.lumine.mythic.lib.UtilityMethods;
import io.lumine.mythic.lib.api.player.EquipmentSlot;
import io.lumine.mythic.lib.player.PlayerMetadata;
import io.lumine.mythic.lib.skill.trigger.TriggerMetadata;
import io.lumine.mythic.lib.util.SoundObject;
import java.util.Objects;
import javax.annotation.Nullable;
import net.Indyuce.mmocore.MMOCore;
import net.Indyuce.mmocore.api.event.PlayerKeyPressEvent;
import net.Indyuce.mmocore.api.player.PlayerData;
import net.Indyuce.mmocore.skill.ClassSkill;
import net.Indyuce.mmocore.skill.cast.PlayerKey;
import net.Indyuce.mmocore.skill.cast.SkillCastingHandler;
import net.Indyuce.mmocore.skill.cast.SkillCastingInstance;
import net.Indyuce.mmocore.skill.cast.SkillCastingMode;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.jetbrains.annotations.NotNull;

public class SkillScroller
extends SkillCastingHandler {
    private final PlayerKey enterKey;
    private final PlayerKey castKey;
    @Nullable
    private final SoundObject enterSound;
    @Nullable
    private final SoundObject changeSound;
    @Nullable
    private final SoundObject leaveSound;
    private final String actionBarFormat;

    public SkillScroller(@NotNull ConfigurationSection config) {
        super(config);
        this.enterSound = config.contains("sound.enter") ? new SoundObject(config.getConfigurationSection("sound.enter")) : null;
        this.changeSound = config.contains("sound.change") ? new SoundObject(config.getConfigurationSection("sound.change")) : null;
        this.leaveSound = config.contains("sound.leave") ? new SoundObject(config.getConfigurationSection("sound.leave")) : null;
        this.actionBarFormat = config.getString("action-bar-format", "CLICK TO CAST: {selected}");
        this.enterKey = PlayerKey.valueOf(UtilityMethods.enumName((String)Objects.requireNonNull(config.getString("enter-key"), "Could not find enter key")));
        this.castKey = PlayerKey.valueOf(UtilityMethods.enumName((String)Objects.requireNonNull(config.getString("cast-key"), "Could not find cast key")));
    }

    @Override
    public SkillCastingInstance newInstance(@NotNull PlayerData player) {
        return new CustomSkillCastingInstance(player);
    }

    @Override
    public SkillCastingMode getCastingMode() {
        return SkillCastingMode.SKILL_SCROLLER;
    }

    @EventHandler
    public void whenPressingKey(PlayerKeyPressEvent event) {
        PlayerData playerData = event.getData();
        Player player = playerData.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE && !MMOCore.plugin.configManager.canCreativeCast) {
            return;
        }
        if (event.getPressed() == this.enterKey) {
            if (playerData.isCasting()) {
                if (event.getPressed().shouldCancelEvent()) {
                    event.setCancelled(true);
                }
                if (!playerData.leaveSkillCasting()) {
                    return;
                }
                if (this.leaveSound != null) {
                    this.leaveSound.playTo(player);
                }
                return;
            }
            if (!playerData.hasActiveSkillBound()) {
                return;
            }
            if (event.getPressed().shouldCancelEvent()) {
                event.setCancelled(true);
            }
            if (!playerData.setSkillCasting()) {
                return;
            }
            if (this.enterSound != null) {
                this.enterSound.playTo(player);
            }
        }
        if (event.getPressed() == this.castKey && playerData.isCasting()) {
            if (event.getPressed().shouldCancelEvent()) {
                event.setCancelled(true);
            }
            CustomSkillCastingInstance casting = (CustomSkillCastingInstance)playerData.getSkillCasting();
            PlayerMetadata caster = playerData.getMMOPlayerData().getStatMap().cache(EquipmentSlot.MAIN_HAND);
            casting.getSelected().toCastable(playerData).cast(new TriggerMetadata(caster, null, null));
        }
    }

    private int mod(int x, int n) {
        while (x < 0) {
            x += n;
        }
        while (x >= n) {
            x -= n;
        }
        return x;
    }

    public class CustomSkillCastingInstance
    extends SkillCastingInstance {
        private int index;

        CustomSkillCastingInstance(PlayerData caster) {
            super(SkillScroller.this, caster);
            this.index = 0;
        }

        @Override
        public void onTick() {
            String skillName = this.getSelected().getSkill().getName();
            String actionBarFormat = MythicLib.plugin.getPlaceholderParser().parse((OfflinePlayer)this.getCaster().getPlayer(), SkillScroller.this.actionBarFormat.replace("{selected}", skillName));
            this.getCaster().displayActionBar(actionBarFormat);
        }

        public ClassSkill getSelected() {
            return this.getActiveSkills().get(this.index).getClassSkill();
        }

        @EventHandler
        public void onScroll(PlayerItemHeldEvent event) {
            if (!event.getPlayer().equals((Object)this.getCaster().getPlayer())) {
                return;
            }
            PlayerData playerData = PlayerData.get((OfflinePlayer)event.getPlayer());
            if (!playerData.hasActiveSkillBound()) {
                playerData.leaveSkillCasting(true);
                return;
            }
            event.setCancelled(true);
            int previous = event.getPreviousSlot();
            int current = event.getNewSlot();
            int dist1 = 9 + current - previous;
            int dist2 = current - previous;
            int dist3 = current - previous - 9;
            int change = Math.abs(dist1) < Math.abs(dist2) ? (Math.abs(dist1) < Math.abs(dist3) ? dist1 : dist3) : (Math.abs(dist3) < Math.abs(dist2) ? dist3 : dist2);
            CustomSkillCastingInstance casting = (CustomSkillCastingInstance)playerData.getSkillCasting();
            casting.index = SkillScroller.this.mod(casting.index + change, this.getActiveSkills().size());
            casting.onTick();
            casting.refreshTimeOut();
            if (SkillScroller.this.changeSound != null) {
                SkillScroller.this.changeSound.playTo(event.getPlayer());
            }
        }
    }
}

